/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorPatternPanel
extends JPanel {
    private PatternView patternView;
    private PatternChoices patternIcon;
    private Info currentLI;
    private boolean dataChanging = false;
    private boolean showPrinter;
    private Color[] colorMap;
    private JColorChooser colorChooser;
    private MyPreviewPanel colorPreviewPanel;
    private boolean warnedOfTransparentLayerSharing;
    private String otherTransparentLayers;
    private Map<EGraphics.Outline, ImageIcon> outlineImageIcons = new HashMap<EGraphics.Outline, ImageIcon>();
    private static final int[] preDefinedPatterns = new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 52428, 52428, 13107, 13107, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 43690, 24672, 37008, 37008, 24672, 1542, 2313, 2313, 1542, 24672, 37008, 37008, 24672, 1542, 2313, 2313, 1542, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 17476, 4369, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 16448, 32896, 257, 514, 257, 32896, 16448, 8224, 16448, 32896, 257, 514, 257, 32896, 16448, 8224, 8224, 0, 32896, 0, 514, 0, 2056, 0, 8224, 0, 32896, 0, 514, 0, 2056, 0, 2056, 0, 514, 0, 32896, 0, 8224, 0, 2056, 0, 514, 0, 32896, 0, 8224, 0, 0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336, 7196, 15934, 13878, 15934, 7196, 0, 0, 0, 7196, 15934, 13878, 15934, 7196, 0, 0, 0, 0, 52428, 0, 52428, 0, 0, 0, 0, 0, 52428, 0, 52428, 0, 0, 0, 0, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 8738, 34952, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 0, 4369, 0, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 17476, 34952, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 8738, 21845, 8738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535};
    private static final int SAMPLEWID = 60;
    private static final int SAMPLEHEI = 11;
    private JPanel color;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel40;
    private JLabel jLabel50;
    private JTextField opacity;
    private JLabel opacityLabel;
    private JComboBox outlinePattern;
    private JPanel pattern;
    private JComboBox transparentLayer;
    private JCheckBox useStipplePatternDisplay;
    private JCheckBox useStipplePatternPrinter;

    public ColorPatternPanel(boolean showPrinter) {
        this.initComponents();
        this.showPrinter = showPrinter;
        this.warnedOfTransparentLayerSharing = false;
        this.useStipplePatternDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.layerInfoChanged();
            }
        });
        for (EGraphics.Outline o : EGraphics.Outline.getOutlines()) {
            ImageIcon imageIcon = this.getSample(o);
            this.outlineImageIcons.put(o, imageIcon);
            this.outlinePattern.addItem(imageIcon);
        }
        this.outlinePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.layerInfoChanged();
            }
        });
        this.transparentLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorPatternPanel.this.transparentLayerChanged();
            }
        });
        this.transparentLayer.addItem("NOT TRANSPARENT");
        int[] transLayers = EGraphics.getTransparentColorIndices();
        for (int i = 0; i < transLayers.length; ++i) {
            this.transparentLayer.addItem(EGraphics.getColorIndexName(transLayers[i]));
        }
        this.patternView = new PatternView(this.currentLI, this.useStipplePatternDisplay, this.outlinePattern);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 4, 4, 4);
        this.pattern.add((Component)this.patternView, gbc);
        this.patternIcon = new PatternChoices();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 4, 2, 4);
        this.pattern.add((Component)this.patternIcon, gbc);
        this.colorChooser = new JColorChooser();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        this.color.add((Component)this.colorChooser, gbc);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorPatternPanel.this.colorChanged();
            }
        });
        this.colorChooser.setPreviewPanel(new JPanel());
        this.colorPreviewPanel = new MyPreviewPanel(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.color.add((Component)this.colorPreviewPanel, gbc);
        if (showPrinter) {
            this.useStipplePatternPrinter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ColorPatternPanel.this.layerInfoChanged();
                }
            });
            this.opacity.getDocument().addDocumentListener(new LayerColorDocumentListener());
        } else {
            this.pattern.remove(this.useStipplePatternPrinter);
            this.pattern.remove(this.jLabel1);
            this.pattern.remove(this.jLabel2);
            this.pattern.remove(this.opacityLabel);
            this.pattern.remove(this.opacity);
        }
    }

    public void setColorMap(Color[] map2) {
        this.colorMap = map2;
        int curTrans = this.transparentLayer.getSelectedIndex();
        int[] transLayers = EGraphics.getTransparentColorIndices();
        this.transparentLayer.removeAllItems();
        this.transparentLayer.addItem("NOT TRANSPARENT");
        int maxTrans = Math.min(transLayers.length, map2.length);
        if (maxTrans > 0) {
            for (int i = 0; i < maxTrans; ++i) {
                this.transparentLayer.addItem(EGraphics.getColorIndexName(transLayers[i]));
            }
            this.transparentLayer.setSelectedIndex(curTrans);
        }
    }

    public void setOtherTransparentLayerNames(String names) {
        this.otherTransparentLayers = names;
    }

    public void setColorPattern(Info li) {
        this.currentLI = li;
        this.patternView.setLayerInfo(li);
        if (li == null) {
            this.useStipplePatternDisplay.setEnabled(false);
            this.outlinePattern.setEnabled(false);
            this.useStipplePatternPrinter.setEnabled(false);
            this.transparentLayer.setEnabled(false);
            this.colorChooser.setEnabled(false);
            return;
        }
        this.colorChooser.setEnabled(true);
        if (li.justColor) {
            this.useStipplePatternDisplay.setEnabled(false);
            this.outlinePattern.setEnabled(false);
            this.useStipplePatternPrinter.setEnabled(false);
            this.transparentLayer.setEnabled(false);
        } else {
            this.useStipplePatternDisplay.setEnabled(true);
            this.outlinePattern.setEnabled(true);
            this.useStipplePatternPrinter.setEnabled(true);
            this.transparentLayer.setEnabled(true);
        }
        this.dataChanging = true;
        this.useStipplePatternDisplay.setSelected(li.useStippleDisplay);
        if (li.outlinePatternDisplay != null) {
            this.outlinePattern.setSelectedItem(this.outlineImageIcons.get((Object)li.outlinePatternDisplay));
        }
        this.outlinePattern.setEnabled(li.useStippleDisplay);
        if (this.showPrinter) {
            this.useStipplePatternPrinter.setSelected(li.useStipplePrinter);
            this.opacity.setText(TextUtils.formatDouble(li.opacity));
        }
        if (li.transparentLayer < this.transparentLayer.getItemCount()) {
            this.transparentLayer.setSelectedIndex(li.transparentLayer);
        }
        Color initialColor = new Color(li.red, li.green, li.blue);
        this.colorChooser.setColor(initialColor);
        this.colorPreviewPanel.setPreviewColor(initialColor);
        this.patternView.repaint();
        this.colorPreviewPanel.repaint();
        this.dataChanging = false;
    }

    private void colorChanged() {
        if (this.dataChanging) {
            return;
        }
        if (this.currentLI == null) {
            return;
        }
        Color col = this.colorChooser.getColor();
        this.currentLI.red = col.getRed();
        this.currentLI.green = col.getGreen();
        this.currentLI.blue = col.getBlue();
        this.layerInfoChanged();
        this.colorPreviewPanel.setPreviewColor(col);
        if (this.otherTransparentLayers != null) {
            if (!this.warnedOfTransparentLayerSharing) {
                Job.getUserInterface().showInformationMessage(null, "WARNING: changing this color also affects " + this.otherTransparentLayers + " because they share the same transparent layer", "Change to Transparent Layer Color");
            }
            this.warnedOfTransparentLayerSharing = true;
        }
    }

    private void transparentLayerChanged() {
        if (this.currentLI == null) {
            return;
        }
        this.currentLI.transparentLayer = this.transparentLayer.getSelectedIndex();
        if (this.currentLI.transparentLayer > 0 && this.colorMap != null) {
            if (this.currentLI.transparentLayer > this.colorMap.length) {
                this.transparentLayer.setSelectedIndex(0);
                return;
            }
            this.currentLI.red = this.colorMap[this.currentLI.transparentLayer - 1].getRed();
            this.currentLI.green = this.colorMap[this.currentLI.transparentLayer - 1].getGreen();
            this.currentLI.blue = this.colorMap[this.currentLI.transparentLayer - 1].getBlue();
            this.layerInfoChanged();
        }
    }

    private void layerInfoChanged() {
        if (this.dataChanging) {
            return;
        }
        if (this.currentLI == null) {
            return;
        }
        this.currentLI.useStippleDisplay = this.useStipplePatternDisplay.isSelected();
        List<EGraphics.Outline> outlines = EGraphics.Outline.getOutlines();
        this.currentLI.outlinePatternDisplay = outlines.get(this.outlinePattern.getSelectedIndex());
        this.outlinePattern.setEnabled(this.currentLI.useStippleDisplay);
        if (this.showPrinter) {
            this.currentLI.useStipplePrinter = this.useStipplePatternPrinter.isSelected();
        }
        this.currentLI.transparentLayer = this.transparentLayer.getSelectedIndex();
        this.currentLI.opacity = TextUtils.atof(this.opacity.getText());
        Color newColor = new Color(this.currentLI.red, this.currentLI.green, this.currentLI.blue);
        this.colorChooser.setColor(newColor);
        if (this.currentLI.transparentLayer != 0) {
            this.colorMap[this.currentLI.transparentLayer - 1] = newColor;
        }
        this.colorPreviewPanel.repaint();
    }

    public ImageIcon getSample(EGraphics.Outline o) {
        int y;
        int pattern = o.getPattern();
        int len = o.getLen();
        int thickness = o.getThickness();
        BufferedImage bi = new BufferedImage(71, 11, 1);
        int startX = 5;
        int startY = (11 - thickness) / 2;
        for (y = 0; y < 11; ++y) {
            for (int x = 0; x < 71; ++x) {
                bi.setRGB(x, y, 0xFFFFFF);
            }
        }
        for (int x = 0; x < 71; ++x) {
            bi.setRGB(x, 0, 0);
            bi.setRGB(x, 10, 0);
        }
        for (y = 0; y < 11; ++y) {
            bi.setRGB(0, y, 0);
            bi.setRGB(70, y, 0);
        }
        for (y = 0; y < thickness; ++y) {
            int patPos = 0;
            for (int x = 0; x < 60; ++x) {
                if ((pattern & 1 << patPos) != 0) {
                    bi.setRGB(x + startX, y + startY, 0);
                } else {
                    bi.setRGB(x + startX, y + startY, 0xFFFFFF);
                }
                if (++patPos < len) continue;
                patPos = 0;
            }
        }
        return new ImageIcon(bi);
    }

    private void initComponents() {
        this.pattern = new JPanel();
        this.jLabel50 = new JLabel();
        this.useStipplePatternDisplay = new JCheckBox();
        this.outlinePattern = new JComboBox();
        this.jLabel3 = new JLabel();
        this.opacityLabel = new JLabel();
        this.opacity = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.useStipplePatternPrinter = new JCheckBox();
        this.color = new JPanel();
        this.jLabel40 = new JLabel();
        this.transparentLayer = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.pattern.setLayout(new GridBagLayout());
        this.pattern.setBorder(BorderFactory.createTitledBorder("Pattern"));
        this.jLabel50.setText("Click on a pattern below to use it above");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pattern.add((Component)this.jLabel50, gridBagConstraints);
        this.useStipplePatternDisplay.setText("Use Fill Pattern on Screen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pattern.add((Component)this.useStipplePatternDisplay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.pattern.add((Component)this.outlinePattern, gridBagConstraints);
        this.jLabel3.setText("Outline pattern:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.pattern.add((Component)this.jLabel3, gridBagConstraints);
        this.opacityLabel.setText("Opacity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pattern.add((Component)this.opacityLabel, gridBagConstraints);
        this.opacity.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pattern.add((Component)this.opacity, gridBagConstraints);
        this.jLabel1.setText("0: Transparent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.pattern.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("1: Opaque");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.pattern.add((Component)this.jLabel2, gridBagConstraints);
        this.useStipplePatternPrinter.setText("Use Fill Pattern on Printer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.pattern.add((Component)this.useStipplePatternPrinter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pattern, gridBagConstraints);
        this.color.setLayout(new GridBagLayout());
        this.color.setBorder(BorderFactory.createTitledBorder("Color"));
        this.jLabel40.setText("Transparency:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.color.add((Component)this.jLabel40, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.color.add((Component)this.transparentLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.color, gridBagConstraints);
    }

    private class PatternChoices
    extends JPanel
    implements MouseListener {
        private static final int NUMROWS = 2;
        private static final int ROWSIZE = 17;
        int numPatterns = ColorPatternPanel.access$700().length / 16;
        int yEntry = -1;
        int xEntry = -1;

        PatternChoices() {
            this.addMouseListener(this);
            this.setMaximumSize(new Dimension(this.numPatterns * 17 / 2 + 1, 35));
            this.setMinimumSize(new Dimension(this.numPatterns * 17 / 2 + 1, 35));
            this.setPreferredSize(new Dimension(this.numPatterns * 17 / 2 + 1, 35));
        }

        @Override
        public void paint(Graphics g) {
            ImageIcon icon = Resources.getResource(this.getClass(), "IconLayerPatterns.gif");
            g.drawImage(icon.getImage(), 0, 0, null);
            if (this.yEntry != -1 && this.xEntry != -1) {
                g.setColor(Color.BLACK);
                g.drawRect(this.xEntry * 17 - 1, this.yEntry * 17 - 1, 18, 18);
                g.drawRect(this.xEntry * 17, this.yEntry * 17, 17, 17);
                g.drawRect(this.xEntry * 17 + 1, this.yEntry * 17 + 1, 16, 16);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (ColorPatternPanel.this.currentLI == null || ((ColorPatternPanel)ColorPatternPanel.this).currentLI.justColor) {
                return;
            }
            this.xEntry = evt.getX() / 17;
            if (this.xEntry >= this.numPatterns / 2) {
                this.xEntry = this.numPatterns / 2 - 1;
            }
            this.yEntry = evt.getY() / 17;
            if (this.yEntry >= 2) {
                this.yEntry = 1;
            }
            int iconIndex = this.xEntry + 11 * this.yEntry;
            for (int i = 0; i < 16; ++i) {
                ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[i] = preDefinedPatterns[iconIndex * 16 + i];
            }
            ColorPatternPanel.this.useStipplePatternDisplay.setSelected(true);
            ColorPatternPanel.this.outlinePattern.setEnabled(true);
            ((ColorPatternPanel)ColorPatternPanel.this).currentLI.useStippleDisplay = true;
            this.paint(this.getGraphics());
            ColorPatternPanel.this.patternView.repaint();
            ColorPatternPanel.this.colorPreviewPanel.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }
    }

    private class PatternView
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private static final int PATSIZE = 13;
        private boolean newState;
        private JCheckBox stipple;
        private JComboBox outline;
        private Info lInfo;

        PatternView(Info lInfo, JCheckBox stipple, JComboBox outline) {
            this.lInfo = lInfo;
            this.stipple = stipple;
            this.outline = outline;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            int totSize = 209;
            this.setMaximumSize(new Dimension(totSize, totSize));
            this.setMinimumSize(new Dimension(totSize, totSize));
            this.setPreferredSize(new Dimension(totSize, totSize));
        }

        public void setLayerInfo(Info lInfo) {
            this.lInfo = lInfo;
        }

        @Override
        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, dim.width, dim.height);
            g.setColor(Color.GRAY);
            int upper = 208;
            for (int i = 0; i <= upper; i += 13) {
                g.drawLine(i, 0, i, upper);
                g.drawLine(0, i, upper, i);
            }
            g.setColor(Color.BLACK);
            if (this.lInfo == null || this.lInfo.justColor) {
                return;
            }
            for (int y = 0; y < 16; ++y) {
                int bits2 = this.lInfo.pattern[y];
                for (int x = 0; x < 16; ++x) {
                    if ((bits2 & 1 << 15 - x) == 0) continue;
                    g.fillRect(x * 13 + 1, y * 13 + 1, 12, 12);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (this.lInfo == null || this.lInfo.justColor) {
                return;
            }
            int xIndex = evt.getX() / 13;
            int yIndex = evt.getY() / 13;
            int curWord = this.lInfo.pattern[yIndex];
            this.newState = (curWord & 1 << 15 - xIndex) == 0;
            this.mouseDragged(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (this.lInfo == null || this.lInfo.justColor) {
                return;
            }
            int xIndex = evt.getX() / 13;
            int yIndex = evt.getY() / 13;
            if (xIndex < 0 || yIndex < 0 || xIndex >= 16 || yIndex >= 16) {
                return;
            }
            int curWord = this.lInfo.pattern[yIndex];
            if ((curWord & 1 << 15 - xIndex) != 0) {
                if (this.newState) {
                    return;
                }
                curWord &= ~(1 << 15 - xIndex);
            } else {
                if (!this.newState) {
                    return;
                }
                curWord |= 1 << 15 - xIndex;
            }
            this.lInfo.pattern[yIndex] = curWord;
            this.stipple.setSelected(true);
            this.outline.setEnabled(true);
            this.lInfo.useStippleDisplay = true;
            this.repaint();
            ColorPatternPanel.this.colorPreviewPanel.repaint();
        }
    }

    private class LayerColorDocumentListener
    implements DocumentListener {
        LayerColorDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ColorPatternPanel.this.layerInfoChanged();
        }
    }

    private class MyPreviewPanel
    extends JButton {
        private static final int XSIZE = 288;
        private static final int YSIZE = 48;
        private static final int BORDER = 10;
        private ColorPatternPanel dia;
        Color curColor = Color.BLACK;

        public MyPreviewPanel(ColorPatternPanel dia) {
            this.dia = dia;
            this.setPreferredSize(new Dimension(308, 68));
        }

        public void setPreviewColor(Color color) {
            this.curColor = color;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(new Color(User.getColor(User.ColorPrefType.BACKGROUND)));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ColorPatternPanel.this.currentLI == null) {
                return;
            }
            if (this.dia.useStipplePatternDisplay.isSelected()) {
                int y;
                BufferedImage im = new BufferedImage(16, 16, 1);
                for (y = 0; y < 16; ++y) {
                    int line = ((ColorPatternPanel)ColorPatternPanel.this).currentLI.pattern[y];
                    for (int x = 0; x < 16; ++x) {
                        if ((line & 1 << 15 - x) != 0) {
                            im.setRGB(x, y, this.curColor.getRGB());
                            continue;
                        }
                        im.setRGB(x, y, User.getColor(User.ColorPrefType.BACKGROUND));
                    }
                }
                for (y = 0; y < 48; y += 16) {
                    for (int x = 0; x < 288; x += 16) {
                        g.drawImage(im, x + 10, y + 10, null, null);
                    }
                }
                List<EGraphics.Outline> outlines = EGraphics.Outline.getOutlines();
                EGraphics.Outline o = outlines.get(this.dia.outlinePattern.getSelectedIndex());
                if (o != EGraphics.Outline.NOPAT) {
                    g.setColor(this.curColor);
                    for (int t = 0; t < o.getThickness(); ++t) {
                        if (o.isSolidPattern()) {
                            g.drawLine(10 + t, 10 + t, 297 - t, 10 + t);
                            g.drawLine(297 - t, 10 + t, 297 - t, 57 - t);
                            g.drawLine(297 - t, 57 - t, 10 + t, 57 - t);
                            g.drawLine(10 + t, 57 - t, 10 + t, 10 + t);
                            continue;
                        }
                        int pattern = o.getPattern();
                        int len = o.getLen();
                        int patPos = 0;
                        for (int x = 0; x < 288; ++x) {
                            if ((pattern & 1 << patPos) != 0) {
                                g.fillRect(10 + x, 10 + t, 1, 1);
                                g.fillRect(10 + x, 57 - t, 1, 1);
                            }
                            if (++patPos < len) continue;
                            patPos = 0;
                        }
                        patPos = 0;
                        for (int y2 = 0; y2 < 48; ++y2) {
                            if ((pattern & 1 << patPos) != 0) {
                                g.fillRect(10 + t, 10 + y2, 1, 1);
                                g.fillRect(297 - t, 10 + y2, 1, 1);
                            }
                            if (++patPos < len) continue;
                            patPos = 0;
                        }
                    }
                }
            } else {
                g.setColor(this.curColor);
                g.fillRect(10, 10, 288, 48);
            }
        }
    }

    public static class Info {
        public EGraphics graphics;
        public int[] pattern;
        public boolean useStippleDisplay;
        public EGraphics.Outline outlinePatternDisplay;
        public boolean useStipplePrinter;
        public int transparentLayer;
        public int red;
        public int green;
        public int blue;
        public User.ColorPrefType theColor;
        public double opacity;
        public boolean justColor;

        public Info(EGraphics graphics) {
            this.graphics = graphics;
            this.pattern = new int[16];
            int[] pattern = graphics.getPattern();
            for (int i = 0; i < 16; ++i) {
                this.pattern[i] = pattern[i];
            }
            this.useStippleDisplay = graphics.isPatternedOnDisplay();
            this.outlinePatternDisplay = graphics.getOutlined();
            this.useStipplePrinter = graphics.isPatternedOnPrinter();
            this.transparentLayer = graphics.getTransparentLayer();
            int color = graphics.getColor().getRGB();
            this.red = color >> 16 & 0xFF;
            this.green = color >> 8 & 0xFF;
            this.blue = color & 0xFF;
            this.opacity = graphics.getOpacity();
            this.justColor = false;
            this.theColor = null;
        }

        public Info(User.ColorPrefType colorPref) {
            int color = User.getColor(colorPref);
            this.red = color >> 16 & 0xFF;
            this.green = color >> 8 & 0xFF;
            this.blue = color & 0xFF;
            this.theColor = colorPref;
            this.justColor = true;
        }

        public EGraphics updateGraphics(EGraphics graphics) {
            if (this.justColor) {
                return graphics;
            }
            graphics = graphics.withPattern(this.pattern);
            graphics = graphics.withPatternedOnDisplay(this.useStippleDisplay);
            graphics = graphics.withOutlined(this.outlinePatternDisplay);
            graphics = graphics.withPatternedOnPrinter(this.useStipplePrinter);
            graphics = graphics.withColor(new Color(this.red, this.green, this.blue));
            graphics = graphics.withOpacity(this.opacity);
            graphics = graphics.withTransparentLayer(this.transparentLayer);
            return graphics;
        }
    }
}

