/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterTableRenameColumn
extends DefineCommand {
    private Table table;
    private Column column;
    private String newName;

    public AlterTableRenameColumn(Session session) {
        super(session);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setNewColumnName(String string) {
        this.newName = string;
    }

    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.renameColumn(this.column, this.newName);
        this.table.setModified();
        database.update(this.session, this.table);
        for (DbObject dbObject : this.table.getChildren()) {
            if (dbObject.getCreateSQL() == null) continue;
            database.update(this.session, dbObject);
        }
        return 0;
    }
}

