/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class MotifMenuItemUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new MotifMenuItemUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = this.createChangeListener(this.menuItem);
        this.menuItem.addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeChangeListener(this.changeListener);
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(MotifMenuItemUI.this.getPath());
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenuItem menuItem = (JMenuItem)e2.getComponent();
            Point p = e2.getPoint();
            if (p.x >= 0 && p.x < menuItem.getWidth() && p.y >= 0 && p.y < menuItem.getHeight()) {
                manager.clearSelectedPath();
                menuItem.doClick(0);
            } else {
                manager.processMouseEvent(e2);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            MenuSelectionManager.defaultManager().processMouseEvent(e2);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }
    }

    protected class ChangeHandler
    implements ChangeListener {
        protected ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            JMenuItem c;
            LookAndFeel.installProperty(c, "borderPainted", (c = (JMenuItem)e2.getSource()).isArmed() || c.isSelected());
        }
    }
}

