/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import lpg.runtime.LexStream;
import pythondec.Disassemble;
import pythondec.PyCode;
import pythondec.PyObject;
import pythondec.PythonVersions;
import pythondec.op;
import pythondec3.PythonDec22;
import pythondec3.ast.Module;
import pythondec3.ast.StmtList;
import pythondec3.ast.Tok;
import pythondec3.ast.sgen;
import pythondec3.lpg_parser;
import pythondec3.regenerator;
import pythondec3.stats;
import shared.Bytedeque2;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.SerialBytestream;
import shared.m;

public class pycfile {
    public int magicnum;
    public int timestamp;
    public PyCode code;
    PythonVersions p;
    Module root;
    String sourcecode;
    public String filename;

    public static pycfile createFromFilename(String filename) {
        return new pycfile(SerialBytestream.createFromFilename(filename));
    }

    public pycfile(IBytestream c) {
        this.magicnum = c.readInt();
        if (this.magicnum == PythonVersions.Python22().MagicNumber()) {
            this.p = PythonVersions.Python22();
            c.set("pyver", 22);
        } else if (this.magicnum == PythonVersions.Python23().MagicNumber()) {
            this.p = PythonVersions.Python23();
            c.set("pyver", 23);
        } else {
            m.throwUncaughtException("Unexpected/no magic number.");
        }
        this.timestamp = c.readInt();
        this.code = (PyCode)PyObject.read(c).cast();
    }

    private pycfile() {
    }

    public boolean compare(pycfile pyc2) {
        if (this.magicnum != pyc2.magicnum) {
            return false;
        }
        return this.code.compare(pyc2.code);
    }

    public void decompile() {
        if (this.code.tokens == null) {
            this.disassemble();
        }
        if (this.root == null) {
            this.root = new Module(pycfile.decompile2(this.code, this.p), this.code);
        }
    }

    public String generateSourceCode() {
        if (this.root == null) {
            this.decompile();
        }
        if (this.sourcecode == null) {
            sgen s = new sgen();
            this.root.gen(s);
            this.sourcecode = s.getGeneratedSource();
        }
        return this.sourcecode;
    }

    private static StmtList decompile2(PyCode pycode, PythonVersions p) {
        if (stats.printTiming) {
            m.marktime("Starting parsing");
        }
        pycode.root = (StmtList)lpg_parser.Deflatten(pycode.tokens, pycode.pd22, pycode);
        if (pycode.root == null) {
            m.msg("Problem in Object: " + pycode.toString());
        }
        if (stats.printTiming) {
            m.marktime("Done parsing");
        }
        for (PyObject constobj : pycode.consts.items) {
            if (!(constobj instanceof PyCode)) continue;
            PyCode childcode = (PyCode)constobj;
            pycfile.decompile2(childcode, p);
        }
        return pycode.root;
    }

    public void disassemble() {
        pycfile.disassemble2(this.code, this.p);
        this.code.debugname = "(root module)";
        if (stats.printTiming) {
            m.marktime("Starting to find globals");
        }
        ArrayDeque<PyCode> codestack = new ArrayDeque<PyCode>();
        pycfile.getglobals(this.code, codestack);
        if (stats.printTiming) {
            m.marktime("Done finding globals");
        }
    }

    public void printGlobals() {
        pycfile.printGlobals2(this.code);
    }

    private static void printGlobals2(PyCode pycode) {
        m.msg("Class/function: " + pycode.name.toString());
        for (String glo : pycode.globals) {
            m.msg(glo);
        }
        m.msg(new String[0]);
        for (PyCode childcode : pycode.children) {
            pycfile.printGlobals2(childcode);
        }
    }

    private static boolean getAdvancedGlobals(String globalname, ArrayDeque<PyCode> codestack, PyCode pycode) {
        PyCode[] codestack2 = codestack.toArray(new PyCode[0]);
        for (int i = codestack2.length - 1; i >= 0; --i) {
            PyCode curcode = codestack2[i];
            String[] globs = curcode.globals.toArray(new String[0]);
            for (String curglob : globs) {
                if (!globalname.equals(curglob)) continue;
                return true;
            }
            for (Tok curt : curcode.tokens) {
                String curname;
                if (curt.oi == null || curt.oi.o != op.STORE_NAME && curt.oi.o != op.STORE_FAST || !(curname = curt.getName(null)).equals(globalname) || i == 0) continue;
                return false;
            }
        }
        return false;
    }

    private static void getglobals(PyCode pycode, ArrayDeque<PyCode> codestack) {
        pycode.globals = new LinkedHashSet<String>();
        for (Tok t : pycode.tokens) {
            String globalname;
            if (t.oi == null || t.oi.o == null) continue;
            if (t.oi.o == op.STORE_GLOBAL) {
                pycode.globals.add(t.getName(null));
                continue;
            }
            if (t.oi.o == op.DELETE_GLOBAL) {
                pycode.globals.add(t.getName(null));
                continue;
            }
            if (t.oi.o != op.LOAD_GLOBAL || !pycfile.getAdvancedGlobals(globalname = t.getName(null), codestack, pycode)) continue;
            pycode.globals.add(globalname);
        }
        codestack.push(pycode);
        for (PyObject constobj : pycode.consts.items) {
            if (!(constobj instanceof PyCode)) continue;
            PyCode childcode = (PyCode)constobj;
            pycfile.getglobals(childcode, codestack);
        }
        codestack.pop();
    }

    private static void disassemble2(PyCode pycode, PythonVersions p) {
        if (stats.printTiming) {
            m.marktime("Starting disassembling");
        }
        Disassemble disassembledCode = new Disassemble(pycode, p);
        if (stats.printTiming) {
            m.marktime("Starting lpg init");
        }
        pycode.lexstream = new LexStream();
        pycode.pd22 = new PythonDec22(pycode.lexstream);
        pycode.prsstream = pycode.lexstream.getIPrsStream();
        if (stats.printTiming) {
            m.marktime("Starting the token production");
        }
        pycode.tokens = lpg_parser.MakeTokens(disassembledCode, pycode.prsstream);
        if (pycode.name.toString().equals("PyString: _build_ast")) {
            boolean bl = false;
        }
        if (p.recreateStructure()) {
            regenerator regen = new regenerator(pycode);
            regen.regenerateStructure();
        }
        if (stats.printTiming) {
            m.marktime("Starting adding tokens");
        }
        for (Tok token : pycode.tokens) {
            pycode.prsstream.addToken(token);
        }
        pycode.prsstream.setStreamLength();
        if (stats.printDisassembly) {
            m.msg("PyCode Object: " + pycode.toString());
            for (Tok t : pycode.tokens) {
                m.msg(t.toString());
            }
        }
        pycode.children = new ArrayList();
        for (PyObject constobj : pycode.consts.items) {
            if (!(constobj instanceof PyCode)) continue;
            PyCode childcode = (PyCode)constobj;
            pycode.children.add(childcode);
            pycfile.disassemble2(childcode, p);
        }
    }

    public static pycfile create(PyCode code, PythonVersions p) {
        pycfile r = new pycfile();
        r.code = code;
        r.magicnum = p.MagicNumber();
        r.timestamp = 0;
        m.warn("fixme: creating incorrect timestamp.");
        return r;
    }

    public byte[] compile() {
        Bytedeque2 c = new Bytedeque2(Format.none);
        ((IBytedeque)c).writeInt(this.magicnum);
        ((IBytedeque)c).writeInt(this.timestamp);
        this.code.marshal(c);
        return ((IBytedeque)c).getAllBytes();
    }

    public void printTokens() {
        pycfile.printTokens2(this.code);
    }

    private static void printTokens2(PyCode pycode) {
        m.msg("file/class/func name: " + pycode.name.toString());
        for (Tok token : pycode.tokens) {
            m.msg(token.toString());
        }
        m.msg(new String[0]);
        m.msg(new String[0]);
        for (PyObject constobj : pycode.consts.items) {
            if (!(constobj instanceof PyCode)) continue;
            PyCode childcode = (PyCode)constobj;
            pycfile.printTokens2(childcode);
        }
    }
}

