/*
 * Decompiled with CFR 0.152.
 */
package pythondec3.ast;

import java.lang.reflect.Field;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import pythondec.Disassemble;
import pythondec.PyComplex;
import pythondec.PyEllipsis;
import pythondec.PyFloat;
import pythondec.PyInt;
import pythondec.PyLong;
import pythondec.PyNone;
import pythondec.PyString;
import pythondec.PyUnicode;
import pythondec.op;
import pythondec3.PythonDec22sym;
import pythondec3.ast.Ast;
import pythondec3.ast.sgen;
import pythondec3.helpers;
import shared.uncaughtexception;

public class Tok
extends Ast
implements IToken {
    int _kind;
    int _startoffset;
    int _endoffset;
    int _tokenindex;
    int _adjunctindex;
    IPrsStream _prsstream;
    int tokennum;
    public Disassemble.OpInfo oi;
    String opname;
    public String debugstr = "";

    public Tok(Disassemble.OpInfo oi2, int number, String opname2, IPrsStream prsstream) {
        this._prsstream = prsstream;
        this.oi = oi2;
        this.tokennum = number;
        this.opname = opname2;
        this._kind = this.getToken();
        this._startoffset = number;
        this._endoffset = number;
        this._tokenindex = 0;
        this._adjunctindex = 0;
    }

    public Tok(Disassemble.OpInfo oi2, int number, IPrsStream prsstream) {
        this(oi2, number, oi2.o.toString(), prsstream);
    }

    public static Tok fakeToken(op o, IPrsStream prsstream) {
        Disassemble.OpInfo oi = Disassemble.OpInfo.create(o);
        Tok r = new Tok(oi, -1, prsstream);
        return r;
    }

    public static Tok fakeToken(op o, IPrsStream prsstream, int offset, Object pattr) {
        Disassemble.OpInfo oi = Disassemble.OpInfo.create(o);
        oi.pattr = pattr;
        oi.offset = offset;
        Tok r = new Tok(oi, -1, prsstream);
        return r;
    }

    public static Tok customToken(String tokenname, IPrsStream prsstream) {
        Tok r = new Tok(Disassemble.OpInfo.create(op.CUSTOM), -1, tokenname, prsstream);
        return r;
    }

    public static Tok customToken(String tokenname, IPrsStream prsstream, Object pattr) {
        Disassemble.OpInfo oi = Disassemble.OpInfo.create(op.CUSTOM);
        oi.pattr = pattr;
        Tok r = new Tok(oi, -1, tokenname, prsstream);
        return r;
    }

    public static Tok eofToken(IPrsStream prsstream) {
        Tok r = new Tok(Disassemble.OpInfo.create(op.EOF), -1, "EOF_TOKEN", prsstream);
        return r;
    }

    public static Tok sofToken(IPrsStream prsstream) {
        Tok r = new Tok(Disassemble.OpInfo.create(op.SOF), -1, "SOF_TOKEN", prsstream);
        return r;
    }

    @Override
    public void gen2(sgen s) {
        if (this.oi == null) {
            s.out("DrizzleError:" + this.toString());
        } else {
            String name = this.getName(s);
            if (name == null) {
                s.out("DrizzleError:" + this.toString());
            } else {
                s.out(name);
            }
        }
    }

    public String getName(sgen s) {
        if (this.oi.pattr instanceof PyString) {
            PyString r = (PyString)this.oi.pattr;
            switch (this.oi.o) {
                case STORE_ATTR: 
                case LOAD_ATTR: 
                case STORE_NAME: 
                case LOAD_NAME: 
                case STORE_FAST: 
                case LOAD_FAST: {
                    String demangledname = helpers.demangleName(s, r.toJavaString());
                    return demangledname;
                }
            }
            return r.toJavaString();
        }
        if (this.oi.pattr instanceof PyInt) {
            PyInt r = (PyInt)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyNone) {
            PyNone r = (PyNone)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyFloat) {
            PyFloat r = (PyFloat)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyLong) {
            PyLong r = (PyLong)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyComplex) {
            PyComplex r = (PyComplex)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyUnicode) {
            PyUnicode r = (PyUnicode)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        if (this.oi.pattr instanceof PyEllipsis) {
            PyEllipsis r = (PyEllipsis)this.oi.pattr;
            String r2 = r.toJavaString();
            return r2;
        }
        return null;
    }

    public String getNameQuoted(sgen s) {
        if (this.oi.pattr instanceof PyString) {
            String r = "'" + helpers.escapePythonString((PyString)this.oi.pattr) + "'";
            return r;
        }
        if (this.oi.pattr instanceof PyUnicode) {
            String r = "u'" + helpers.escapeUnicodeString(((PyUnicode)this.oi.pattr).toJavaString()) + "'";
            return r;
        }
        return this.getName(s);
    }

    private int getToken() {
        boolean doefficient = false;
        if (doefficient) {
            switch (this.oi.o) {
                case POP_TOP: {
                    return 18;
                }
                case ROT_TWO: {
                    return 64;
                }
            }
            throw new uncaughtexception("Unknown token.");
        }
        if (this.opname.equals("EOF_TOKEN")) {
            return 115;
        }
        if (this.opname.equals("SOF_TOKEN")) {
            return 0;
        }
        try {
            Field f = PythonDec22sym.class.getField("TK_" + this.opname);
            int r = f.getInt(null);
            return r;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new uncaughtexception("wha");
        }
    }

    @Override
    public int getKind() {
        return this._kind;
    }

    @Override
    public void setKind(int kind) {
        this._kind = kind;
    }

    @Override
    public int getStartOffset() {
        return this._startoffset;
    }

    @Override
    public void setStartOffset(int startOffset) {
        this._startoffset = startOffset;
    }

    @Override
    public int getEndOffset() {
        return this._endoffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this._endoffset = endOffset;
    }

    @Override
    public int getTokenIndex() {
        return this._tokenindex;
    }

    @Override
    public void setTokenIndex(int i) {
        this._tokenindex = i;
    }

    @Override
    public int getAdjunctIndex() {
        return this._adjunctindex;
    }

    @Override
    public void setAdjunctIndex(int i) {
        this._adjunctindex = i;
    }

    @Override
    public IToken[] getPrecedingAdjuncts() {
        throw new uncaughtexception("unhandled");
    }

    @Override
    public IToken[] getFollowingAdjuncts() {
        throw new uncaughtexception("unhandled");
    }

    @Override
    public ILexStream getILexStream() {
        return this._prsstream.getILexStream();
    }

    @Override
    public ILexStream getLexStream() {
        return this.getILexStream();
    }

    @Override
    public IPrsStream getIPrsStream() {
        return this._prsstream;
    }

    @Override
    public IPrsStream getPrsStream() {
        return this.getIPrsStream();
    }

    @Override
    public int getLine() {
        return this.tokennum;
    }

    @Override
    public int getColumn() {
        return 1;
    }

    @Override
    public int getEndLine() {
        return this.tokennum;
    }

    @Override
    public int getEndColumn() {
        return 1;
    }

    @Override
    public String getValue(char[] inputChars) {
        return this.toString();
    }

    @Override
    public String toString() {
        String r = this.opname;
        r = r + " : ";
        if (this.oi != null) {
            r = r + this.oi.toDebugString();
        }
        r = r + " tokennum: " + Integer.toString(this._tokenindex);
        if (!this.debugstr.equals("")) {
            r = r + " debug: " + this.debugstr;
        }
        return r;
    }

    public boolean compare(Tok t2) {
        if (!this.opname.equals(t2.opname)) {
            return false;
        }
        if (this.oi == null) {
            if (t2.oi != null) {
                return false;
            }
        } else {
            if (t2.oi == null) {
                return false;
            }
            if (!this.oi.compare(t2.oi)) {
                return false;
            }
        }
        return true;
    }
}

