/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Logging;

public class LineElement
extends StyleElement {
    public static final LineElement UNTAGGED_WAY = LineElement.createSimpleLineStyle(null, false);
    private final BasicStroke line;
    public Color color;
    private final BasicStroke dashesLine;
    public Color dashesBackground;
    public float offset;
    public float realWidth;
    public boolean wayDirectionArrows;

    protected LineElement(Cascade c, float defaultMajorZindex, BasicStroke line, Color color, BasicStroke dashesLine, Color dashesBackground, float offset, float realWidth, boolean wayDirectionArrows) {
        super(c, defaultMajorZindex);
        this.line = line;
        this.color = color;
        this.dashesLine = dashesLine;
        this.dashesBackground = dashesBackground;
        this.offset = offset;
        this.realWidth = realWidth;
        this.wayDirectionArrows = wayDirectionArrows;
    }

    @Override
    public void paintPrimitive(IPrimitive primitive, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        boolean showOrientation = this.defaultSelectedHandling ? !this.isModifier && (selected || paintSettings.isShowDirectionArrow()) && !paintSettings.isUseRealWidth() : this.wayDirectionArrows;
        boolean showOneway = !this.isModifier && !selected && !paintSettings.isUseRealWidth() && paintSettings.isShowOnewayArrow() && primitive.hasDirectionKeys();
        boolean onewayReversed = primitive.reversedDirection();
        boolean showOnlyHeadArrowOnly = showOrientation && !selected && paintSettings.isShowHeadArrowOnly();
        Color myDashedColor = this.dashesBackground;
        BasicStroke myLine = this.line;
        BasicStroke myDashLine = this.dashesLine;
        if (this.realWidth > 0.0f && paintSettings.isUseRealWidth() && !showOrientation) {
            float myWidth = (int)(100.0f / (float)(painter.getCircum() / (double)this.realWidth));
            if (myWidth < this.line.getLineWidth()) {
                myWidth = this.line.getLineWidth();
            }
            myLine = new BasicStroke(myWidth, this.line.getEndCap(), this.line.getLineJoin(), this.line.getMiterLimit(), this.line.getDashArray(), this.line.getDashPhase());
            if (this.dashesLine != null) {
                myDashLine = new BasicStroke(myWidth, this.dashesLine.getEndCap(), this.dashesLine.getLineJoin(), this.dashesLine.getMiterLimit(), this.dashesLine.getDashArray(), this.dashesLine.getDashPhase());
            }
        }
        Color myColor = this.color;
        if (this.defaultSelectedHandling && selected) {
            myColor = paintSettings.getSelectedColor(this.color.getAlpha());
        } else if (member || outermember) {
            myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
        } else if (primitive.isDisabled()) {
            myColor = paintSettings.getInactiveColor();
            myDashedColor = paintSettings.getInactiveColor();
        }
        if (primitive instanceof IWay) {
            IWay w = (IWay)primitive;
            painter.drawWay(w, myColor, myLine, myDashLine, myDashedColor, this.offset, showOrientation, showOnlyHeadArrowOnly, showOneway, onewayReversed);
            if ((paintSettings.isShowOrderNumber() || paintSettings.isShowOrderNumberOnSelectedWay() && selected) && !painter.isInactiveMode()) {
                int orderNumber = 0;
                INode lastN = null;
                for (INode n : w.getNodes()) {
                    if (lastN != null) {
                        painter.drawOrderNumber(lastN, n, ++orderNumber, myColor);
                    }
                    lastN = n;
                }
            }
        }
    }

    @Override
    public boolean isProperLineStyle() {
        return !this.isModifier;
    }

    public String linejoinToString(int linejoin) {
        switch (linejoin) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return null;
    }

    public String linecapToString(int linecap) {
        switch (linecap) {
            case 0: {
                return "none";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LineElement other = (LineElement)obj;
        return Float.compare(this.offset, other.offset) == 0 && Float.compare(this.realWidth, other.realWidth) == 0 && this.wayDirectionArrows == other.wayDirectionArrows && Objects.equals(this.line, other.line) && Objects.equals(this.color, other.color) && Objects.equals(this.dashesLine, other.dashesLine) && Objects.equals(this.dashesBackground, other.dashesBackground);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.line, this.color, this.dashesBackground, Float.valueOf(this.offset), Float.valueOf(this.realWidth), this.wayDirectionArrows, this.dashesLine);
    }

    @Override
    public String toString() {
        return "LineElemStyle{" + super.toString() + "width=" + this.line.getLineWidth() + " realWidth=" + this.realWidth + " color=" + ColorHelper.color2html(this.color) + " dashed=" + Arrays.toString(this.line.getDashArray()) + (this.line.getDashPhase() == 0.0f ? "" : " dashesOffses=" + this.line.getDashPhase()) + " dashedColor=" + ColorHelper.color2html(this.dashesBackground) + " linejoin=" + this.linejoinToString(this.line.getLineJoin()) + " linecap=" + this.linecapToString(this.line.getEndCap()) + (this.offset == 0.0f ? "" : " offset=" + this.offset) + '}';
    }

    public static LineElement createSimpleLineStyle(Color color, boolean isAreaEdge) {
        MultiCascade mc = new MultiCascade();
        Cascade c = mc.getOrCreateCascade("default");
        c.put("width", Keyword.DEFAULT);
        c.put("color", color != null ? color : PaintColors.UNTAGGED.get());
        c.put("opacity", Float.valueOf(1.0f));
        if (isAreaEdge) {
            c.put("z-index", Float.valueOf(-3.0f));
        }
        return LineElement.createLine(new Environment(new Way(), mc, "default", null));
    }

    public static LineElement createLine(Environment env) {
        return LineElement.createImpl(env, LineType.NORMAL);
    }

    public static LineElement createLeftCasing(Environment env) {
        LineElement leftCasing = LineElement.createImpl(env, LineType.LEFT_CASING);
        if (leftCasing != null) {
            leftCasing.isModifier = true;
        }
        return leftCasing;
    }

    public static LineElement createRightCasing(Environment env) {
        LineElement rightCasing = LineElement.createImpl(env, LineType.RIGHT_CASING);
        if (rightCasing != null) {
            rightCasing.isModifier = true;
        }
        return rightCasing;
    }

    public static LineElement createCasing(Environment env) {
        LineElement casing = LineElement.createImpl(env, LineType.CASING);
        if (casing != null) {
            casing.isModifier = true;
        }
        return casing;
    }

    private static LineElement createImpl(Environment env, LineType type) {
        float miterlimit;
        Color dashesBackground;
        float dashesOffset;
        Integer pAlpha;
        Cascade cDef;
        Cascade c = env.mc.getCascade(env.layer);
        Float width = LineElement.computeWidth(type, c, cDef = env.mc.getCascade("default"));
        if (width == null) {
            return null;
        }
        float realWidth = LineElement.computeRealWidth(env, type, c);
        Float offset = LineElement.computeOffset(type, c, cDef, width);
        int alpha = 255;
        Color color = c.get(type.prefix + "color", null, Color.class);
        if (color != null) {
            alpha = color.getAlpha();
        }
        if (type == LineType.NORMAL && color == null) {
            color = c.get("fill-color", null, Color.class);
        }
        if (color == null) {
            color = PaintColors.UNTAGGED.get();
        }
        if ((pAlpha = ColorHelper.float2int(c.get(type.prefix + "opacity", null, Float.class))) != null) {
            alpha = pAlpha;
        }
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        float[] dashes = c.get(type.prefix + "dashes", null, float[].class, true);
        if (dashes != null) {
            boolean hasPositive = false;
            for (float f : dashes) {
                if (f > 0.0f) {
                    hasPositive = true;
                }
                if (!(f < 0.0f)) continue;
                dashes = null;
                break;
            }
            if (!hasPositive || dashes != null && dashes.length == 0) {
                dashes = null;
            }
        }
        if ((dashesOffset = c.get(type.prefix + "dashes-offset", Float.valueOf(0.0f), Float.class).floatValue()) < 0.0f) {
            Logging.warn("Found negative dashes-offset: " + dashesOffset);
            dashesOffset = 0.0f;
        }
        if ((dashesBackground = c.get(type.prefix + "dashes-background-color", null, Color.class)) != null) {
            pAlpha = ColorHelper.float2int(c.get(type.prefix + "dashes-background-opacity", null, Float.class));
            if (pAlpha != null) {
                alpha = pAlpha;
            }
            dashesBackground = new Color(dashesBackground.getRed(), dashesBackground.getGreen(), dashesBackground.getBlue(), alpha);
        }
        Integer cap = null;
        Keyword capKW = c.get(type.prefix + "linecap", null, Keyword.class);
        if (capKW != null) {
            if ("none".equals(capKW.val)) {
                cap = 0;
            } else if ("round".equals(capKW.val)) {
                cap = 1;
            } else if ("square".equals(capKW.val)) {
                cap = 2;
            }
        }
        if (cap == null) {
            cap = dashes != null ? 0 : 1;
        }
        Integer join = null;
        Keyword joinKW = c.get(type.prefix + "linejoin", null, Keyword.class);
        if (joinKW != null) {
            if ("round".equals(joinKW.val)) {
                join = 1;
            } else if ("miter".equals(joinKW.val)) {
                join = 0;
            } else if ("bevel".equals(joinKW.val)) {
                join = 2;
            }
        }
        if (join == null) {
            join = 1;
        }
        if ((miterlimit = c.get(type.prefix + "miterlimit", Float.valueOf(10.0f), Float.class).floatValue()) < 1.0f) {
            miterlimit = 10.0f;
        }
        BasicStroke line = new BasicStroke(width.floatValue(), cap, join, miterlimit, dashes, dashesOffset);
        BasicStroke dashesLine = null;
        if (dashes != null && dashesBackground != null) {
            float[] dashes2 = new float[dashes.length];
            System.arraycopy(dashes, 0, dashes2, 1, dashes.length - 1);
            dashes2[0] = dashes[dashes.length - 1];
            dashesLine = new BasicStroke(width.floatValue(), cap, join, miterlimit, dashes2, dashes2[0] + dashesOffset);
        }
        boolean wayDirectionArrows = c.get(type.prefix + "way-direction-arrows", env.osm.isSelected(), Boolean.class);
        return new LineElement(c, type.defaultMajorZIndex, line, color, dashesLine, dashesBackground, offset.floatValue(), realWidth, wayDirectionArrows);
    }

    private static Float computeWidth(LineType type, Cascade c, Cascade cDef) {
        Float width;
        switch (type) {
            case NORMAL: {
                width = LineElement.getWidth(c, "width", LineElement.getWidth(cDef, "width", null));
                break;
            }
            case CASING: {
                Instruction.RelativeFloat relCasingWidth;
                Float casingWidth = c.get(type.prefix + "width", null, Float.class, true);
                if (casingWidth == null && (relCasingWidth = c.get(type.prefix + "width", null, Instruction.RelativeFloat.class, true)) != null) {
                    casingWidth = Float.valueOf(relCasingWidth.val / 2.0f);
                }
                if (casingWidth == null) {
                    return null;
                }
                width = Float.valueOf(Optional.ofNullable(LineElement.getWidth(c, "width", LineElement.getWidth(cDef, "width", null))).orElse(Float.valueOf(0.0f)).floatValue() + 2.0f * casingWidth.floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                width = LineElement.getWidth(c, type.prefix + "width", null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return width;
    }

    private static float computeRealWidth(Environment env, LineType type, Cascade c) {
        String widthTag;
        float realWidth = c.get(type.prefix + "real-width", Float.valueOf(0.0f), Float.class).floatValue();
        if (realWidth > 0.0f && MapPaintSettings.INSTANCE.isUseRealWidth() && (widthTag = Optional.ofNullable(env.osm.get("width")).orElseGet(() -> env.osm.get("est_width"))) != null) {
            try {
                realWidth = Float.parseFloat(widthTag);
            }
            catch (NumberFormatException nfe) {
                Logging.warn(nfe);
            }
        }
        return realWidth;
    }

    private static Float computeOffset(LineType type, Cascade c, Cascade cDef, Float width) {
        Float offset = c.get("offset", Float.valueOf(0.0f), Float.class);
        switch (type) {
            case NORMAL: {
                break;
            }
            case CASING: {
                offset = Float.valueOf(offset.floatValue() + c.get(type.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                Float baseWidthOnDefault = LineElement.getWidth(cDef, "width", null);
                Float baseWidth = LineElement.getWidth(c, "width", baseWidthOnDefault);
                if (baseWidth == null || baseWidth.floatValue() < 2.0f) {
                    baseWidth = Float.valueOf(2.0f);
                }
                float casingOffset = c.get(type.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue();
                casingOffset += baseWidth.floatValue() / 2.0f + width.floatValue() / 2.0f;
                if (type == LineType.RIGHT_CASING) {
                    casingOffset *= -1.0f;
                }
                offset = Float.valueOf(offset.floatValue() + casingOffset);
            }
        }
        return offset;
    }

    public static enum LineType {
        NORMAL("", 3.0f),
        CASING("casing-", 2.0f),
        LEFT_CASING("left-casing-", 2.1f),
        RIGHT_CASING("right-casing-", 2.1f);

        public final String prefix;
        public final float defaultMajorZIndex;

        private LineType(String prefix, float defaultMajorZIndex) {
            this.prefix = prefix;
            this.defaultMajorZIndex = defaultMajorZIndex;
        }
    }
}

