/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ConnectivityRelations
extends Test {
    protected static final int INCONSISTENT_LANE_COUNT = 3900;
    protected static final int UNKNOWN_CONNECTIVITY_ROLE = 3901;
    protected static final int NO_CONNECTIVITY_TAG = 3902;
    protected static final int MALFORMED_CONNECTIVITY_TAG = 3903;
    protected static final int MISSING_COMMA_CONNECTIVITY_TAG = 3904;
    protected static final int TOO_MANY_ROLES = 3905;
    protected static final int MISSING_ROLE = 3906;
    protected static final int MEMBER_MISSING_LANES = 3907;
    protected static final int CONNECTIVITY_IMPLIED = 3908;
    private static final String CONNECTIVITY_TAG = "connectivity";
    private static final String VIA = "via";
    private static final String TO = "to";
    private static final String FROM = "from";
    private static final int BW = -1000;
    private static final Pattern OPTIONAL_LANE_PATTERN = Pattern.compile("\\([0-9-]+\\)");
    private static final Pattern TO_LANE_PATTERN = Pattern.compile("\\p{Zs}*[,:;]\\p{Zs}*");
    private static final Pattern MISSING_COMMA_PATTERN = Pattern.compile("[0-9]+\\([0-9]+\\)|\\([0-9]+\\)[0-9]+");
    private static final Pattern LANE_TAG_PATTERN = Pattern.compile(".*:lanes");

    public ConnectivityRelations() {
        super(I18n.tr("Connectivity Relations", new Object[0]), I18n.tr("Validates connectivity relations", new Object[0]));
    }

    public static Map<Integer, Map<Integer, Boolean>> parseConnectivityTag(Relation relation) {
        String[] lanePairs;
        String cnTag = relation.get(CONNECTIVITY_TAG);
        if (cnTag == null || cnTag.isEmpty()) {
            return Collections.emptyMap();
        }
        String joined = cnTag.replace("bw", Integer.toString(-1000));
        HashMap result = new HashMap();
        for (String lanePair : lanePairs = joined.split("\\|", -1)) {
            String[] toLanes;
            int laneNumber;
            String[] lane = lanePair.split(":", -1);
            if (lane.length < 2) {
                return Collections.emptyMap();
            }
            try {
                laneNumber = Integer.parseInt(lane[0].trim());
            }
            catch (NumberFormatException e) {
                return Collections.emptyMap();
            }
            HashMap<Integer, Boolean> connections = new HashMap<Integer, Boolean>();
            for (String toLane : toLanes = TO_LANE_PATTERN.split(lane[1], -1)) {
                try {
                    if (OPTIONAL_LANE_PATTERN.matcher(toLane).matches()) {
                        toLane = toLane.replace("(", "").replace(")", "").trim();
                        connections.put(Integer.parseInt(toLane), Boolean.TRUE);
                        continue;
                    }
                    connections.put(Integer.parseInt(toLane), Boolean.FALSE);
                }
                catch (NumberFormatException e) {
                    if (MISSING_COMMA_PATTERN.matcher(toLane).matches()) {
                        connections.put(null, Boolean.TRUE);
                        continue;
                    }
                    connections.put(null, null);
                }
            }
            result.put(laneNumber, connections);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void visit(Relation r) {
        if (r.hasTag("type", CONNECTIVITY_TAG)) {
            if (!r.hasKey(CONNECTIVITY_TAG)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 3902).message(I18n.tr("Connectivity relation without connectivity tag", new Object[0])).primitives(r).build());
            } else if (!r.hasIncompleteMembers()) {
                Map<Integer, Map<Integer, Boolean>> connTagLanes = ConnectivityRelations.parseConnectivityTag(r);
                if (connTagLanes.isEmpty()) {
                    this.errors.add(TestError.builder(this, Severity.ERROR, 3903).message(I18n.tr("Connectivity tag contains unusual data", new Object[0])).primitives(r).build());
                } else {
                    boolean badRole = this.checkForBadRole(r);
                    boolean missingRole = ConnectivityRelations.checkForMissingRole(r);
                    if (!badRole && !missingRole) {
                        Map<String, Integer> roleLanes = this.checkForInconsistentLanes(r, connTagLanes);
                        this.checkForImpliedConnectivity(r, roleLanes, connTagLanes);
                    }
                }
            }
        }
    }

    private Map<String, Integer> checkForInconsistentLanes(Relation relation, Map<Integer, Map<Integer, Boolean>> connTagLanes) {
        StringBuilder lanelessRoles = new StringBuilder();
        int lanelessRolesCount = 0;
        HashMap<String, Integer> roleLanes = new HashMap<String, Integer>();
        if (connTagLanes.isEmpty()) {
            return roleLanes;
        }
        boolean defaultLanes = true;
        for (Map.Entry<Integer, Map<Integer, Boolean>> thisEntry : connTagLanes.entrySet()) {
            for (Map.Entry<Integer, Boolean> entry : thisEntry.getValue().entrySet()) {
                Logging.debug("Checking: " + entry.toString());
                if (entry.getKey() == null || entry.getKey() <= 1) continue;
                defaultLanes = false;
                break;
            }
            if (defaultLanes) continue;
            break;
        }
        for (RelationMember rM : relation.getMembers()) {
            if (rM.getType() != OsmPrimitiveType.WAY) continue;
            OsmPrimitive prim = rM.getMember();
            if (VIA.equals(rM.getRole())) continue;
            TagMap tagMap = prim.getKeys();
            ArrayList<Long> laneCounts = new ArrayList<Long>();
            if (prim.hasTag("lanes")) {
                laneCounts.add(Long.parseLong(prim.get("lanes")));
            }
            for (Map.Entry entry : tagMap.entrySet()) {
                String thisKey = (String)entry.getKey();
                String thisValue = (String)entry.getValue();
                if (!LANE_TAG_PATTERN.matcher(thisKey).matches()) continue;
                long count = thisValue.chars().filter(ch -> ch == 124).count() + 1L;
                laneCounts.add(count);
            }
            if (!laneCounts.isEmpty()) {
                long maxLaneCount = (Long)Collections.max(laneCounts);
                roleLanes.put(rM.getRole(), (int)maxLaneCount);
                continue;
            }
            if (lanelessRoles.length() > 0) {
                lanelessRoles.append(" and ");
            }
            lanelessRoles.append('\'').append(rM.getRole()).append('\'');
            ++lanelessRolesCount;
        }
        if (lanelessRoles.length() == 0) {
            boolean fromCheck = (Integer)roleLanes.get(FROM) < (Integer)Collections.max(connTagLanes.entrySet(), Comparator.comparingInt(Map.Entry::getKey)).getKey();
            boolean toCheck = false;
            for (Map.Entry<Integer, Object> entry : connTagLanes.entrySet()) {
                if (!((Map)entry.getValue()).containsKey(null)) {
                    toCheck = (Integer)roleLanes.get(TO) < (Integer)Collections.max(((Map)entry.getValue()).entrySet(), Comparator.comparingInt(Map.Entry::getKey)).getKey();
                    continue;
                }
                if (((Map)entry.getValue()).containsValue(true)) {
                    this.errors.add(TestError.builder(this, Severity.ERROR, 3904).message(I18n.tr("Connectivity tag missing comma between optional and non-optional values", new Object[0])).primitives(relation).build());
                    continue;
                }
                this.errors.add(TestError.builder(this, Severity.ERROR, 3903).message(I18n.tr("Connectivity tag contains unusual data", new Object[0])).primitives(relation).build());
            }
            if (fromCheck || toCheck) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 3900).message(I18n.tr("Inconsistent lane numbering between relation and member tags", new Object[0])).primitives(relation).build());
            }
        } else if (!defaultLanes) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3907).message(I18n.trn("Relation {0} member is missing a lanes or *:lanes tag", "Relation {0} members are missing a lanes or *:lanes tag", lanelessRolesCount, lanelessRoles)).primitives(relation).build());
        }
        return roleLanes;
    }

    private void checkForImpliedConnectivity(Relation relation, Map<String, Integer> roleLanes, Map<Integer, Map<Integer, Boolean>> connTagLanes) {
        boolean connImplied;
        boolean bl = connImplied = ConnectivityRelations.checkMemberTagsForImpliedConnectivity(relation, roleLanes) && !ConnectivityRelations.checkForIntersectionAtMembers(relation) && connTagLanes.entrySet().stream().noneMatch(to -> {
            int fromLane = (Integer)to.getKey();
            return ((Map)to.getValue()).entrySet().stream().anyMatch(lane -> lane.getKey() != null && fromLane != (Integer)lane.getKey());
        });
        if (connImplied) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3908).message(I18n.tr("This connectivity may already be implied", new Object[0])).primitives(relation).build());
        }
    }

    private static boolean checkForIntersectionAtMembers(Relation relation) {
        OsmPrimitive viaPrim = relation.findRelationMembers(VIA).get(0);
        Set<OsmPrimitive> relationMembers = relation.getMemberPrimitives();
        if (viaPrim.getType() == OsmPrimitiveType.NODE) {
            Node viaNode = (Node)viaPrim;
            List<Way> parentWays2 = viaNode.getParentWays();
            if (parentWays2.size() > 2) {
                return parentWays2.stream().anyMatch(thisWay -> !relationMembers.contains(thisWay) && thisWay.hasTag("highway"));
            }
        } else if (viaPrim.getType() == OsmPrimitiveType.WAY) {
            Way viaWay = (Way)viaPrim;
            return viaWay.getNodes().stream().map(Node::getParentWays).filter(parentWays -> parentWays.size() > 2).flatMap(Collection::stream).anyMatch(thisWay -> !relationMembers.contains(thisWay) && thisWay.hasTag("highway"));
        }
        return false;
    }

    private static boolean checkMemberTagsForImpliedConnectivity(Relation relation, Map<String, Integer> roleLanes) {
        if (roleLanes.containsKey(TO) && roleLanes.containsKey(FROM) && !roleLanes.get(TO).equals(roleLanes.get(FROM))) {
            return false;
        }
        List<RelationMember> members = relation.getMembers();
        HashMap<String, OsmPrimitive> toFromMembers = new HashMap<String, OsmPrimitive>();
        for (RelationMember mem : members) {
            if (mem.getRole().equals(FROM)) {
                toFromMembers.put(FROM, mem.getMember());
                continue;
            }
            if (!mem.getRole().equals(TO)) continue;
            toFromMembers.put(TO, mem.getMember());
        }
        return ((OsmPrimitive)toFromMembers.get(TO)).hasKey("placement") || ((OsmPrimitive)toFromMembers.get(FROM)).hasKey("placement");
    }

    private boolean checkForBadRole(Relation relation) {
        int viaWays = 0;
        int viaNodes = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember() instanceof Way) {
                if (relationMember.hasRole(VIA)) {
                    ++viaWays;
                    continue;
                }
                if (relationMember.hasRole(FROM) || relationMember.hasRole(TO)) continue;
                return true;
            }
            if (!(relationMember.getMember() instanceof Node)) continue;
            if (!relationMember.hasRole(VIA)) {
                return true;
            }
            ++viaNodes;
        }
        return this.mixedViaNodeAndWay(relation, viaWays, viaNodes);
    }

    private static boolean checkForMissingRole(Relation relation) {
        ArrayList<String> necessaryRoles = new ArrayList<String>();
        necessaryRoles.add(FROM);
        necessaryRoles.add(VIA);
        necessaryRoles.add(TO);
        return !relation.getMemberRoles().containsAll(necessaryRoles);
    }

    private boolean mixedViaNodeAndWay(Relation relation, int viaWays, int viaNodes) {
        String message = "";
        if (viaNodes > 1) {
            message = viaWays > 0 ? I18n.tr("Relation should not contain mixed ''via'' ways and nodes", new Object[0]) : I18n.tr("Multiple ''via'' roles only allowed with ways", new Object[0]);
        }
        if (message.isEmpty()) {
            return false;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 3905).message(message).primitives(relation).build());
        return true;
    }
}

