/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.PresetPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TaggingPresetPreference
extends DefaultTabPreferenceSetting {
    private static final List<SourceProvider> presetSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;
    private JCheckBox useValidator;
    private JCheckBox sortMenu;
    private final PreferenceTabbedPane.ValidationListener validationListener = new TaggingPresetValidationListener();

    private TaggingPresetPreference() {
        super("dialogs/propertiesdialog", I18n.tr("Tagging Presets", new Object[0]), I18n.tr("Tagging Presets", new Object[0]));
    }

    public static boolean registerSourceProvider(SourceProvider provider) {
        if (provider != null) {
            return presetSourceProviders.add(provider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.useValidator = new JCheckBox(I18n.tr("Run data validator on user input", new Object[0]), (boolean)TaggingPreset.USE_VALIDATOR.get());
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu alphabetically", new Object[0]), (boolean)TaggingPresets.SORT_MENU.get());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.useValidator, GBC.std().insets(5, 5, 0, 0));
        panel.add((Component)new JLabel(ImageProvider.get("dialogs/validator")), GBC.eol().insets(5, 5, 0, 0));
        panel.add((Component)this.sortMenu, GBC.eol().insets(5, 0, 5, 0));
        this.sources = new TaggingPresetSourceEditor();
        panel.add((Component)this.sources, GBC.eol().fill(1));
        PreferenceTabbedPane.PreferencePanel preferencePanel = gui.createPreferenceTab(this);
        preferencePanel.add((Component)panel, GBC.eol().fill(1));
        this.sources.deferLoading(gui, (Component)preferencePanel);
        gui.addValidationListener(this.validationListener);
    }

    @Override
    public boolean ok() {
        TaggingPreset.USE_VALIDATOR.put(this.useValidator.isSelected());
        if (this.sources.finish() || TaggingPresets.SORT_MENU.put(this.sortMenu.isSelected())) {
            TaggingPresets.destroy();
            TaggingPresets.initialize();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/TaggingPresetPreference");
    }

    private final class TaggingPresetValidationListener
    implements PreferenceTabbedPane.ValidationListener {
        private TaggingPresetValidationListener() {
        }

        @Override
        public boolean validatePreferences() {
            if (TaggingPresetPreference.this.sources.hasActiveSourcesChanged()) {
                ArrayList<Integer> sourcesToRemove = new ArrayList<Integer>();
                int i = -1;
                block15: for (SourceEntry source : TaggingPresetPreference.this.sources.getActiveSources()) {
                    ++i;
                    boolean canLoad = false;
                    try {
                        TaggingPresetReader.readAll(source.url, false);
                        canLoad = true;
                    }
                    catch (IOException e) {
                        Logging.log(Logging.LEVEL_WARN, I18n.tr("Could not read tagging preset source: {0}", source), e);
                        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Error", new Object[0]), I18n.tr("Yes", new Object[0]), I18n.tr("No", new Object[0]), I18n.tr("Cancel", new Object[0]));
                        ed.setContent(I18n.tr("Could not read tagging preset source: {0}\nDo you want to keep it?", source));
                        switch (ed.showDialog().getValue()) {
                            case 1: {
                                continue block15;
                            }
                            case 2: {
                                sourcesToRemove.add(i);
                                continue block15;
                            }
                        }
                        return false;
                    }
                    catch (SAXException e) {
                        Logging.trace(e);
                    }
                    String errorMessage = null;
                    try {
                        TaggingPresetReader.readAll(source.url, true);
                    }
                    catch (IOException e) {
                        String msg = I18n.tr("Could not read tagging preset source: {0}", source);
                        Logging.log(Logging.LEVEL_ERROR, msg, e);
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), msg);
                        return false;
                    }
                    catch (SAXParseException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), Utils.escapeReservedCharactersHTML(e.getMessage())) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=400>Error is: [{1}:{2}] {3}</table></html>", source, e.getLineNumber(), e.getColumnNumber(), Utils.escapeReservedCharactersHTML(e.getMessage()));
                        Logging.log(Logging.LEVEL_WARN, errorMessage, e);
                    }
                    catch (SAXException e) {
                        errorMessage = canLoad ? I18n.tr("<html>Tagging preset source {0} can be loaded but it contains errors. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, Utils.escapeReservedCharactersHTML(e.getMessage())) : I18n.tr("<html>Unable to parse tagging preset source: {0}. Do you really want to use it?<br><br><table width=600>Error is: {1}</table></html>", source, Utils.escapeReservedCharactersHTML(e.getMessage()));
                        Logging.log(Logging.LEVEL_ERROR, errorMessage, e);
                    }
                    if (errorMessage == null) continue;
                    Logging.error(errorMessage);
                    int result = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), new JLabel(errorMessage), I18n.tr("Error", new Object[0]), 1, 0);
                    switch (result) {
                        case 0: {
                            continue block15;
                        }
                        case 1: {
                            sourcesToRemove.add(i);
                            continue block15;
                        }
                    }
                    return false;
                }
                TaggingPresetPreference.this.sources.removeSources(sourcesToRemove);
                return true;
            }
            return true;
        }
    }

    public static class TaggingPresetSourceEditor
    extends SourceEditor {
        public TaggingPresetSourceEditor() {
            super(SourceType.TAGGING_PRESET, Config.getUrls().getJOSMWebsite() + "/presets", presetSourceProviders, true);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return PresetPrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            return this.doFinish(PresetPrefHelper.INSTANCE, TaggingPresets.ICON_SOURCES.getKey());
        }

        @Override
        public Collection<ExtendedSourceEntry> getDefault() {
            return PresetPrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return TaggingPresets.ICON_SOURCES.get();
        }

        @Override
        public String getStr(SourceEditor.I18nString ident) {
            switch (ident) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available presets:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active presets:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new preset by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New preset entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected presets from the list of active presets", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active preset", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available presets to the list of active presets", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available presets from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading preset sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of preset sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Presets#FailedToLoadPresetSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in preset list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

