/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class AttributionSupport {
    private Attributed source;
    private Image attrImage;
    private String attrTermsText;
    private String attrTermsUrl;
    public static final Font ATTR_FONT = new Font("Arial", 0, 10);
    public static final Font ATTR_LINK_FONT;
    protected Rectangle attrTextBounds;
    protected Rectangle attrToUBounds;
    protected Rectangle attrImageBounds;

    public void initialize(Attributed source) {
        this.source = source;
        boolean requireAttr = source.requiresAttribution();
        if (requireAttr) {
            this.attrImage = source.getAttributionImage();
            this.attrTermsText = source.getTermsOfUseText();
            this.attrTermsUrl = source.getTermsOfUseURL();
            if (this.attrTermsUrl != null && this.attrTermsText == null) {
                this.attrTermsText = FeatureAdapter.tr("Background Terms of Use", new Object[0]);
            }
        } else {
            this.attrImage = null;
            this.attrTermsUrl = null;
        }
    }

    public void paintAttribution(Graphics g, int width, int height, ICoordinate topLeft, ICoordinate bottomRight, int zoom, ImageObserver observer) {
        int y;
        int x;
        if (this.source == null || !this.source.requiresAttribution()) {
            this.attrToUBounds = null;
            this.attrImageBounds = null;
            this.attrTextBounds = null;
            return;
        }
        Font font = g.getFont();
        g.setFont(ATTR_LINK_FONT);
        int termsTextHeight = 0;
        int termsTextY = height;
        if (this.attrTermsText != null) {
            Rectangle2D termsStringBounds = g.getFontMetrics().getStringBounds(this.attrTermsText, g);
            int textRealHeight = (int)termsStringBounds.getHeight();
            termsTextHeight = textRealHeight - 5;
            int termsTextWidth = (int)termsStringBounds.getWidth();
            termsTextY = height - termsTextHeight;
            x = 2;
            y = height - termsTextHeight;
            this.attrToUBounds = new Rectangle(x, y - termsTextHeight, termsTextWidth, textRealHeight);
            g.setColor(Color.black);
            g.drawString(this.attrTermsText, x + 1, y + 1);
            g.setColor(Color.white);
            g.drawString(this.attrTermsText, x, y);
        } else {
            this.attrToUBounds = null;
        }
        if (this.attrImage != null) {
            int x2 = 2;
            int imgWidth = this.attrImage.getWidth(observer);
            int imgHeight = this.attrImage.getHeight(observer);
            int y2 = termsTextY - imgHeight - termsTextHeight - 5;
            this.attrImageBounds = new Rectangle(x2, y2, imgWidth, imgHeight);
            g.drawImage(this.attrImage, x2, y2, null);
        } else {
            this.attrImageBounds = null;
        }
        g.setFont(ATTR_FONT);
        String attributionText = this.source.getAttributionText(zoom, topLeft, bottomRight);
        if (attributionText == null) {
            attributionText = this.source.getAttributionLinkURL();
        }
        if (attributionText != null) {
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(attributionText, g);
            int textHeight = (int)stringBounds.getHeight() - 5;
            x = width - (int)stringBounds.getWidth();
            y = height - textHeight;
            g.setColor(Color.black);
            g.drawString(attributionText, x + 1, y + 1);
            g.setColor(Color.white);
            g.drawString(attributionText, x, y);
            this.attrTextBounds = new Rectangle(x, y - textHeight, (int)stringBounds.getWidth(), (int)stringBounds.getHeight());
        } else {
            this.attrTextBounds = null;
        }
        g.setFont(font);
    }

    public boolean handleAttributionCursor(Point p) {
        if (this.attrTextBounds != null && this.attrTextBounds.contains(p)) {
            return true;
        }
        if (this.attrImageBounds != null && this.attrImageBounds.contains(p)) {
            return true;
        }
        return this.attrToUBounds != null && this.attrToUBounds.contains(p);
    }

    public boolean handleAttribution(Point p, boolean click) {
        String termsOfUseURL;
        if (this.source == null || !this.source.requiresAttribution()) {
            return false;
        }
        if (this.attrTextBounds != null && this.attrTextBounds.contains(p)) {
            String attributionURL = this.source.getAttributionLinkURL();
            if (attributionURL != null) {
                if (click) {
                    FeatureAdapter.openLink(attributionURL);
                }
                return true;
            }
        } else if (this.attrImageBounds != null && this.attrImageBounds.contains(p)) {
            String attributionImageURL = this.source.getAttributionImageURL();
            if (attributionImageURL != null) {
                if (click) {
                    FeatureAdapter.openLink(this.source.getAttributionImageURL());
                }
                return true;
            }
        } else if (this.attrToUBounds != null && this.attrToUBounds.contains(p) && (termsOfUseURL = this.source.getTermsOfUseURL()) != null) {
            if (click) {
                FeatureAdapter.openLink(termsOfUseURL);
            }
            return true;
        }
        return false;
    }

    static {
        HashMap<TextAttribute, Integer> aUnderline = new HashMap<TextAttribute, Integer>();
        aUnderline.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(aUnderline);
    }
}

