/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;

public interface IBounds {
    default public ILatLon getMin() {
        return new LatLon(this.getMinLat(), this.getMinLon());
    }

    public double getMinLat();

    public double getMinLon();

    default public ILatLon getMax() {
        return new LatLon(this.getMaxLat(), this.getMaxLon());
    }

    public double getMaxLat();

    public double getMaxLon();

    public ILatLon getCenter();

    default public boolean contains(ILatLon ll) {
        return this.getMinLon() <= ll.lon() && ll.lon() <= this.getMaxLon() && this.getMinLat() <= ll.lat() && ll.lat() <= this.getMaxLat();
    }

    default public boolean contains(IBounds b) {
        return this.getMinLon() <= b.getMinLon() && this.getMaxLon() >= b.getMaxLon() && this.getMinLat() <= b.getMinLat() && this.getMaxLat() >= b.getMaxLat();
    }

    default public boolean intersects(IBounds b) {
        return this.getMinLon() <= b.getMaxLon() && this.getMaxLon() >= b.getMinLon() && this.getMinLat() <= b.getMaxLat() && this.getMaxLat() >= b.getMinLat();
    }

    public double getHeight();

    public double getWidth();

    default public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    default public boolean isValid() {
        return true;
    }

    default public boolean crosses180thMeridian() {
        return false;
    }
}

