/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.HostLimitQueue;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TMSCachedTileLoader
implements TileLoader,
CachedTileLoader {
    protected final ICacheAccess<String, BufferedImageCacheEntry> cache;
    protected final TileLoaderListener listener;
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobs", 25);
    public static final IntegerProperty HOST_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobsperhost", 6);
    private static final ThreadPoolExecutor DEFAULT_DOWNLOAD_JOB_DISPATCHER = TMSCachedTileLoader.getNewThreadPoolExecutor("TMS-downloader-%d");
    private ThreadPoolExecutor downloadExecutor = DEFAULT_DOWNLOAD_JOB_DISPATCHER;
    protected final TileJobOptions options;

    public TMSCachedTileLoader(TileLoaderListener listener, ICacheAccess<String, BufferedImageCacheEntry> cache, TileJobOptions options) {
        CheckParameterUtil.ensureParameterNotNull(cache, "cache");
        this.cache = cache;
        this.options = options;
        this.listener = listener;
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(String nameFormat, int workers) {
        return TMSCachedTileLoader.getNewThreadPoolExecutor(nameFormat, workers, HOST_LIMIT.get());
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(String nameFormat, int workers, int hostLimit) {
        return new ThreadPoolExecutor(workers, workers, 300L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new HostLimitQueue(hostLimit), Utils.newThreadFactory(nameFormat, 5));
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(String name) {
        return TMSCachedTileLoader.getNewThreadPoolExecutor(name, THREAD_LIMIT.get());
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new TMSCachedTileLoaderJob(this.listener, tile, this.cache, this.options, this.getDownloadExecutor());
    }

    @Override
    public void clearCache(TileSource source) {
        this.cache.remove(source.getName() + ":");
    }

    public String getStats() {
        return this.cache.getStats();
    }

    @Override
    public void cancelOutstandingTasks() {
        for (Runnable r : this.downloadExecutor.getQueue()) {
            if (!this.downloadExecutor.remove(r) || !(r instanceof TMSCachedTileLoaderJob)) continue;
            ((TMSCachedTileLoaderJob)r).handleJobCancellation();
        }
    }

    @Override
    public boolean hasOutstandingTasks() {
        return this.downloadExecutor.getTaskCount() > this.downloadExecutor.getCompletedTaskCount();
    }

    public void setDownloadExecutor(ThreadPoolExecutor downloadExecutor) {
        this.downloadExecutor = downloadExecutor;
    }

    public ThreadPoolExecutor getDownloadExecutor() {
        return this.downloadExecutor;
    }

    public void shutdown() {
        if (!this.downloadExecutor.equals(DEFAULT_DOWNLOAD_JOB_DISPATCHER)) {
            this.cancelOutstandingTasks();
            this.downloadExecutor.shutdown();
        }
    }
}

