/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.layer.LayerVisibilityAction;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.IGeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;
import org.openstreetmap.josm.gui.widgets.HideableTabbedPane;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ImageViewerDialog
extends ToggleDialog
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private static final String GEOIMAGE_FILLER = I18n.marktr("Geoimage: {0}");
    private static final String DIALOG_FOLDER = "dialogs";
    private final ImageryFilterSettings imageryFilterSettings = new ImageryFilterSettings();
    private final ImageZoomAction imageZoomAction = new ImageZoomAction();
    private final ImageCenterViewAction imageCenterViewAction = new ImageCenterViewAction();
    private final ImageNextAction imageNextAction = new ImageNextAction();
    private final ImageRemoveAction imageRemoveAction = new ImageRemoveAction();
    private final ImageRemoveFromDiskAction imageRemoveFromDiskAction = new ImageRemoveFromDiskAction();
    private final ImagePreviousAction imagePreviousAction = new ImagePreviousAction();
    private final ImageCollapseAction imageCollapseAction = new ImageCollapseAction();
    private final ImageFirstAction imageFirstAction = new ImageFirstAction();
    private final ImageLastAction imageLastAction = new ImageLastAction();
    private final ImageCopyPathAction imageCopyPathAction = new ImageCopyPathAction();
    private final ImageOpenExternalAction imageOpenExternalAction = new ImageOpenExternalAction();
    private final LayerVisibilityAction visibilityAction = new LayerVisibilityAction(Collections::emptyList, () -> Collections.singleton(this.imageryFilterSettings));
    private final ImageDisplay imgDisplay = new ImageDisplay(this.imageryFilterSettings);
    private Future<?> imgLoadingFuture;
    private boolean centerView;
    private static volatile ImageViewerDialog dialog;
    private boolean collapseButtonClicked;
    private JButton btnLast;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnFirst;
    private JButton btnCollapse;
    private JButton btnDelete;
    private JButton btnCopyPath;
    private JButton btnOpenExternal;
    private JButton btnDeleteFromDisk;
    private JToggleButton tbCentre;
    private final HideableTabbedPane layers = new HideableTabbedPane();
    private transient IImageEntry<? extends IImageEntry<?>> currentEntry;

    static void createInstance() {
        if (dialog != null) {
            throw new IllegalStateException("ImageViewerDialog instance was already created");
        }
        dialog = new ImageViewerDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageViewerDialog getInstance() {
        MapFrame map = MainApplication.getMap();
        Class<ImageViewerDialog> clazz = ImageViewerDialog.class;
        synchronized (ImageViewerDialog.class) {
            if (dialog == null) {
                ImageViewerDialog.createInstance();
            }
            if (map != null && map.getToggleDialog(ImageViewerDialog.class) == null) {
                map.addToggleDialog(dialog);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dialog;
        }
    }

    public static boolean hasInstance() {
        return dialog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyInstance() {
        MapFrame map = MainApplication.getMap();
        Class<ImageViewerDialog> clazz = ImageViewerDialog.class;
        synchronized (ImageViewerDialog.class) {
            if (dialog != null && map != null && map.getToggleDialog(ImageViewerDialog.class) != null) {
                map.removeToggleDialog(dialog);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            dialog = null;
            return;
        }
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Windows: {0}", I18n.tr("Geotagged Images", new Object[0])), 89, 5003), 200);
        this.build();
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
        for (Layer l2 : MainApplication.getLayerManager().getLayers()) {
            this.registerOnLayer(l2);
        }
        this.layers.getModel().addChangeListener(l -> MainApplication.worker.execute(() -> GuiHelper.runInEDT(() -> {
            Component selected = this.layers.getSelectedComponent();
            if (selected instanceof MoveImgDisplayPanel) {
                ((MoveImgDisplayPanel)selected).fireModelUpdate();
            }
        })));
    }

    private static JButton createButton(AbstractAction action, Dimension buttonDim) {
        JButton btn = new JButton(action);
        btn.setPreferredSize(buttonDim);
        btn.addPropertyChangeListener("enabled", e -> action.setEnabled(Boolean.TRUE.equals(e.getNewValue())));
        return btn;
    }

    private static JButton createNavigationButton(AbstractAction action, Dimension buttonDim) {
        JButton btn = ImageViewerDialog.createButton(action, buttonDim);
        btn.setEnabled(false);
        action.addPropertyChangeListener(l -> {
            if ("enabled".equals(l.getPropertyName())) {
                btn.setEnabled(action.isEnabled());
            }
        });
        return btn;
    }

    private void build() {
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.layers, "Center");
        Dimension buttonDim = new Dimension(26, 26);
        this.btnFirst = ImageViewerDialog.createNavigationButton(this.imageFirstAction, buttonDim);
        this.btnPrevious = ImageViewerDialog.createNavigationButton(this.imagePreviousAction, buttonDim);
        this.btnDelete = ImageViewerDialog.createButton(this.imageRemoveAction, buttonDim);
        this.btnDeleteFromDisk = ImageViewerDialog.createButton(this.imageRemoveFromDiskAction, buttonDim);
        this.btnCopyPath = ImageViewerDialog.createButton(this.imageCopyPathAction, buttonDim);
        this.btnOpenExternal = ImageViewerDialog.createButton(this.imageOpenExternalAction, buttonDim);
        this.btnNext = ImageViewerDialog.createNavigationButton(this.imageNextAction, buttonDim);
        this.btnLast = ImageViewerDialog.createNavigationButton(this.imageLastAction, buttonDim);
        this.tbCentre = new JToggleButton(this.imageCenterViewAction);
        this.tbCentre.setSelected(Config.getPref().getBoolean("geoimage.viewer.centre.on.image", false));
        this.tbCentre.setPreferredSize(buttonDim);
        JButton btnZoomBestFit = new JButton(this.imageZoomAction);
        btnZoomBestFit.setPreferredSize(buttonDim);
        this.btnCollapse = ImageViewerDialog.createButton(this.imageCollapseAction, new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel buttons = new JPanel();
        ImageViewerDialog.addButtonGroup(buttons, this.btnFirst, this.btnPrevious, this.btnNext, this.btnLast);
        ImageViewerDialog.addButtonGroup(buttons, this.tbCentre, btnZoomBestFit);
        ImageViewerDialog.addButtonGroup(buttons, this.btnDelete, this.btnDeleteFromDisk);
        ImageViewerDialog.addButtonGroup(buttons, this.btnCopyPath, this.btnOpenExternal);
        ImageViewerDialog.addButtonGroup(buttons, ImageViewerDialog.createButton(this.visibilityAction, buttonDim));
        JPanel bottomPane = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.weightx = 1.0;
        bottomPane.add((Component)buttons, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 20;
        gc.weightx = 0.0;
        bottomPane.add((Component)this.btnCollapse, gc);
        content.add((Component)bottomPane, "South");
        this.createLayout(content, false, null);
    }

    private static void addButtonGroup(JPanel buttonPanel, AbstractButton ... buttons) {
        if (buttonPanel.getComponentCount() != 0) {
            buttonPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        }
        for (AbstractButton jButton : buttons) {
            buttonPanel.add(jButton);
        }
    }

    private void updateLayers(boolean changed) {
        MainLayerManager layerManager = MainApplication.getLayerManager();
        List geoImageLayers = layerManager.getLayers().stream().filter(IGeoImageLayer.class::isInstance).map(IGeoImageLayer.class::cast).collect(Collectors.toList());
        if (geoImageLayers.isEmpty()) {
            this.layers.setVisible(false);
        } else {
            this.layers.setVisible(true);
            if (changed) {
                this.addButtonsForImageLayers();
            }
            MoveImgDisplayPanel selected = (MoveImgDisplayPanel)this.layers.getSelectedComponent();
            if ((this.imgDisplay.getParent() == null || this.imgDisplay.getParent().getParent() == null) && selected != null && ((IGeoImageLayer)((Object)selected.layer)).containsImage(this.currentEntry)) {
                selected.setVisible(selected.isVisible());
            } else if (selected != null && !((IGeoImageLayer)((Object)selected.layer)).containsImage(this.currentEntry)) {
                this.getImageTabs().filter(m -> ((IGeoImageLayer)((Object)((MoveImgDisplayPanel)m).layer)).containsImage(this.currentEntry)).mapToInt(this.layers::indexOfComponent).findFirst().ifPresent(this.layers::setSelectedIndex);
            }
            this.layers.invalidate();
        }
        this.layers.getParent().invalidate();
        this.revalidate();
    }

    private void addButtonsForImageLayers() {
        List alreadyAdded = this.getImageTabs().collect(Collectors.toList());
        List<Layer> availableLayers = MainApplication.getLayerManager().getLayers();
        List geoImageLayers = availableLayers.stream().sorted(Comparator.comparingInt(entry -> -availableLayers.indexOf(entry))).filter(IGeoImageLayer.class::isInstance).map(IGeoImageLayer.class::cast).collect(Collectors.toList());
        List tabLayers = geoImageLayers.stream().filter(l -> alreadyAdded.stream().anyMatch(m -> Objects.equals(l, ((MoveImgDisplayPanel)m).layer)) || l.containsImage(this.currentEntry)).collect(Collectors.toList());
        for (IGeoImageLayer layer2 : tabLayers) {
            MoveImgDisplayPanel panel = alreadyAdded.stream().filter(m -> Objects.equals(((MoveImgDisplayPanel)m).layer, layer2)).findFirst().orElseGet(() -> new MoveImgDisplayPanel<Layer>(this.imgDisplay, (Layer)((Object)layer2)));
            int componentIndex = this.layers.indexOfComponent(panel);
            if (componentIndex == geoImageLayers.indexOf(layer2)) {
                this.layers.setTitleAt(componentIndex, panel.getLabel(availableLayers));
            } else {
                this.removeImageTab((Layer)((Object)layer2));
                this.layers.insertTab(panel.getLabel(availableLayers), null, panel, null, tabLayers.indexOf(layer2));
                int idx = this.layers.indexOfComponent(panel);
                CloseableTab closeableTab = new CloseableTab(this.layers, l -> {
                    Component source = (Component)l.getSource();
                    do {
                        int index;
                        if ((index = this.layers.indexOfTabComponent(source)) < 0) continue;
                        this.removeImageTab(((MoveImgDisplayPanel)this.layers.getComponentAt(index)).layer);
                        this.getImageTabs().forEach(m -> m.setVisible(m.isVisible()));
                        return;
                    } while ((source = source.getParent()) != null);
                });
                this.layers.setTabComponentAt(idx, closeableTab);
            }
            if (!layer2.containsImage(this.currentEntry)) continue;
            this.layers.setSelectedComponent(panel);
        }
        this.getImageTabs().map(p -> ((MoveImgDisplayPanel)p).layer).filter(layer -> !availableLayers.contains(layer)).collect(Collectors.toList()).forEach(x$0 -> this.removeImageTab((Layer)x$0));
        this.getImageTabs().forEach(m -> m.setVisible(m.isVisible()));
    }

    private void removeImageTab(Layer layer) {
        for (int i = this.layers.getTabCount() - 1; i >= 0; --i) {
            MoveImgDisplayPanel moveImgDisplayPanel;
            Component component = this.layers.getComponentAt(i);
            if (!(component instanceof MoveImgDisplayPanel) || !Objects.equals(layer, (moveImgDisplayPanel = (MoveImgDisplayPanel)component).layer)) continue;
            this.layers.removeTabAt(i);
            this.layers.remove(moveImgDisplayPanel);
        }
    }

    private Stream<MoveImgDisplayPanel<?>> getImageTabs() {
        return IntStream.range(0, this.layers.getTabCount()).mapToObj(this.layers::getComponentAt).filter(MoveImgDisplayPanel.class::isInstance).map(m -> (MoveImgDisplayPanel)m);
    }

    @Override
    public void destroy() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        this.imageFirstAction.destroy();
        this.imageLastAction.destroy();
        this.imagePreviousAction.destroy();
        this.imageNextAction.destroy();
        this.imageCenterViewAction.destroy();
        this.imageCollapseAction.destroy();
        this.imageCopyPathAction.destroy();
        this.imageOpenExternalAction.destroy();
        this.imageRemoveAction.destroy();
        this.imageRemoveFromDiskAction.destroy();
        this.imageZoomAction.destroy();
        this.cancelLoadingImage();
        super.destroy();
        ImageViewerDialog.destroyInstance();
    }

    public void setPreviousEnabled(boolean value) {
        this.imageFirstAction.updateEnabledState();
        this.btnFirst.setEnabled(value || this.imageFirstAction.isEnabled());
        this.btnPrevious.setEnabled(value);
    }

    public void setNextEnabled(boolean value) {
        this.btnNext.setEnabled(value);
        this.imageLastAction.updateEnabledState();
        this.btnLast.setEnabled(value || this.imageLastAction.isEnabled());
    }

    public static synchronized boolean setCentreEnabled(boolean value) {
        ImageViewerDialog instance = ImageViewerDialog.getInstance();
        boolean wasEnabled = instance.tbCentre.isEnabled();
        instance.tbCentre.setEnabled(value);
        instance.tbCentre.getAction().actionPerformed(new ActionEvent(instance.tbCentre, 0, null));
        return wasEnabled;
    }

    public void displayImage(ImageData ignoredData, ImageEntry entry) {
        this.displayImages(Collections.singletonList(entry));
    }

    public void displayImage(IImageEntry<?> entry) {
        this.displayImages(Collections.singletonList(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImages(List<? extends IImageEntry<?>> entries) {
        boolean updateRequired;
        boolean imageChanged;
        IImageEntry<?> entry = entries != null && entries.size() == 1 ? entries.get(0) : null;
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            boolean bl = imageChanged = this.currentEntry != entry;
            if (this.centerView && entry != null && MainApplication.isDisplayingMapView() && entry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(entry.getPos());
            }
            this.currentEntry = entry;
            for (ImageAction action : Arrays.asList(this.imageFirstAction, this.imagePreviousAction, this.imageNextAction, this.imageLastAction)) {
                action.updateEnabledState();
            }
        }
        List imageLayers = MainApplication.getLayerManager().getLayers().stream().filter(IGeoImageLayer.class::isInstance).map(IGeoImageLayer.class::cast).collect(Collectors.toList());
        if (!Config.getPref().getBoolean("geoimage.viewer.show.tabs", true)) {
            updateRequired = true;
            this.getImageTabs().map(m -> ((MoveImgDisplayPanel)m).layer).filter(arg_0 -> ImageViewerDialog.lambda$displayImages$20(IGeoImageLayer.class, arg_0)).map(arg_0 -> ImageViewerDialog.lambda$displayImages$21(IGeoImageLayer.class, arg_0)).filter(l -> !Objects.equals(entries, l.getSelection())).forEach(IGeoImageLayer::clearSelection);
        } else {
            updateRequired = imageLayers.stream().anyMatch(l -> this.getImageTabs().map(m -> ((MoveImgDisplayPanel)m).layer).noneMatch(x$0 -> l.equals(x$0)));
        }
        this.updateLayers(updateRequired);
        if (entry == null) {
            if (imageLayers.isEmpty()) {
                this.updateButtonsNullEntry(entries);
                return;
            }
            IGeoImageLayer layer = this.getImageTabs().map(m -> ((MoveImgDisplayPanel)m).layer).filter(l -> ((IGeoImageLayer)((Object)l)).getSelection().size() == 1).findFirst().orElse(null);
            if (layer == null) {
                this.updateButtonsNullEntry(entries);
            } else {
                this.displayImages(layer.getSelection());
            }
            return;
        }
        this.updateButtonsNonNullEntry(entry, imageChanged);
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    private void updateButtonsNullEntry(List<? extends IImageEntry<?>> entries) {
        boolean hasMultipleImages = entries != null && entries.size() > 1;
        this.updateTitle();
        this.imgDisplay.setImage(null);
        this.imgDisplay.setOsdText("");
        this.setNextEnabled(false);
        this.setPreviousEnabled(false);
        this.btnDelete.setEnabled(hasMultipleImages);
        this.btnDeleteFromDisk.setEnabled(hasMultipleImages);
        this.btnCopyPath.setEnabled(false);
        this.btnOpenExternal.setEnabled(false);
        if (hasMultipleImages) {
            this.imgDisplay.setEmptyText(I18n.tr("Multiple images selected", new Object[0]));
            this.btnFirst.setEnabled(!ImageViewerDialog.isFirstImageSelected(entries));
            this.btnLast.setEnabled(!ImageViewerDialog.isLastImageSelected(entries));
        }
        this.imgDisplay.setImage(null);
        this.imgDisplay.setOsdText("");
    }

    private void updateButtonsNonNullEntry(IImageEntry<?> entry, boolean imageChanged) {
        if (imageChanged) {
            this.cancelLoadingImage();
            this.imgLoadingFuture = this.imgDisplay.setImage(entry);
        }
        this.setNextEnabled(entry.getNextImage() != null);
        this.setPreviousEnabled(entry.getPreviousImage() != null);
        this.btnDelete.setEnabled(entry.isRemoveSupported());
        this.btnDeleteFromDisk.setEnabled(entry.isDeleteSupported() && entry.isRemoveSupported());
        this.btnCopyPath.setEnabled(true);
        this.btnOpenExternal.setEnabled(true);
        this.updateTitle();
        StringBuilder osd = new StringBuilder(entry.getDisplayName());
        if (entry.getElevation() != null) {
            osd.append(I18n.tr("\nAltitude: {0} m", Math.round(entry.getElevation())));
        }
        if (entry.getSpeed() != null) {
            osd.append(I18n.tr("\nSpeed: {0} km/h", Math.round(entry.getSpeed())));
        }
        if (entry.getExifImgDir() != null) {
            osd.append(I18n.tr("\nDirection {0}\u00b0", Math.round(entry.getExifImgDir())));
        }
        DateTimeFormatter dtf = DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.MEDIUM).withZone(ZoneOffset.UTC);
        if (entry.hasExifTime()) {
            osd.append(I18n.tr("\nEXIF time: {0}", dtf.format(entry.getExifInstant())));
        }
        if (entry.hasGpsTime()) {
            osd.append(I18n.tr("\nGPS time: {0}", dtf.format(entry.getGpsInstant())));
        }
        Optional.ofNullable(entry.getIptcCaption()).map(s -> I18n.tr("\nCaption: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcHeadline()).map(s -> I18n.tr("\nHeadline: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcKeywords()).map(s -> I18n.tr("\nKeywords: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcObjectName()).map(s -> I18n.tr("\nObject name: {0}", s)).ifPresent(osd::append);
        this.imgDisplay.setOsdText(osd.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTitle() {
        IImageEntry<IImageEntry<?>> entry;
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            entry = this.currentEntry;
        }
        String baseTitle = Optional.ofNullable(this.layers.getSelectedComponent()).filter(MoveImgDisplayPanel.class::isInstance).map(MoveImgDisplayPanel.class::cast).map(m -> ((MoveImgDisplayPanel)m).layer).map(Layer::getLabel).orElse(I18n.tr("Geotagged Images", new Object[0]));
        if (entry == null) {
            this.setTitle(baseTitle);
        } else {
            this.setTitle(baseTitle + (!entry.getDisplayName().isEmpty() ? " - " + entry.getDisplayName() : ""));
        }
    }

    private static boolean isLastImageSelected(List<? extends IImageEntry<?>> data) {
        return data.stream().anyMatch(image -> data.contains(image.getLastImage()));
    }

    private static boolean isFirstImageSelected(List<? extends IImageEntry<?>> data) {
        return data.stream().anyMatch(image -> data.contains(image.getFirstImage()));
    }

    @Override
    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return super.dockWhenClosingDetachedDlg();
        }
        return false;
    }

    @Override
    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
        this.updateLayers(true);
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    public static IImageEntry<?> getCurrentImage() {
        return ImageViewerDialog.getInstance().currentEntry;
    }

    public Vector3D getRotation(IImageEntry<?> entry) {
        return this.imgDisplay.getRotation(entry);
    }

    public static boolean isCenterView() {
        return ImageViewerDialog.getInstance().centerView;
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.registerOnLayer(e.getAddedLayer());
        this.showLayer(e.getAddedLayer());
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof IGeoImageLayer && ((IGeoImageLayer)((Object)e.getRemovedLayer())).containsImage(this.currentEntry)) {
            this.displayImages(null);
        }
        this.updateLayers(true);
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        this.updateLayers(true);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (!MainApplication.worker.isShutdown()) {
            this.showLayer(e.getSource().getActiveLayer());
        }
    }

    public void refresh() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateButtonsNonNullEntry(this.currentEntry, true);
        } else {
            GuiHelper.runInEDT(this::refresh);
        }
    }

    private void registerOnLayer(Layer layer) {
        if (layer instanceof IGeoImageLayer) {
            layer.addPropertyChangeListener(l -> {
                List currentTabLayers = this.getImageTabs().map(m -> ((MoveImgDisplayPanel)m).layer).collect(Collectors.toList());
                if (Layer.NAME_PROP.equals(l.getPropertyName()) && currentTabLayers.contains(layer)) {
                    this.updateLayers(true);
                    if (((IGeoImageLayer)((Object)layer)).containsImage(this.currentEntry)) {
                        this.updateTitle();
                    }
                }
            });
        }
    }

    private void showLayer(Layer newLayer) {
        if (this.currentEntry == null && newLayer instanceof GeoImageLayer) {
            ImageData imageData = ((GeoImageLayer)newLayer).getImageData();
            imageData.setSelectedImage(imageData.getFirstImage());
        }
        if (newLayer instanceof IGeoImageLayer) {
            this.updateLayers(true);
        }
    }

    private void cancelLoadingImage() {
        if (this.imgLoadingFuture != null) {
            this.imgLoadingFuture.cancel(false);
            this.imgLoadingFuture = null;
        }
    }

    private static /* synthetic */ IGeoImageLayer lambda$displayImages$21(Class rec$, Object x$0) {
        return (IGeoImageLayer)rec$.cast(x$0);
    }

    private static /* synthetic */ boolean lambda$displayImages$20(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    private class ImageRemoveAction
    extends JosmAction {
        ImageRemoveAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "delete"), I18n.tr("Remove photo from layer", new Object[0]), Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Remove photo from layer", new Object[0])), 127, 5005), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                IImageEntry imageEntry = ImageViewerDialog.this.currentEntry;
                if (imageEntry.isRemoveSupported()) {
                    imageEntry.remove();
                }
                this.selectNextImageAfterDeletion(imageEntry);
            }
        }

        private void selectNextImageAfterDeletion(IImageEntry<?> oldEntry) {
            IImageEntry currentImageEntry = ImageViewerDialog.this.currentEntry;
            if (Objects.equals(currentImageEntry, oldEntry)) {
                Object nextImage = oldEntry instanceof ImageEntry ? ((ImageEntry)oldEntry).getDataSet().getSelectedImage() : (oldEntry.getNextImage() != null ? oldEntry.getNextImage() : (oldEntry.getPreviousImage() != null ? oldEntry.getPreviousImage() : null));
                ImageViewerDialog.getInstance().displayImages(nextImage == null ? null : Collections.singletonList(nextImage));
            }
        }
    }

    private class ImageFirstAction
    extends ImageRememberAction {
        ImageFirstAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "first"), I18n.tr("First", new Object[0]), Shortcut.registerShortcut("geoimage:first", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show first Image", new Object[0])), 36, 5003), false, null, false, IImageEntry::getFirstImage);
        }
    }

    private class ImageLastAction
    extends ImageRememberAction {
        ImageLastAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "last"), I18n.tr("Last", new Object[0]), Shortcut.registerShortcut("geoimage:last", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show last Image", new Object[0])), 35, 5003), false, null, false, IImageEntry::getLastImage);
        }
    }

    private class ImageZoomAction
    extends JosmAction {
        ImageZoomAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
        }
    }

    private class ImageCenterViewAction
    extends JosmAction {
        ImageCenterViewAction() {
            super(null, new ImageProvider("dialogs/autoscale", "selection"), I18n.tr("Center view", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button = (JToggleButton)e.getSource();
            ImageViewerDialog.this.centerView = button.isEnabled() && button.isSelected();
            Config.getPref().putBoolean("geoimage.viewer.centre.on.image", ImageViewerDialog.this.centerView);
            if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
            }
        }
    }

    private class ImageNextAction
    extends ImageAction {
        ImageNextAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "next"), I18n.tr("Next", new Object[0]), Shortcut.registerShortcut("geoimage:next", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show next Image", new Object[0])), 34, 5003), false, null, false, IImageEntry::getNextImage);
        }
    }

    private class ImageRemoveFromDiskAction
    extends JosmAction {
        ImageRemoveFromDiskAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]), Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Delete image file from disk", new Object[0])), 127, 5009), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                IImageEntry oldEntry = ImageViewerDialog.this.currentEntry;
                List<Object> toDelete = oldEntry instanceof ImageEntry ? new ArrayList<ImageEntry>(((ImageEntry)oldEntry).getDataSet().getSelectedImages()) : Collections.singletonList(oldEntry);
                int size = toDelete.size();
                int result = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Delete image file from disk", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Delete", new Object[0])).setButtonIcons("cancel", "dialogs/geoimage/deletefromdisk").setContent(new JLabel("<html><h3>" + I18n.trn("Delete the file from disk?", "Delete the {0} files from disk?", size, size) + "<p>" + I18n.trn("The image file will be permanently lost!", "The images files will be permanently lost!", size, new Object[0]) + "</h3></html>", ImageProvider.get("dialogs/geoimage/deletefromdisk"), 10)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
                if (result == 2) {
                    List<ImageData> imageDataCollection = toDelete.stream().filter(ImageEntry.class::isInstance).map(ImageEntry.class::cast).map(ImageEntry::getDataSet).distinct().collect(Collectors.toList());
                    for (IImageEntry iImageEntry : toDelete) {
                        if (iImageEntry.isRemoveSupported() && iImageEntry.isDeleteSupported() && iImageEntry.remove() && iImageEntry.delete()) {
                            Logging.info("File {0} deleted.", iImageEntry.getFile());
                            continue;
                        }
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Image file could not be deleted.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                    }
                    imageDataCollection.forEach(data -> {
                        data.notifyImageUpdate();
                        data.updateSelectedImage();
                    });
                    ImageViewerDialog.this.imageRemoveAction.selectNextImageAfterDeletion(oldEntry);
                }
            }
        }
    }

    private class ImagePreviousAction
    extends ImageAction {
        ImagePreviousAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "previous"), I18n.tr("Previous", new Object[0]), Shortcut.registerShortcut("geoimage:previous", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show previous Image", new Object[0])), 33, 5003), false, null, false, IImageEntry::getPreviousImage);
        }
    }

    private class ImageCollapseAction
    extends JosmAction {
        ImageCollapseAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "collapse"), I18n.tr("Move dialog to the side pane", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.collapseButtonClicked = true;
            ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
        }
    }

    private class ImageCopyPathAction
    extends JosmAction {
        ImageCopyPathAction() {
            super(null, new ImageProvider("copy"), I18n.tr("Copy image path", new Object[0]), Shortcut.registerShortcut("geoimage:copypath", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Copy image path", new Object[0])), 67, 5010), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                ClipboardUtils.copyString(String.valueOf(ImageViewerDialog.this.currentEntry.getImageURI()));
            }
        }
    }

    private class ImageOpenExternalAction
    extends JosmAction {
        ImageOpenExternalAction() {
            super(null, new ImageProvider("external-link"), I18n.tr("Open image in external viewer", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getImageURI() != null) {
                try {
                    PlatformManager.getPlatform().openUrl(ImageViewerDialog.this.currentEntry.getImageURI().toURL().toExternalForm());
                }
                catch (IOException ex) {
                    Logging.error(ex);
                }
            }
        }
    }

    private static class MoveImgDisplayPanel<T extends Layer>
    extends JPanel {
        private final T layer;
        private final ImageDisplay imgDisplay;

        MoveImgDisplayPanel(ImageDisplay imgDisplay, T layer) {
            super(new BorderLayout());
            this.layer = layer;
            this.imgDisplay = imgDisplay;
        }

        void fireModelUpdate() {
            HideableTabbedPane layers = ImageViewerDialog.getInstance().layers;
            int index = layers.indexOfComponent(this);
            if (this == layers.getSelectedComponent()) {
                if (!((IGeoImageLayer)this.layer).getSelection().isEmpty() && !((IGeoImageLayer)this.layer).getSelection().contains(ImageViewerDialog.getCurrentImage())) {
                    ImageViewerDialog.getInstance().displayImages(((IGeoImageLayer)this.layer).getSelection());
                    ((AbstractMapViewPaintable)this.layer).invalidate();
                }
                if (this.imgDisplay.getParent() != this) {
                    this.add((Component)this.imgDisplay, "Center");
                    this.imgDisplay.invalidate();
                    this.revalidate();
                }
                if (index >= 0) {
                    layers.setTitleAt(index, "* " + this.getLabel(MainApplication.getLayerManager().getLayers()));
                }
            } else if (index >= 0) {
                layers.setTitleAt(index, this.getLabel(MainApplication.getLayerManager().getLayers()));
            }
        }

        String getLabel(List<Layer> availableLayers) {
            int index = availableLayers.size() - availableLayers.indexOf(this.layer);
            return (ExpertToggleAction.isExpert() ? "[" + index + "] " : "") + ((Layer)this.layer).getLabel();
        }
    }

    private static class CloseableTab
    extends JPanel
    implements PropertyChangeListener {
        private final JLabel title = new JLabel();
        private final JButton close;

        CloseableTab(Component parent, ActionListener closeAction) {
            this.add(this.title);
            this.close = new JButton(ImageProvider.get("misc", "close"));
            this.close.setBorder(BorderFactory.createEmptyBorder());
            this.add(this.close);
            this.close.addActionListener(closeAction);
            this.close.addActionListener(l -> parent.removePropertyChangeListener("indexForTitle", this));
            parent.addPropertyChangeListener("indexForTitle", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JTabbedPane) {
                int idx;
                JTabbedPane source = (JTabbedPane)evt.getSource();
                if (this.getParent() == null) {
                    source.removePropertyChangeListener(evt.getPropertyName(), this);
                }
                if ("indexForTitle".equals(evt.getPropertyName()) && (idx = source.indexOfTabComponent(this)) >= 0) {
                    this.title.setText(source.getTitleAt(idx));
                }
                this.title.setVisible(source.getTabCount() != 1);
                this.close.setVisible(source.getTabCount() != 1);
            }
        }
    }

    private abstract class ImageAction
    extends JosmAction {
        final SerializableUnaryOperator<IImageEntry<?>> supplier;

        ImageAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdaptors, SerializableUnaryOperator<IImageEntry<?>> supplier) {
            super(name, icon, tooltip, shortcut, registerInToolbar, toolbarId, installAdaptors);
            Objects.requireNonNull(supplier);
            this.supplier = supplier;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            IImageEntry entry = ImageViewerDialog.this.currentEntry;
            if (entry != null) {
                IImageEntry nextEntry = (IImageEntry)this.getSupplier().apply(entry);
                entry.selectImage(ImageViewerDialog.this, nextEntry);
            }
            this.resetRememberActions();
        }

        void resetRememberActions() {
            for (ImageRememberAction action : Arrays.asList(ImageViewerDialog.this.imageLastAction, ImageViewerDialog.this.imageFirstAction)) {
                action.last = null;
                action.updateEnabledState();
            }
        }

        SerializableUnaryOperator<IImageEntry<?>> getSupplier() {
            return this.supplier;
        }

        @Override
        protected void updateEnabledState() {
            IImageEntry entry = ImageViewerDialog.this.currentEntry;
            this.setEnabled(entry != null && this.getSupplier().apply(entry) != null);
        }
    }

    private abstract class ImageRememberAction
    extends ImageAction {
        private final ImageProvider defaultIcon;
        transient IImageEntry<?> last;

        ImageRememberAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdaptors, SerializableUnaryOperator<IImageEntry<?>> supplier) {
            super(name, icon, tooltip, shortcut, registerInToolbar, toolbarId, installAdaptors, supplier);
            this.defaultIcon = icon;
        }

        public void updateIcon() {
            if (this.last != null) {
                new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "history").getResource().attachImageIcon(this, true);
            } else {
                this.defaultIcon.getResource().attachImageIcon(this, true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            IImageEntry current = ImageViewerDialog.this.currentEntry;
            IImageEntry expected = (IImageEntry)this.supplier.apply(current);
            if (current != null) {
                IImageEntry nextEntry = (IImageEntry)this.getSupplier().apply(current);
                current.selectImage(ImageViewerDialog.this, nextEntry);
            }
            this.resetRememberActions();
            this.last = !Objects.equals(current, expected) ? current : null;
            this.updateEnabledState();
        }

        @Override
        protected void updateEnabledState() {
            IImageEntry nextEntry;
            IImageEntry current = ImageViewerDialog.this.currentEntry;
            IImageEntry iImageEntry = nextEntry = current != null ? (IImageEntry)this.getSupplier().apply(current) : null;
            if (this.last == null && nextEntry != null && nextEntry.equals(current)) {
                this.setEnabled(false);
            } else {
                super.updateEnabledState();
            }
            this.updateIcon();
        }

        @Override
        SerializableUnaryOperator<IImageEntry<?>> getSupplier() {
            if (this.last != null) {
                return entry -> this.last;
            }
            return super.getSupplier();
        }
    }

    @FunctionalInterface
    private static interface SerializableUnaryOperator<I>
    extends UnaryOperator<I>,
    Serializable {
    }
}

