/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Date;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.TooManyRequestsException;

class ErrorRequestLimiter
extends RequestLimiter {
    ErrorRequestLimiter(int requestLimit, int requestLimitPeriodInSeconds) {
        super(requestLimit, 0, requestLimitPeriodInSeconds);
    }

    boolean wouldAccessBeOkay(String ipAddress) {
        try {
            this.checkLimit(ipAddress);
            return true;
        }
        catch (TooManyRequestsException e) {
            return false;
        }
    }

    void logAccess(String ipAddress) {
        while (this.requestEvents.size() > 1000) {
            this.requestEvents.remove(0);
        }
        this.requestEvents.add(new RequestLimiter.RequestEvent(ipAddress, new Date(), 0));
    }
}

