/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class MultipleWhitespaceRuleTest {
    @Test
    public void testRule() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        this.setUpRule(lt);
        this.assertGood("This is a test sentence.", lt);
        this.assertGood("This is a test sentence...", lt);
        this.assertGood("\n\tThis is a test sentence...", lt);
        this.assertGood("Multiple tabs\t\tare okay", lt);
        this.assertGood("\n This is a test sentence...", lt);
        this.assertGood("\n    This is a test sentence...", lt);
        List matches = lt.check("This  is a test sentence.");
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((long)4L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)6L, (long)((RuleMatch)matches.get(0)).getToPos());
        matches = lt.check("\n   This  is a test sentence.");
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((long)8L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)10L, (long)((RuleMatch)matches.get(0)).getToPos());
        matches = lt.check("This is a test   sentence.");
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((long)14L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)17L, (long)((RuleMatch)matches.get(0)).getToPos());
        matches = lt.check("This is   a  test   sentence.");
        Assert.assertEquals((long)3L, (long)matches.size());
        Assert.assertEquals((long)7L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)10L, (long)((RuleMatch)matches.get(0)).getToPos());
        Assert.assertEquals((long)11L, (long)((RuleMatch)matches.get(1)).getFromPos());
        Assert.assertEquals((long)13L, (long)((RuleMatch)matches.get(1)).getToPos());
        Assert.assertEquals((long)17L, (long)((RuleMatch)matches.get(2)).getFromPos());
        Assert.assertEquals((long)20L, (long)((RuleMatch)matches.get(2)).getToPos());
        matches = lt.check("\t\t\t    \t\t\t\t  ");
        Assert.assertEquals((long)2L, (long)matches.size());
        matches = lt.check("This \u00a0is a test sentence.");
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((long)4L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)6L, (long)((RuleMatch)matches.get(0)).getToPos());
    }

    private void assertGood(String input, JLanguageTool langTool) throws IOException {
        List ruleMatches = langTool.check(input);
        Assert.assertEquals((long)0L, (long)ruleMatches.size());
    }

    private void setUpRule(JLanguageTool lt) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        MultipleWhitespaceRule rule = new MultipleWhitespaceRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        lt.addRule((Rule)rule);
    }

    public static MultipleWhitespaceRule getMultipleWhitespaceRule(JLanguageTool langTool) {
        for (Rule rule : langTool.getAllActiveRules()) {
            if (!(rule instanceof MultipleWhitespaceRule)) continue;
            return (MultipleWhitespaceRule)rule;
        }
        throw new RuntimeException("Rule not found: " + GenericUnpairedBracketsRule.class);
    }
}

