/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.List;
import java.util.ListIterator;

public abstract class KeywordExtractor {
    protected Segment defaultSegment;

    public KeywordExtractor(Segment defaultSegment) {
        this.defaultSegment = defaultSegment;
    }

    public KeywordExtractor() {
        this(StandardTokenizer.SEGMENT);
    }

    protected boolean shouldInclude(Term term) {
        return CoreStopWordDictionary.shouldInclude(term);
    }

    public KeywordExtractor setSegment(Segment segment) {
        this.defaultSegment = segment;
        return this;
    }

    public Segment getSegment() {
        return this.defaultSegment;
    }

    public List<String> getKeywords(String document, int size) {
        return this.getKeywords(this.defaultSegment.seg(document), size);
    }

    public List<String> getKeywords(String document) {
        return this.getKeywords(this.defaultSegment.seg(document), 10);
    }

    protected void filter(List<Term> termList) {
        ListIterator<Term> listIterator = termList.listIterator();
        while (listIterator.hasNext()) {
            if (this.shouldInclude(listIterator.next())) continue;
            listIterator.remove();
        }
    }

    public abstract List<String> getKeywords(List<Term> var1, int var2);
}

