/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.BulkMoveResourcesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class BulkMoveResourcesRequest
extends BmcRequest<BulkMoveResourcesDetails> {
    private String compartmentId;
    private BulkMoveResourcesDetails bulkMoveResourcesDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public BulkMoveResourcesDetails getBody$() {
        return this.bulkMoveResourcesDetails;
    }

    @ConstructorProperties(value={"compartmentId", "bulkMoveResourcesDetails", "opcRequestId", "opcRetryToken"})
    BulkMoveResourcesRequest(String compartmentId, BulkMoveResourcesDetails bulkMoveResourcesDetails, String opcRequestId, String opcRetryToken) {
        this.compartmentId = compartmentId;
        this.bulkMoveResourcesDetails = bulkMoveResourcesDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).bulkMoveResourcesDetails(this.bulkMoveResourcesDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public String toString() {
        return "BulkMoveResourcesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", bulkMoveResourcesDetails=" + this.getBulkMoveResourcesDetails() + ", opcRequestId=" + this.getOpcRequestId() + ", opcRetryToken=" + this.getOpcRetryToken() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkMoveResourcesRequest)) {
            return false;
        }
        BulkMoveResourcesRequest other = (BulkMoveResourcesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        BulkMoveResourcesDetails this$bulkMoveResourcesDetails = this.getBulkMoveResourcesDetails();
        BulkMoveResourcesDetails other$bulkMoveResourcesDetails = other.getBulkMoveResourcesDetails();
        if (this$bulkMoveResourcesDetails == null ? other$bulkMoveResourcesDetails != null : !((Object)this$bulkMoveResourcesDetails).equals(other$bulkMoveResourcesDetails)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        return !(this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BulkMoveResourcesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        BulkMoveResourcesDetails $bulkMoveResourcesDetails = this.getBulkMoveResourcesDetails();
        result = result * 59 + ($bulkMoveResourcesDetails == null ? 43 : ((Object)$bulkMoveResourcesDetails).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public BulkMoveResourcesDetails getBulkMoveResourcesDetails() {
        return this.bulkMoveResourcesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkMoveResourcesRequest, BulkMoveResourcesDetails> {
        private String compartmentId;
        private BulkMoveResourcesDetails bulkMoveResourcesDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkMoveResourcesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.bulkMoveResourcesDetails(o.getBulkMoveResourcesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkMoveResourcesRequest build() {
            BulkMoveResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkMoveResourcesDetails body) {
            this.bulkMoveResourcesDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder bulkMoveResourcesDetails(BulkMoveResourcesDetails bulkMoveResourcesDetails) {
            this.bulkMoveResourcesDetails = bulkMoveResourcesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public BulkMoveResourcesRequest buildWithoutInvocationCallback() {
            return new BulkMoveResourcesRequest(this.compartmentId, this.bulkMoveResourcesDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "BulkMoveResourcesRequest.Builder(compartmentId=" + this.compartmentId + ", bulkMoveResourcesDetails=" + this.bulkMoveResourcesDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

