/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class FunctionCompletionItem
implements CompletionItem {
    private final String text;
    private final String sortPrefix;
    private final int correction;
    private final int carretOffset;
    private static final Color fieldColor = Color.BLACK;

    public FunctionCompletionItem(String sortPrefix, String text, int carretOffset) {
        this(sortPrefix, text, carretOffset, 0);
    }

    public FunctionCompletionItem(String sortPrefix, String text, int carretOffset, int correction) {
        this.text = text;
        this.sortPrefix = sortPrefix;
        this.correction = correction >= 0 ? correction : 0;
        this.carretOffset = carretOffset;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent component) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        try {
            doc.insertString(this.carretOffset, this.text.substring(this.correction) + "()", null);
            component.setCaretPosition(component.getCaretPosition() - 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Completion.get().hideAll();
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.text, null, (Graphics)g, (Font)defaultFont);
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.sortPrefix + "_" + this.text;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(null, (String)this.text, null, (Graphics)g, (Font)defaultFont, (Color)(selected ? Color.white : fieldColor), (int)width, (int)height, (boolean)selected);
    }
}

