/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.io.IOException;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.profiler.spi.ProfilerStorageProvider;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class ProfilerStorageProviderImpl
extends ProfilerStorageProvider.Abstract {
    private static final String PROFILER_FOLDER = "NBProfiler/Config";
    private static final String SETTINGS_FOLDER = "Settings";
    private static final String SETTINGS_FOR_ATTR = "settingsFor";

    public FileObject getGlobalFolder(boolean create) throws IOException {
        FileObject folder = FileUtil.getConfigFile((String)PROFILER_FOLDER);
        FileObject settingsFolder = folder.getFileObject(SETTINGS_FOLDER, null);
        if (settingsFolder == null && create) {
            settingsFolder = folder.createFolder(SETTINGS_FOLDER);
        }
        return settingsFolder;
    }

    public FileObject getProjectFolder(Lookup.Provider project, boolean create) throws IOException {
        Project p = (Project)project;
        FileObject nbproject = p.getProjectDirectory().getFileObject("nbproject");
        FileObject d = nbproject != null ? (create ? FileUtil.createFolder((FileObject)nbproject, (String)"private/profiler") : nbproject.getFileObject("private/profiler")) : ProjectUtils.getCacheDirectory((Project)p, IDEUtils.class);
        if (d != null) {
            d.setAttribute(SETTINGS_FOR_ATTR, (Object)p.getProjectDirectory().toURL());
        }
        return d;
    }

    public Lookup.Provider getProjectFromFolder(FileObject settingsFolder) {
        FileObject d;
        Object o = settingsFolder.getAttribute(SETTINGS_FOR_ATTR);
        if (o instanceof URL && (d = URLMapper.findFileObject((URL)((URL)o))) != null && d.isFolder()) {
            try {
                return ProjectManager.getDefault().findProject(d);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Project p = FileOwnerQuery.getOwner((FileObject)settingsFolder);
        try {
            if (p != null && this.getProjectFolder((Lookup.Provider)p, false) == settingsFolder) {
                return p;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

