/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;

public class RelationshipHelper {
    private static final String MULTIPLICITY_MANY = "Many";
    private static final String MULTIPLICITY_ONE = "One";
    private final EjbRelation relation;
    public final RelationshipRoleHelper roleA;
    public final RelationshipRoleHelper roleB;

    public RelationshipHelper(EjbRelation relation) {
        this.relation = relation;
        this.roleA = new RelationshipRoleHelper(relation.getEjbRelationshipRole());
        this.roleB = new RelationshipRoleHelper(relation.getEjbRelationshipRole2());
    }

    public RelationshipHelper(Relationships singleRelationships) {
        this.relation = singleRelationships.newEjbRelation();
        EjbRelationshipRole roleA = this.newRole();
        this.relation.setEjbRelationshipRole(roleA);
        EjbRelationshipRole roleB = this.newRole();
        this.relation.setEjbRelationshipRole2(roleB);
        singleRelationships.addEjbRelation(this.relation);
        this.roleA = new RelationshipRoleHelper(roleA);
        this.roleB = new RelationshipRoleHelper(roleB);
    }

    private EjbRelationshipRole newRole() {
        EjbRelationshipRole role = this.relation.newEjbRelationshipRole();
        role.setRelationshipRoleSource(role.newRelationshipRoleSource());
        return role;
    }

    public String getRelationName() {
        return this.relation.getEjbRelationName();
    }

    public void setRelationName(String relationName) {
        this.relation.setEjbRelationName(relationName);
    }

    public String getDescription() {
        return this.relation.getDefaultDescription();
    }

    public void setDescription(String description) {
        this.relation.setDescription(description);
    }

    public static class RelationshipRoleHelper {
        private final EjbRelationshipRole role;

        public RelationshipRoleHelper(EjbRelationshipRole role) {
            this.role = role;
        }

        public boolean isMultiple() {
            return RelationshipHelper.MULTIPLICITY_MANY.equals(this.role.getMultiplicity());
        }

        public void setMultiple(boolean multiple) {
            this.role.setMultiplicity(multiple ? RelationshipHelper.MULTIPLICITY_MANY : RelationshipHelper.MULTIPLICITY_ONE);
        }

        public String getEjbName() {
            return this.role.getRelationshipRoleSource().getEjbName();
        }

        public void setEjbName(String ejbName) {
            this.role.getRelationshipRoleSource().setEjbName(ejbName);
        }

        public String getRoleName() {
            return this.role.getEjbRelationshipRoleName();
        }

        public void setRoleName(String roleName) {
            this.role.setEjbRelationshipRoleName(roleName);
        }

        public String getFieldName() {
            CmrField field = this.role.getCmrField();
            return field == null ? null : field.getCmrFieldName();
        }

        public String getFieldType() {
            CmrField field = this.role.getCmrField();
            return field == null ? null : field.getCmrFieldType();
        }

        public boolean isCascadeDelete() {
            return this.role.isCascadeDelete();
        }

        public void setCascadeDelete(boolean cascadeDelete) {
            this.role.setCascadeDelete(cascadeDelete);
        }

        public CmrField getCmrField() {
            return this.role.getCmrField();
        }

        public void setCmrField(CmrField cmrField) {
            this.role.setCmrField(cmrField);
        }

        public void setCmrField(String fieldName, String fieldType) {
            CmrField field = this.role.getCmrField();
            if (field == null) {
                field = this.role.newCmrField();
                this.role.setCmrField(field);
            }
            field.setCmrFieldName(fieldName);
            field.setCmrFieldType(fieldType);
        }
    }
}

