/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.AnchorShapeFactory;
import org.netbeans.api.visual.anchor.AnchorShapeLocationResolver;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class DefaultAnchorShapeResolver
implements AnchorShapeLocationResolver {
    private ConnectionWidget connection = null;
    private AnchorShapeFactory.ConnectionEnd attachedEnd = AnchorShapeFactory.ConnectionEnd.SOURCE;
    private Widget attachedWidget = null;

    public DefaultAnchorShapeResolver(ConnectionWidget connection, AnchorShapeFactory.ConnectionEnd attachedTo) {
        this(connection, attachedTo, null);
    }

    public DefaultAnchorShapeResolver(ConnectionWidget connection, AnchorShapeFactory.ConnectionEnd attachedTo, Widget attachedWidget) {
        this.connection = connection;
        this.attachedEnd = attachedTo;
        this.attachedWidget = attachedWidget;
    }

    @Override
    public int getEndLocation() {
        int retVal = 0;
        if (this.attachedWidget != null) {
            Rectangle bounds = this.attachedWidget.getBounds();
            retVal = this.getLocation(bounds);
        } else {
            Rectangle bounds = new Rectangle();
            if (this.attachedEnd == AnchorShapeFactory.ConnectionEnd.SOURCE) {
                Widget sourceWidget = this.getConnection().getSourceAnchor().getRelatedWidget();
                bounds = sourceWidget.getBounds();
            } else {
                Widget sourceWidget = this.getConnection().getTargetAnchor().getRelatedWidget();
                bounds = sourceWidget.getBounds();
            }
            retVal = this.getLocation(bounds);
        }
        return retVal;
    }

    public Widget getAttachedWidget() {
        return this.attachedWidget;
    }

    public void setAttachedWidget(Widget attachedWidget) {
        this.attachedWidget = attachedWidget;
    }

    public ConnectionWidget getConnection() {
        return this.connection;
    }

    public AnchorShapeFactory.ConnectionEnd getAttachedEnd() {
        return this.attachedEnd;
    }

    protected int getLocation(Rectangle bounds) {
        int retVal = 0;
        Point endPt = null;
        Rectangle widgetBounds = null;
        if (this.attachedEnd == AnchorShapeFactory.ConnectionEnd.SOURCE) {
            endPt = this.connection.getFirstControlPoint();
            widgetBounds = this.getSourceBounds();
        } else {
            endPt = this.connection.getLastControlPoint();
            widgetBounds = this.getTargetBounds();
        }
        if (widgetBounds != null) {
            if (endPt.x == widgetBounds.x && endPt.y == widgetBounds.y) {
                System.out.println("Top Left Corner");
                retVal = bounds.width;
            } else if (endPt.x == widgetBounds.x && endPt.y == widgetBounds.y + widgetBounds.height) {
                System.out.println("Bottom Left Corner");
                retVal = bounds.width;
            }
            if (endPt.x == widgetBounds.x + widgetBounds.width && endPt.y == widgetBounds.y) {
                System.out.println("Top Right Corner");
                retVal = bounds.width;
            } else if (endPt.x == widgetBounds.x + widgetBounds.width && endPt.y == widgetBounds.y + widgetBounds.height) {
                System.out.println("Bottom Right Corner");
                retVal = bounds.width;
            } else if (endPt.x <= widgetBounds.x) {
                retVal = bounds.width;
            } else if (endPt.x >= widgetBounds.x + widgetBounds.width) {
                retVal = bounds.width;
            } else if (endPt.y <= widgetBounds.y) {
                retVal = bounds.height;
            } else if (endPt.y >= widgetBounds.y + widgetBounds.height) {
                retVal = bounds.height;
            }
        }
        return retVal;
    }

    private Rectangle getSourceBounds() {
        Widget source = this.connection.getSourceAnchor().getRelatedWidget();
        if (source != null) {
            Point sourceLocation = source.getLocation();
            Rectangle clientArea = source.getClientArea();
            return new Rectangle(sourceLocation, clientArea.getSize());
        }
        return null;
    }

    private Rectangle getTargetBounds() {
        Widget target = this.connection.getTargetAnchor().getRelatedWidget();
        if (target != null) {
            Point targetLocation = target.getLocation();
            Rectangle targetArea = target.getClientArea();
            return new Rectangle(targetLocation, targetArea.getSize());
        }
        return null;
    }
}

