/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.RepositoryRef;
import com.oracle.bmc.devops.requests.GetRefRequest;
import com.oracle.bmc.devops.responses.GetRefResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRefConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRefConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRefRequest interceptRequest(GetRefRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRefRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("refs").path(HttpUtils.encodePathSegment((String)request.getRefName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetRefResponse> fromResponse() {
        Function<Response, GetRefResponse> transformer = new Function<Response, GetRefResponse>(){

            public GetRefResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.GetRefResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RepositoryRef.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRefResponse.Builder builder = GetRefResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.repositoryRef((RepositoryRef)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetRefResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

