/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.GetResourcePrincipalSessionTokenRequest;
import com.oracle.bmc.auth.internal.SecurityTokenAdapter;
import com.oracle.bmc.auth.internal.X509FederationClient;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationClient
implements FederationClient,
ProvidesConfigurableRefresh {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFederationClient.class);
    protected static final Function<Response, WithHeaders<X509FederationClient.SecurityToken>> SECURITY_TOKEN_FN = new ResponseConversionFunctionFactory().create(X509FederationClient.SecurityToken.class);
    protected final SessionKeySupplier sessionKeySupplier;
    protected final String resourcePrincipalTokenEndpoint;
    protected final String federationEndpoint;
    private ClientConfiguration clientConfiguration = null;
    private volatile SecurityTokenAdapter securityTokenAdapter = null;
    protected final RestClient restClient;

    public AbstractFederationClient(String resourcePrincipalTokenEndpoint, String federationEndpoint, SessionKeySupplier sessionKeySupplier, BasicAuthenticationDetailsProvider basicAuthenticationDetailsProvider, ClientConfigurator clientConfigurator, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        this.resourcePrincipalTokenEndpoint = (String)Preconditions.checkNotNull((Object)resourcePrincipalTokenEndpoint);
        this.federationEndpoint = (String)Preconditions.checkNotNull((Object)federationEndpoint);
        this.sessionKeySupplier = (SessionKeySupplier)Preconditions.checkNotNull((Object)sessionKeySupplier);
        RequestSigner requestSigner = DefaultRequestSigner.createRequestSigner(basicAuthenticationDetailsProvider);
        if (circuitBreakerConfiguration != null) {
            this.clientConfiguration = ClientConfiguration.builder().circuitBreakerConfiguration(circuitBreakerConfiguration).build();
        }
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).build();
        this.restClient = restClientFactory.create(requestSigner, Collections.emptyMap(), this.clientConfiguration);
        this.securityTokenAdapter = new SecurityTokenAdapter(null, sessionKeySupplier);
    }

    @Override
    public String getSecurityToken() {
        if (this.securityTokenAdapter.isValid()) {
            return this.securityTokenAdapter.getSecurityToken();
        }
        return this.refreshAndGetSecurityTokenInner(true, Optional.empty());
    }

    @Override
    public String refreshAndGetSecurityToken() {
        return this.refreshAndGetSecurityTokenInner(false, Optional.empty());
    }

    @Override
    public String refreshAndGetSecurityTokenIfExpiringWithin(Duration time) {
        return this.refreshAndGetSecurityTokenInner(false, Optional.of(time));
    }

    protected Response makeCall(Invocation.Builder ib, URI requestUri, GetResourcePrincipalSessionTokenRequest request) {
        WrappedInvocationBuilder wrappedIb = new WrappedInvocationBuilder(ib, requestUri);
        return this.makeCallInner(wrappedIb, request);
    }

    protected Response makeCall(Invocation.Builder ib, URI requestUri) {
        WrappedInvocationBuilder wrappedIb = new WrappedInvocationBuilder(ib, requestUri);
        return this.makeCallInner(wrappedIb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshAndGetSecurityTokenInner(boolean doFinalTokenValidityCheck, Optional<Duration> time) {
        AbstractFederationClient abstractFederationClient = this;
        synchronized (abstractFederationClient) {
            if (!doFinalTokenValidityCheck || (time.isPresent() ? !this.securityTokenAdapter.isValid(time) : !this.securityTokenAdapter.isValid())) {
                LOG.info("Refreshing session keys.");
                this.sessionKeySupplier.refreshKeys();
                this.securityTokenAdapter = this.getSecurityTokenFromServer();
                return this.securityTokenAdapter.getSecurityToken();
            }
            return this.securityTokenAdapter.getSecurityToken();
        }
    }

    protected abstract SecurityTokenAdapter getSecurityTokenFromServer();

    protected Response makeCallInner(WrappedInvocationBuilder wrappedIb, Object request) {
        int MAX_RETRIES = 5;
        BmcException lastException = null;
        for (int retry = 0; retry < 5; ++retry) {
            try {
                if (request != null) {
                    return this.restClient.post(wrappedIb, request, new BmcRequest());
                }
                return this.restClient.get(wrappedIb, new BmcRequest());
            }
            catch (BmcException ex) {
                lastException = ex;
                try {
                    Thread.sleep(250L);
                    continue;
                }
                catch (InterruptedException iex) {
                    LOG.debug("Thread interrupted while waiting to make next call to federation service", (Throwable)iex);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw lastException;
    }

    @Override
    public String getStringClaim(String key) {
        return null;
    }
}

