/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;

public class Constants {
    static final String AUTHORIZATION_HEADER = "authorization";
    static final String REQUEST_TARGET = "(request-target)";
    static final String DATE = "date";
    static final String CONTENT_LENGTH = "content-length";
    static final String CONTENT_TYPE = "content-type";
    static final String X_CONTENT_SHA256 = "x-content-sha256";
    public static final String HOST = "host";
    public static final String CROSS_TENANCY_REQUEST_HEADER_NAME = "x-cross-tenancy-request";
    static final String X_SUBSCRIPTION = "x-subscription";
    public static final String OPC_OBO_TOKEN = "opc-obo-token";
    static final String JSON_CONTENT_TYPE = "application/json";
    public static final ImmutableList<String> GENERIC_HEADERS = ImmutableList.of((Object)"date", (Object)"(request-target)", (Object)"host");
    public static final ImmutableList<String> BODY_HEADERS = ImmutableList.of((Object)"content-length", (Object)"content-type", (Object)"x-content-sha256");
    public static final ImmutableList<String> ALL_HEADERS = ImmutableList.builder().addAll(GENERIC_HEADERS).addAll(BODY_HEADERS).build();
    public static final ImmutableMap<String, List<String>> REQUIRED_SIGNING_HEADERS = Constants.createHeadersToSignMap(GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, ALL_HEADERS, ALL_HEADERS, ALL_HEADERS);
    @Deprecated
    public static final ImmutableMap<String, List<String>> REQUIRED_OBJECTSTORAGE_SIGNING_HEADERS = Constants.createHeadersToSignMap(GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, ALL_HEADERS, ALL_HEADERS);
    public static final ImmutableMap<String, List<String>> REQUIRED_EXCLUDE_BODY_SIGNING_HEADERS = Constants.createHeadersToSignMap(GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS, GENERIC_HEADERS);
    public static final ImmutableList<String> OPTIONAL_HEADERS_NAMES = ImmutableList.of((Object)"opc-obo-token", (Object)"x-cross-tenancy-request", (Object)"x-subscription");
    public static final ImmutableMap<String, List<String>> OPTIONAL_SIGNING_HEADERS = Constants.createHeadersToSignMap(OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES, OPTIONAL_HEADERS_NAMES);
    static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    public static ImmutableMap<String, List<String>> createHeadersToSignMap(List<String> getHeaders, List<String> headHeaders, List<String> deleteHeaders, List<String> putHeaders, List<String> postHeaders, List<String> patchHeaders) {
        return ImmutableMap.builder().put((Object)"get", getHeaders).put((Object)"head", headHeaders).put((Object)"delete", deleteHeaders).put((Object)"put", putHeaders).put((Object)"post", postHeaders).put((Object)"patch", patchHeaders).build();
    }
}

