/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.openide.util.Parameters;

public final class ClassElementImpl
extends TypeElementImpl
implements ClassElement {
    public static final String IDX_FIELD = "clz";
    private final QualifiedName superClass;
    private final Collection<QualifiedName> possibleFQSuperClassNames;
    private final Collection<QualifiedName> fqMixinClassNames;
    private final Collection<QualifiedName> usedTraits;

    private ClassElementImpl(QualifiedName qualifiedName, int offset, QualifiedName superClsName, Collection<QualifiedName> possibleFQSuperClassNames, Set<QualifiedName> ifaceNames, Collection<QualifiedName> fqSuperInterfaces, int flags, Collection<QualifiedName> usedTraits, String fileUrl, ElementQuery elementQuery, boolean isDeprecated, Collection<QualifiedName> fqMixinClassNames) {
        super(qualifiedName, offset, ifaceNames, fqSuperInterfaces, flags, fileUrl, elementQuery, isDeprecated);
        this.superClass = superClsName;
        this.possibleFQSuperClassNames = possibleFQSuperClassNames;
        this.usedTraits = usedTraits;
        this.fqMixinClassNames = fqMixinClassNames;
    }

    public static Set<ClassElement> fromSignature(IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return ClassElementImpl.fromSignature((NameKind)NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<ClassElement> fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<ClassElement> retval = values.length > 0 ? new HashSet<ClassElement>() : Collections.emptySet();
        for (String val : values) {
            ClassElement clz = ClassElementImpl.fromSignature(query, indexScopeQuery, Signature.get(val));
            if (clz == null) continue;
            retval.add(clz);
        }
        return retval;
    }

    private static ClassElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, Signature clsSignature) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        ClassSignatureParser signParser = new ClassSignatureParser(clsSignature);
        ClassElementImpl retval = null;
        if (ClassElementImpl.matchesQuery(query, signParser)) {
            retval = new ClassElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getSuperClassName(), signParser.getPossibleFQSuperClassName(), signParser.getSuperInterfaces(), signParser.getFQSuperInterfaces(), signParser.getFlags(), signParser.getUsedTraits(), signParser.getFileUrl(), indexScopeQuery, signParser.isDeprecated(), signParser.getFQMixinClassNames());
        }
        return retval;
    }

    public static ClassElement fromNode(NamespaceElement namespace, ClassDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        ClassDeclarationInfo info = ClassDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new ClassElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), info.getSuperClassName(), Collections.emptySet(), info.getInterfaceNames(), Collections.emptySet(), info.getAccessModifiers().toFlags(), info.getUsedTraits(), fileQuery.getURL().toExternalForm(), fileQuery, VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node), Collections.emptySet());
    }

    public static ClassElement fromFrameworks(PhpClass clz, ElementQuery elementQuery) {
        Parameters.notNull((CharSequence)IDX_FIELD, (Object)clz);
        Parameters.notNull((CharSequence)"elementQuery", (Object)elementQuery);
        String fullyQualifiedName = clz.getFullyQualifiedName();
        ClassElementImpl retval = new ClassElementImpl(QualifiedName.create(fullyQualifiedName == null ? clz.getName() : fullyQualifiedName), clz.getOffset(), null, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), 0, Collections.emptySet(), null, elementQuery, false, Collections.emptySet());
        retval.setFileObject(clz.getFile());
        return retval;
    }

    private static boolean matchesQuery(NameKind query, ClassSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(ClassElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return KIND;
    }

    @Override
    public QualifiedName getSuperClassName() {
        return this.superClass;
    }

    @Override
    public Collection<QualifiedName> getPossibleFQSuperClassNames() {
        return this.possibleFQSuperClassNames;
    }

    @Override
    public Collection<QualifiedName> getFQMixinClassNames() {
        return Collections.unmodifiableCollection(this.fqMixinClassNames);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(superClassName.toString());
            sb.append("|");
            boolean first = true;
            for (QualifiedName qualifiedName : this.possibleFQSuperClassNames) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = true;
                }
                sb.append(qualifiedName.toString());
            }
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        QualifiedName namespaceName = this.getNamespaceName();
        sb.append(namespaceName.toString()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        StringBuilder ifaceSb = new StringBuilder();
        for (QualifiedName ifaceName : this.getSuperInterfaces()) {
            if (ifaceSb.length() > 0) {
                ifaceSb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            ifaceSb.append(ifaceName.toString());
        }
        sb.append((CharSequence)ifaceSb);
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        if (!this.usedTraits.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (QualifiedName usedTrait : this.usedTraits) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(usedTrait.toString());
            }
            sb.append((CharSequence)stringBuilder);
        }
        sb.append(";");
        sb.append(this.isDeprecated() ? 1 : 0).append(";");
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        StringBuilder stringBuilder = new StringBuilder();
        this.fqMixinClassNames.forEach(mixinClassName -> {
            if (mixinSb.length() > 0) {
                mixinSb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            mixinSb.append(mixinClassName.toString());
        });
        sb.append(stringBuilder.toString());
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        this.checkClassSignature(sb);
        return sb.toString();
    }

    @Override
    public String asString(TypeElement.PrintAs as) {
        StringBuilder retval = new StringBuilder();
        switch (as) {
            case NameAndSuperTypes: {
                retval.append(this.getName());
                this.printAsSuperTypes(retval);
                break;
            }
            case SuperTypes: {
                this.printAsSuperTypes(retval);
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return retval.toString();
    }

    private void printAsSuperTypes(StringBuilder sb) {
        Set<QualifiedName> superIfaces;
        QualifiedName superClassName = this.getSuperClassName();
        if (superClassName != null) {
            sb.append(" extends  ");
            sb.append(superClassName.getName());
        }
        if (!(superIfaces = this.getSuperInterfaces()).isEmpty()) {
            sb.append(" implements ");
        }
        StringBuilder ifacesBuffer = new StringBuilder();
        for (QualifiedName qualifiedName : superIfaces) {
            if (ifacesBuffer.length() > 0) {
                ifacesBuffer.append(", ");
            }
            ifacesBuffer.append(qualifiedName.getName());
        }
        sb.append((CharSequence)ifacesBuffer);
    }

    private void checkClassSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            ClassSignatureParser parser = new ClassSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getPhpModifiers().toFlags() == parser.getFlags());
            QualifiedName superClassName = this.getSuperClassName();
            if (superClassName != null) assert (superClassName.equals(parser.getSuperClassName()));
            assert (this.getSuperInterfaces().size() == parser.getSuperInterfaces().size());
        }
    }

    @Override
    public boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    @Override
    public boolean isReadonly() {
        return this.getPhpModifiers().isReadonly();
    }

    @Override
    public boolean isAnonymous() {
        return CodeUtils.isSyntheticTypeName(this.getName());
    }

    @Override
    public Collection<QualifiedName> getUsedTraits() {
        return this.usedTraits;
    }

    private static class ClassSignatureParser {
        private final Signature signature;

        ClassSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(4), this.signature.string(1));
        }

        @CheckForNull
        QualifiedName getSuperClassName() {
            int index;
            String name = this.signature.string(3);
            if (name != null && (index = name.indexOf(124)) > 0) {
                name = name.substring(0, index);
            }
            return name.trim().length() == 0 ? null : QualifiedName.create(name);
        }

        Collection<QualifiedName> getPossibleFQSuperClassName() {
            int index;
            String field = this.signature.string(3);
            List<QualifiedName> retval = Collections.emptyList();
            if (field != null && (index = field.indexOf(124)) > 0) {
                field = field.substring(index + 1);
                retval = new ArrayList<QualifiedName>();
                StringTokenizer st = new StringTokenizer(field, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    retval.add(QualifiedName.create(token));
                }
            }
            return retval;
        }

        public Set<QualifiedName> getSuperInterfaces() {
            int index;
            Set<QualifiedName> ifaces = Collections.emptySet();
            String separatedIfaces = this.signature.string(5);
            if (separatedIfaces != null && separatedIfaces.length() > 0 && (index = separatedIfaces.indexOf(124)) > 0) {
                String[] ifaceNames;
                String field = separatedIfaces.substring(0, index);
                ifaces = new HashSet<QualifiedName>();
                for (String ifName : ifaceNames = field.split(PhpElementImpl.Separator.COMMA.toString())) {
                    ifaces.add(QualifiedName.create(ifName));
                }
            }
            return ifaces;
        }

        public Collection<QualifiedName> getFQSuperInterfaces() {
            int index;
            Collection<QualifiedName> retval = Collections.emptySet();
            String separatedIfaces = this.signature.string(5);
            if (separatedIfaces != null && (index = separatedIfaces.indexOf(124)) > 0) {
                String field = separatedIfaces.substring(index + 1);
                retval = new ArrayList();
                StringTokenizer st = new StringTokenizer(field, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    retval.add(QualifiedName.create(token));
                }
            }
            return retval;
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        int getFlags() {
            return this.signature.integer(6);
        }

        public Collection<QualifiedName> getUsedTraits() {
            String[] traitNames;
            HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
            String traits = this.signature.string(7);
            for (String trait : traitNames = traits.split(PhpElementImpl.Separator.COMMA.toString())) {
                retval.add(QualifiedName.create(trait));
            }
            return retval;
        }

        boolean isDeprecated() {
            return this.signature.integer(8) == 1;
        }

        String getFileUrl() {
            return this.signature.string(9);
        }

        public Collection<QualifiedName> getFQMixinClassNames() {
            String[] mixinNames;
            HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
            String mixins = this.signature.string(10);
            for (String mixinName : mixinNames = mixins.split(PhpElementImpl.Separator.COMMA.toString())) {
                retval.add(QualifiedName.create(mixinName));
            }
            return retval;
        }
    }
}

