/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.structure.formatting.JoinedTokenSequence;
import org.netbeans.modules.editor.structure.formatting.TextBounds;
import org.netbeans.modules.editor.structure.formatting.TransferData;

public abstract class TagBasedLexerFormatter {
    private static final Logger logger = Logger.getLogger(TagBasedLexerFormatter.class.getName());

    protected abstract boolean isClosingTag(JoinedTokenSequence var1, int var2);

    protected abstract boolean isUnformattableToken(JoinedTokenSequence var1, int var2);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(JoinedTokenSequence var1, int var2);

    protected abstract String extractTagName(JoinedTokenSequence var1, int var2);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(JoinedTokenSequence var1, int var2);

    protected abstract int getTagEndingAtPosition(JoinedTokenSequence var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(JoinedTokenSequence var1, int var2);

    protected abstract LanguagePath supportedLanguagePath();

    public void process(Context context) throws BadLocationException {
        if (context.isIndent()) {
            int lastLine;
            BaseDocument doc = (BaseDocument)context.document();
            int firstLine = Utilities.getLineOffset((BaseDocument)doc, (int)context.startOffset());
            if (firstLine == (lastLine = Utilities.getLineOffset((BaseDocument)doc, (int)context.endOffset()))) {
                this.enterPressed(context);
            } else {
                this.reformat(context);
            }
        } else {
            this.reformat(context);
        }
    }

    public void reformat(Context context) throws BadLocationException {
        this.reformat(context, context.startOffset(), context.endOffset());
    }

    public void reformat(Context context, int startOffset, int endOffset) throws BadLocationException {
        BaseDocument doc = (BaseDocument)context.document();
        doc.runAtomic((Runnable)new FormattingTask(context, startOffset, endOffset));
    }

    public boolean isJustAfterClosingTag(BaseDocument doc, int pos) {
        IsJustAfterClosingTagTask task = new IsJustAfterClosingTagTask(doc, pos);
        doc.runAtomic((Runnable)task);
        return task.getResult();
    }

    private static int getTxtLengthWithoutWhitespaceSuffix(CharSequence txt) {
        for (int i = txt.length(); i > 0; --i) {
            if (Character.isWhitespace(txt.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }

    protected int getMatchingOpeningTagStart(JoinedTokenSequence tokenSequence, int closingTagOffset) {
        int originalOffset = tokenSequence.offset();
        tokenSequence.move(closingTagOffset);
        tokenSequence.moveNext();
        String searchedTagName = this.extractTagName(tokenSequence, closingTagOffset);
        int balance = 0;
        while (tokenSequence.movePrevious()) {
            int currentTokenOffset = tokenSequence.offset();
            if (!this.areTagNamesEqual(searchedTagName, this.extractTagName(tokenSequence, currentTokenOffset))) continue;
            if (this.isOpeningTag(tokenSequence, currentTokenOffset)) {
                if (balance == 0) {
                    tokenSequence.move(originalOffset);
                    tokenSequence.moveNext();
                    return currentTokenOffset;
                }
                --balance;
                continue;
            }
            if (!this.isClosingTag(tokenSequence, currentTokenOffset)) continue;
            ++balance;
        }
        tokenSequence.move(originalOffset);
        tokenSequence.moveNext();
        return -1;
    }

    protected boolean isWSToken(Token token) {
        return this.isOnlyWhiteSpaces(token.text());
    }

    protected int getIndentForTagParameter(BaseDocument doc, JoinedTokenSequence tokenSequence, int tagOffset) throws BadLocationException {
        int originalOffset = tokenSequence.offset();
        int tagStartLine = Utilities.getLineOffset((BaseDocument)doc, (int)tagOffset);
        tokenSequence.move(tagOffset);
        boolean thereWasWS = false;
        int shift = doc.getShiftWidth();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            int tokenOffset = tokenSequence.offset();
            boolean isWSToken = this.isWSToken(token);
            if (thereWasWS && (!isWSToken || tagStartLine != Utilities.getLineOffset((BaseDocument)doc, (int)tokenOffset))) {
                if (isWSToken || tagStartLine != Utilities.getLineOffset((BaseDocument)doc, (int)tokenOffset)) break;
                shift = tokenOffset - Utilities.getRowIndent((BaseDocument)doc, (int)tokenOffset) - Utilities.getRowStart((BaseDocument)doc, (int)tokenOffset);
                break;
            }
            if (!isWSToken) continue;
            thereWasWS = true;
        }
        tokenSequence.move(originalOffset);
        tokenSequence.moveNext();
        return shift;
    }

    private boolean calcIndents_processOpeningTag(BaseDocument doc, JoinedTokenSequence tokenSequence, String tagName, Collection<TagIndentationData> unprocessedOpeningTags, int[] indentsWithinTags) throws BadLocationException {
        boolean thereAreMoreTokens = true;
        int firstTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
        int tagEndOffset = this.getTagEndOffset(tokenSequence, tokenSequence.offset());
        if (tagEndOffset == -1) {
            return true;
        }
        int lastTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tagEndOffset);
        TagIndentationData tagData = new TagIndentationData(tagName, lastTagLine);
        unprocessedOpeningTags.add(tagData);
        if (firstTagLine < lastTagLine) {
            int indentWithinTag = this.getIndentForTagParameter(doc, tokenSequence, tokenSequence.offset());
            for (int i = firstTagLine + 1; i <= lastTagLine; ++i) {
                indentsWithinTags[i] = indentWithinTag;
            }
        }
        return thereAreMoreTokens;
    }

    private void calcIndents_processClosingTag(String tagName, int tagClosedOnLine, TransferData transferData, LinkedList<TagIndentationData> unprocessedOpeningTags, Collection<TagIndentationData> matchedOpeningTags) throws BadLocationException {
        LinkedList<TagIndentationData> tagsToBeRemoved = new LinkedList<TagIndentationData>();
        while (!unprocessedOpeningTags.isEmpty()) {
            TagIndentationData processedTD = unprocessedOpeningTags.removeLast();
            if (this.areTagNamesEqual(tagName, processedTD.getTagName())) {
                processedTD.setClosedOnLine(tagClosedOnLine);
                matchedOpeningTags.add(processedTD);
                if (this.isUnformattableTag(tagName)) {
                    for (int i = tagClosedOnLine - 1; i > processedTD.getLine(); --i) {
                        transferData.setNonFormattable(i);
                    }
                }
                tagsToBeRemoved.clear();
                break;
            }
            tagsToBeRemoved.add(processedTD);
        }
        unprocessedOpeningTags.addAll(tagsToBeRemoved);
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument doc, int line) throws BadLocationException {
        int lineStart;
        int previousNonWhiteLineEnd;
        int initialIndent = 0;
        if (line > 0 && (previousNonWhiteLineEnd = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)(lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line)))) > 0) {
            initialIndent = Utilities.getRowIndent((BaseDocument)doc, (int)previousNonWhiteLineEnd);
        }
        return initialIndent;
    }

    protected static int getNumberOfLines(BaseDocument doc) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)doc, (int)doc.getLength()) + 1;
    }

    protected int getNextClosingTagOffset(JoinedTokenSequence tokenSequence, int offset) throws BadLocationException {
        int originalOffset = tokenSequence.offset();
        tokenSequence.move(offset);
        int currentOffset = -1;
        while (tokenSequence.moveNext()) {
            currentOffset = tokenSequence.offset();
            if (!this.isClosingTag(tokenSequence, currentOffset)) continue;
            tokenSequence.move(originalOffset);
            tokenSequence.moveNext();
            return currentOffset;
        }
        tokenSequence.move(originalOffset);
        tokenSequence.moveNext();
        return -1;
    }

    protected boolean isJustBeforeClosingTag(JoinedTokenSequence tokenSequence, int pos) throws BadLocationException {
        return this.isClosingTag(tokenSequence, pos);
    }

    protected Token getTokenAtOffset(JoinedTokenSequence tokenSequence, int tagTokenOffset) {
        if (tokenSequence != null && tagTokenOffset >= 0) {
            int originalOffset = tokenSequence.offset();
            tokenSequence.move(tagTokenOffset);
            if (tokenSequence.moveNext()) {
                Token r = tokenSequence.token();
                tokenSequence.move(originalOffset);
                tokenSequence.moveNext();
                return r;
            }
        }
        return null;
    }

    private TextBounds findTokenSequenceBounds(BaseDocument doc, TokenSequence tokenSequence) throws BadLocationException {
        tokenSequence.moveStart();
        tokenSequence.moveNext();
        int absoluteStart = tokenSequence.offset();
        tokenSequence.moveEnd();
        tokenSequence.movePrevious();
        int absoluteEnd = tokenSequence.offset() + tokenSequence.token().length();
        while (this.isWSToken(tokenSequence.token())) {
            if (tokenSequence.movePrevious()) continue;
            return new TextBounds(absoluteStart, absoluteEnd);
        }
        int whiteSpaceSuffixLen = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(tokenSequence.token().length() - 1 - whiteSpaceSuffixLen))) {
            ++whiteSpaceSuffixLen;
        }
        int languageBlockEnd = tokenSequence.offset() + tokenSequence.token().length() - whiteSpaceSuffixLen;
        tokenSequence.moveStart();
        do {
            tokenSequence.moveNext();
        } while (this.isWSToken(tokenSequence.token()));
        int whiteSpacePrefixLen = 0;
        while (Character.isWhitespace(tokenSequence.token().text().charAt(whiteSpacePrefixLen))) {
            ++whiteSpacePrefixLen;
        }
        int languageBlockStart = tokenSequence.offset() + whiteSpacePrefixLen;
        int firstLineOfTheLanguageBlock = Utilities.getLineOffset((BaseDocument)doc, (int)languageBlockStart);
        int lastLineOfTheLanguageBlock = Utilities.getLineOffset((BaseDocument)doc, (int)languageBlockEnd);
        return new TextBounds(absoluteStart, absoluteEnd, languageBlockStart, languageBlockEnd, firstLineOfTheLanguageBlock, lastLineOfTheLanguageBlock);
    }

    private void markCurrentLanguageLines(BaseDocument doc, TextBounds languageBounds, EmbeddingType[] embeddingType) throws BadLocationException {
        if (languageBounds.getStartPos() == -1) {
            return;
        }
        int firstLineOfTheLanguageBlock = languageBounds.getStartLine();
        int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)firstLineOfTheLanguageBlock);
        if (Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)lineStart) < languageBounds.getStartPos()) {
            ++firstLineOfTheLanguageBlock;
        }
        for (int i = firstLineOfTheLanguageBlock; i <= languageBounds.getEndLine(); ++i) {
            embeddingType[i] = EmbeddingType.CURRENT_LANG;
        }
    }

    protected boolean isTopLevelLanguage(BaseDocument doc) {
        return this.supportedLanguagePath().size() == 1;
    }

    protected static int getExistingIndent(BaseDocument doc, int line) throws BadLocationException {
        int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
        return IndentUtils.lineIndent((Document)doc, (int)lineStart);
    }

    public void enterPressed(Context context) {
        BaseDocument doc = (BaseDocument)context.document();
        doc.runAtomic((Runnable)new EnterPressedTask(context));
    }

    private boolean indexWithinCurrentLanguage(BaseDocument doc, int index) throws BadLocationException {
        TokenSequence[] tokenSequences;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        for (TokenSequence tokenSequence : tokenSequences = tokenHierarchy.tokenSequenceList(this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0])) {
            TextBounds languageBounds = this.findTokenSequenceBounds(doc, tokenSequence);
            if (languageBounds.getAbsoluteStart() > index || languageBounds.getAbsoluteEnd() < index) continue;
            tokenSequence.move(index);
            if (!tokenSequence.moveNext()) continue;
            if (this.isWSToken(tokenSequence.token())) {
                tokenSequence.movePrevious();
            }
            return tokenSequence.embedded() == null && !this.isWSToken(tokenSequence.token());
        }
        return false;
    }

    public boolean handleSmartEnter(Context context) throws BadLocationException {
        int dotPos;
        boolean wasSmartEnter = false;
        BaseDocument doc = (BaseDocument)context.document();
        wasSmartEnter = this.isSmartEnter(doc, dotPos = context.caretOffset());
        if (wasSmartEnter) {
            int line = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos);
            assert (line > 0);
            int baseIndent = TagBasedLexerFormatter.getExistingIndent(doc, line - 1);
            doc.insertString(dotPos, "\n", null);
            Position position = doc.createPosition(dotPos);
            context.modifyIndent(Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line), baseIndent + doc.getShiftWidth());
            context.modifyIndent(Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(line + 1)), baseIndent);
            context.setCaretOffset(position.getOffset());
        }
        return wasSmartEnter;
    }

    public boolean isSmartEnter(BaseDocument doc, int dotPos) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence[] tokenSequences = tokenHierarchy.tokenSequenceList(this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
        TextBounds[] tokenSequenceBounds = new TextBounds[tokenSequences.length];
        try {
            for (int i = 0; i < tokenSequenceBounds.length; ++i) {
                tokenSequenceBounds[i] = this.findTokenSequenceBounds(doc, tokenSequences[i]);
            }
            JoinedTokenSequence tokenSequence = new JoinedTokenSequence(tokenSequences, tokenSequenceBounds);
            if (tokenSequence.move(dotPos) != Integer.MIN_VALUE) {
                tokenSequence.moveNext();
                if (this.isJustBeforeClosingTag(tokenSequence, dotPos)) {
                    int closingTagOffset = this.getNextClosingTagOffset(tokenSequence, dotPos);
                    int matchingOpeningTagOffset = this.getMatchingOpeningTagStart(tokenSequence, closingTagOffset);
                    int openingTagEnd = this.getTagEndOffset(tokenSequence, matchingOpeningTagOffset);
                    return openingTagEnd + 1 == dotPos;
                }
            }
        }
        catch (BadLocationException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return false;
    }

    protected boolean isOnlyWhiteSpaces(CharSequence txt) {
        for (int i = 0; i < txt.length(); ++i) {
            if (Character.isWhitespace(txt.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String formatterName() {
        return this.getClass().getSimpleName();
    }

    protected static class TagIndentationData {
        private final String tagName;
        private final int line;
        private int closedOnLine;

        public TagIndentationData(String tagName, int line) {
            this.tagName = tagName;
            this.line = line;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int closedOnLine) {
            this.closedOnLine = closedOnLine;
        }
    }

    private class FormattingTask
    implements Runnable {
        private Context context;
        private int startOffset;
        private int endOffset;

        public FormattingTask(Context context, int startOffset, int endOffset) {
            this.context = context;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public void run() {
            try {
                this.reformat();
            }
            catch (BadLocationException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }

        private void reformat() throws BadLocationException {
            int i;
            BaseDocument doc = (BaseDocument)this.context.document();
            LinkedList unprocessedOpeningTags = new LinkedList();
            ArrayList matchedOpeningTags = new ArrayList();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            if (tokenHierarchy == null) {
                logger.severe("Could not retrieve TokenHierarchy for document " + doc);
                return;
            }
            TransferData transferData = null;
            if (TagBasedLexerFormatter.this.isTopLevelLanguage(doc)) {
                transferData = new TransferData();
                transferData.init(doc);
            } else {
                transferData = TransferData.readFromDocument(doc);
                assert (transferData != null);
            }
            int firstRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)this.startOffset);
            int lastRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)this.endOffset);
            int firstUnformattableLine = -1;
            EmbeddingType[] embeddingType = new EmbeddingType[transferData.getNumberOfLines()];
            Arrays.fill((Object[])embeddingType, (Object)EmbeddingType.OUTER);
            int[] indentsWithinTags = new int[transferData.getNumberOfLines()];
            TokenSequence[] tokenSequences = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
            TextBounds[] tokenSequenceBounds = new TextBounds[tokenSequences.length];
            for (int i2 = 0; i2 < tokenSequenceBounds.length; ++i2) {
                tokenSequenceBounds[i2] = TagBasedLexerFormatter.this.findTokenSequenceBounds(doc, tokenSequences[i2]);
                if (tokenSequenceBounds[i2].getStartLine() <= -1) continue;
                TagBasedLexerFormatter.this.markCurrentLanguageLines(doc, tokenSequenceBounds[i2], embeddingType);
            }
            if (tokenSequences.length > 0) {
                JoinedTokenSequence tokenSequence = new JoinedTokenSequence(tokenSequences, tokenSequenceBounds);
                tokenSequence.moveStart();
                boolean thereAreMoreTokens = tokenSequence.moveNext();
                do {
                    boolean wasPreviousTokenUnformattable;
                    boolean isOpenTag = TagBasedLexerFormatter.this.isOpeningTag(tokenSequence, tokenSequence.offset());
                    boolean isCloseTag = TagBasedLexerFormatter.this.isClosingTag(tokenSequence, tokenSequence.offset());
                    if (isOpenTag || isCloseTag) {
                        String tagName = TagBasedLexerFormatter.this.extractTagName(tokenSequence, tokenSequence.offset());
                        if (isOpenTag) {
                            thereAreMoreTokens &= TagBasedLexerFormatter.this.calcIndents_processOpeningTag(doc, tokenSequence, tagName, unprocessedOpeningTags, indentsWithinTags);
                        } else {
                            int tagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
                            TagBasedLexerFormatter.this.calcIndents_processClosingTag(tagName, tagLine, transferData, unprocessedOpeningTags, matchedOpeningTags);
                        }
                    }
                    boolean bl = wasPreviousTokenUnformattable = firstUnformattableLine != -1 && TagBasedLexerFormatter.this.isWSToken(tokenSequence.token()) && !tokenSequence.isJustAfterGap() || TagBasedLexerFormatter.this.isUnformattableToken(tokenSequence, tokenSequence.offset());
                    if (wasPreviousTokenUnformattable && firstUnformattableLine == -1) {
                        firstUnformattableLine = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
                    }
                    if (!(firstUnformattableLine <= -1 || wasPreviousTokenUnformattable && thereAreMoreTokens)) {
                        int lastUnformattableLine = thereAreMoreTokens ? Utilities.getLineOffset((BaseDocument)doc, (int)(tokenSequence.offset() - 1)) : transferData.getNumberOfLines() - 1;
                        for (int i3 = firstUnformattableLine + 1; i3 < lastUnformattableLine; ++i3) {
                            transferData.setNonFormattable(i3);
                        }
                        firstUnformattableLine = -1;
                    }
                    if (tokenSequence.embedded() == null || TagBasedLexerFormatter.this.isWSToken(tokenSequence.token())) continue;
                    int firstLineOfEmbeddedBlock = Utilities.getLineOffset((BaseDocument)doc, (int)tokenSequence.offset());
                    int lastLineOfEmbeddedBlock = Utilities.getLineOffset((BaseDocument)doc, (int)(tokenSequence.offset() + TagBasedLexerFormatter.getTxtLengthWithoutWhitespaceSuffix(tokenSequence.token().text())));
                    if (Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)firstLineOfEmbeddedBlock)) < Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)tokenSequence.offset())) {
                        // empty if block
                    }
                    for (int i4 = ++firstLineOfEmbeddedBlock; i4 <= lastLineOfEmbeddedBlock; ++i4) {
                        embeddingType[i4] = EmbeddingType.INNER;
                    }
                } while (thereAreMoreTokens &= tokenSequence.moveNext());
            }
            for (int line = 0; line < transferData.getNumberOfLines(); ++line) {
                if (embeddingType[line] == EmbeddingType.CURRENT_LANG) {
                    transferData.setProcessedByNativeFormatter(line);
                    continue;
                }
                if (embeddingType[line] != EmbeddingType.OUTER || transferData.wasProcessedByNativeFormatter(line)) continue;
                embeddingType[line] = EmbeddingType.INNER;
            }
            int[] indentLevels = new int[transferData.getNumberOfLines()];
            Arrays.fill(indentLevels, 0);
            for (TagIndentationData td : matchedOpeningTags) {
                i = td.getLine() + 1;
                while (i <= td.getClosedOnLine() - 1) {
                    int n = i++;
                    indentLevels[n] = indentLevels[n] + 1;
                }
            }
            int[] previousIndents = transferData.getTransformedOffsets();
            int[] absoluteIndents = new int[transferData.getNumberOfLines()];
            for (i = 0; i < transferData.getNumberOfLines(); ++i) {
                absoluteIndents[i] = indentLevels[i] * doc.getShiftWidth() + indentsWithinTags[i];
            }
            int lastCrossPoint = 0;
            int lastOuterCrossPoint = 0;
            EmbeddingType lastEmbeddingType = null;
            int[] newIndents = new int[transferData.getNumberOfLines()];
            boolean topLevel = TagBasedLexerFormatter.this.isTopLevelLanguage(doc);
            for (int i5 = 0; i5 < transferData.getNumberOfLines(); ++i5) {
                if (lastEmbeddingType != embeddingType[i5]) {
                    lastCrossPoint = i5;
                    if (lastEmbeddingType == EmbeddingType.OUTER) {
                        lastOuterCrossPoint = i5;
                    }
                    lastEmbeddingType = embeddingType[i5];
                }
                if (!transferData.isFormattable(i5)) {
                    newIndents[i5] = transferData.getOriginalIndent(i5);
                    continue;
                }
                if (embeddingType[i5] == EmbeddingType.OUTER) {
                    newIndents[i5] = previousIndents[i5] + absoluteIndents[i5];
                    continue;
                }
                if (embeddingType[i5] == EmbeddingType.INNER) {
                    if (lastCrossPoint == i5) {
                        int previousLineIndent = i5 > 0 ? newIndents[lastCrossPoint - 1] : 0;
                        int absDiff = absoluteIndents[i5] - (i5 > 0 ? absoluteIndents[i5 - 1] : 0);
                        newIndents[i5] = previousLineIndent + absDiff;
                        continue;
                    }
                    int diff = topLevel ? transferData.getOriginalIndent(i5) - transferData.getOriginalIndent(lastCrossPoint) : previousIndents[i5] - previousIndents[lastCrossPoint];
                    newIndents[i5] = newIndents[lastCrossPoint] + diff;
                    continue;
                }
                newIndents[i5] = previousIndents[lastOuterCrossPoint] + absoluteIndents[i5];
            }
            int lineBeforeSelectionBias = 0;
            if (firstRefBlockLine > 0) {
                lineBeforeSelectionBias = transferData.getOriginalIndent(firstRefBlockLine - 1) - newIndents[firstRefBlockLine - 1];
            }
            for (int line = firstRefBlockLine; line <= lastRefBlockLine; ++line) {
                int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
                int newIndent = newIndents[line] + lineBeforeSelectionBias;
                this.context.modifyIndent(lineStart, newIndent > 0 ? newIndent : 0);
            }
            transferData.setTransformedOffsets(newIndents);
            if (logger.isLoggable(Level.FINE)) {
                StringBuilder buff = new StringBuilder();
                for (int i6 = 0; i6 < transferData.getNumberOfLines(); ++i6) {
                    int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)i6);
                    char formattingTypeSymbol = '\u0000';
                    formattingTypeSymbol = !transferData.isFormattable(i6) ? (char)'-' : (embeddingType[i6] == EmbeddingType.INNER ? (char)'I' : (embeddingType[i6] == EmbeddingType.OUTER ? (char)'O' : 'C'));
                    char formattingRange = i6 >= firstRefBlockLine && i6 <= lastRefBlockLine ? (char)'*' : ' ';
                    buff.append(i6 + ":" + formattingRange + ":" + indentLevels[i6] + ":" + formattingTypeSymbol + ":" + doc.getText(lineStart, Utilities.getRowEnd((BaseDocument)doc, (int)lineStart) - lineStart) + ".\n");
                }
                buff.append("\n-------------\n");
                logger.fine(TagBasedLexerFormatter.this.formatterName() + ":\n" + buff);
            }
        }
    }

    private class EnterPressedTask
    implements Runnable {
        private Context context;

        public EnterPressedTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.enterPressed();
            }
            catch (BadLocationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        private void enterPressed() throws BadLocationException {
            int origDotPos;
            Integer dotPos;
            BaseDocument doc = (BaseDocument)this.context.document();
            if (TagBasedLexerFormatter.this.isTopLevelLanguage(doc)) {
                doc.putProperty((Object)"TagBasedFormatter.org_caret_offset", (Object)this.context.caretOffset());
            }
            if ((dotPos = (Integer)doc.getProperty((Object)"TagBasedFormatter.org_caret_offset")) == null) {
                dotPos = this.context.caretOffset();
            }
            if (TagBasedLexerFormatter.this.indexWithinCurrentLanguage(doc, (origDotPos = dotPos - 1) - 1)) {
                if (TagBasedLexerFormatter.this.isSmartEnter(doc, dotPos)) {
                    TagBasedLexerFormatter.this.handleSmartEnter(this.context);
                } else {
                    int newIndent = 0;
                    int lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos);
                    boolean firstRow = false;
                    if (Utilities.getRowStart((BaseDocument)doc, (int)origDotPos) == origDotPos) {
                        newIndent = TagBasedLexerFormatter.getExistingIndent(doc, lineNumber);
                        firstRow = true;
                    } else if (lineNumber > 0) {
                        newIndent = TagBasedLexerFormatter.getExistingIndent(doc, lineNumber - 1);
                    }
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                    TokenSequence[] tokenSequences = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
                    TextBounds[] tokenSequenceBounds = new TextBounds[tokenSequences.length];
                    for (int i = 0; i < tokenSequenceBounds.length; ++i) {
                        tokenSequenceBounds[i] = TagBasedLexerFormatter.this.findTokenSequenceBounds(doc, tokenSequences[i]);
                    }
                    JoinedTokenSequence tokenSequence = new JoinedTokenSequence(tokenSequences, tokenSequenceBounds);
                    tokenSequence.moveStart();
                    tokenSequence.moveNext();
                    int openingTagOffset = TagBasedLexerFormatter.this.getTagEndingAtPosition(tokenSequence, origDotPos - 1);
                    if (TagBasedLexerFormatter.this.isOpeningTag(tokenSequence, openingTagOffset)) {
                        newIndent += doc.getShiftWidth();
                    }
                    this.context.modifyIndent(Utilities.getRowStart((BaseDocument)doc, (int)dotPos), newIndent);
                    if (firstRow) {
                        this.context.setCaretOffset(this.context.caretOffset() - newIndent);
                    }
                }
            }
        }
    }

    private class IsJustAfterClosingTagTask
    implements Runnable {
        private BaseDocument doc;
        private int pos;
        private boolean result = false;

        public IsJustAfterClosingTagTask(BaseDocument doc, int pos) {
            this.doc = doc;
            this.pos = pos;
        }

        @Override
        public void run() {
            try {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence[] tokenSequences = tokenHierarchy.tokenSequenceList(TagBasedLexerFormatter.this.supportedLanguagePath(), 0, Integer.MAX_VALUE).toArray(new TokenSequence[0]);
                TextBounds[] tokenSequenceBounds = new TextBounds[tokenSequences.length];
                for (int i = 0; i < tokenSequenceBounds.length; ++i) {
                    tokenSequenceBounds[i] = TagBasedLexerFormatter.this.findTokenSequenceBounds(this.doc, tokenSequences[i]);
                }
                if (tokenSequences.length > 0) {
                    JoinedTokenSequence tokenSequence = new JoinedTokenSequence(tokenSequences, tokenSequenceBounds);
                    tokenSequence.moveStart();
                    tokenSequence.moveNext();
                    int tagPos = TagBasedLexerFormatter.this.getTagEndingAtPosition(tokenSequence, this.pos);
                    this.result = tagPos >= 0 && TagBasedLexerFormatter.this.isClosingTag(tokenSequence, tagPos);
                }
            }
            catch (BadLocationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }

    public static enum EmbeddingType {
        CURRENT_LANG,
        INNER,
        OUTER;

    }
}

