/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.validation;

import java.io.File;
import org.netbeans.modules.web.clientproject.api.validation.FolderValidator;
import org.netbeans.modules.web.clientproject.validation.Bundle;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class ProjectFoldersValidator {
    public static final String SOURCE_FOLDER = "source.folder";
    public static final String SITE_ROOT_FOLDER = "site.root.folder";
    public static final String SOURCE_OR_SITE_ROOT_FOLDER = "source.or.site.root.folder";
    public static final String TEST_FOLDER = "test.folder";
    public static final String TEST_SELENIUM_FOLDER = "test.selenium.folder";
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public ProjectFoldersValidator validate(File sourceFolder, File siteRootFolder, File testFolder, File testSeleniumFolder) {
        this.validateSourceFolder(sourceFolder);
        this.validateSiteRootFolder(siteRootFolder);
        this.validateSourceAndSiteRootFolders(sourceFolder, siteRootFolder);
        this.validateTestFolder(testFolder);
        this.validateTestSeleniumFolder(testSeleniumFolder);
        return this;
    }

    public ProjectFoldersValidator validateSourceFolder(File sourceFolder) {
        return this.validateProjectFolder(sourceFolder, SOURCE_FOLDER, Bundle.ProjectFoldersValidator_sources());
    }

    public ProjectFoldersValidator validateSiteRootFolder(File siteRootFolder) {
        return this.validateProjectFolder(siteRootFolder, SITE_ROOT_FOLDER, Bundle.ProjectFoldersValidator_siteRoot());
    }

    public ProjectFoldersValidator validateSourceAndSiteRootFolders(File sourceFolder, File siteRootFolder) {
        if (sourceFolder == null && siteRootFolder == null) {
            this.result.addError(new ValidationResult.Message((Object)SOURCE_OR_SITE_ROOT_FOLDER, Bundle.ProjectFoldersValidator_error_noSourcesOrSiteRoot()));
        } else if (sourceFolder != null && siteRootFolder != null) {
            if (siteRootFolder.equals(sourceFolder)) {
                this.result.addWarning(new ValidationResult.Message((Object)SOURCE_FOLDER, Bundle.ProjectFoldersValidator_error_sourcesEqualsSiteRoot()));
            } else {
                for (File parent = sourceFolder.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    if (!parent.equals(siteRootFolder)) continue;
                    this.result.addWarning(new ValidationResult.Message((Object)SOURCE_FOLDER, Bundle.ProjectFoldersValidator_error_sourcesUnderneathSiteRoot()));
                    break;
                }
            }
        }
        return this;
    }

    ProjectFoldersValidator validateTestFolder(File testFolder) {
        return this.validateProjectFolder(testFolder, TEST_FOLDER, Bundle.ProjectFoldersValidator_tests());
    }

    ProjectFoldersValidator validateTestSeleniumFolder(File testSeleniumFolder) {
        return this.validateProjectFolder(testSeleniumFolder, TEST_SELENIUM_FOLDER, Bundle.ProjectFoldersValidator_tests_selenium());
    }

    private ProjectFoldersValidator validateProjectFolder(File folder, String source, String dirName) {
        if (folder == null) {
            return this;
        }
        ValidationResult folderValidationResult = new FolderValidator().validateFolder(folder, dirName).getResult();
        for (ValidationResult.Message error : folderValidationResult.getErrors()) {
            this.result.addError(new ValidationResult.Message((Object)source, error.getMessage()));
        }
        for (ValidationResult.Message warning : folderValidationResult.getWarnings()) {
            this.result.addWarning(new ValidationResult.Message((Object)source, warning.getMessage()));
        }
        return this;
    }
}

