/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.faces.FacesException;
import org.primefaces.util.Base64;

public class StringEncrypter {
    private static final Logger LOG = Logger.getLogger(StringEncrypter.class.getName());
    private Cipher ecipher;
    private Cipher dcipher;

    public StringEncrypter(SecretKey key, String algorithm) {
        try {
            this.ecipher = Cipher.getInstance(algorithm);
            this.dcipher = Cipher.getInstance(algorithm);
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (Exception e) {
            throw new FacesException("Could not initialize Cipher objects", (Throwable)e);
        }
    }

    public StringEncrypter(String passPhrase) {
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 52, -29, 3};
        int iterationCount = 19;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (Exception e) {
            throw new FacesException("Could not initialize Cipher objects", (Throwable)e);
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.encodeToString(enc, false);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not encrypt string", e);
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = Base64.decode(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not decrypt string", e);
            return null;
        }
    }
}

