/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseBackupConfig;
import com.oracle.bmc.database.model.AutonomousDatabaseKeyHistoryEntry;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousContainerDatabaseSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="serviceLevelAgreementType")
    private final ServiceLevelAgreementType serviceLevelAgreementType;
    @JsonProperty(value="autonomousExadataInfrastructureId")
    private final String autonomousExadataInfrastructureId;
    @JsonProperty(value="autonomousVmClusterId")
    private final String autonomousVmClusterId;
    @JsonProperty(value="infrastructureType")
    private final InfrastructureType infrastructureType;
    @JsonProperty(value="cloudAutonomousVmClusterId")
    private final String cloudAutonomousVmClusterId;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="keyHistoryEntry")
    private final List<AutonomousDatabaseKeyHistoryEntry> keyHistoryEntry;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeSnapshotStandbyRevert")
    private final Date timeSnapshotStandbyRevert;
    @JsonProperty(value="patchModel")
    private final PatchModel patchModel;
    @JsonProperty(value="patchId")
    private final String patchId;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="maintenanceWindow")
    private final MaintenanceWindow maintenanceWindow;
    @JsonProperty(value="standbyMaintenanceBufferInDays")
    private final Integer standbyMaintenanceBufferInDays;
    @JsonProperty(value="versionPreference")
    private final VersionPreference versionPreference;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="backupConfig")
    private final AutonomousContainerDatabaseBackupConfig backupConfig;
    @JsonProperty(value="keyStoreId")
    private final String keyStoreId;
    @JsonProperty(value="keyStoreWalletName")
    private final String keyStoreWalletName;
    @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
    private final Integer memoryPerOracleComputeUnitInGBs;
    @JsonProperty(value="availableCpus")
    private final Float availableCpus;
    @JsonProperty(value="totalCpus")
    private final Integer totalCpus;
    @JsonProperty(value="reclaimableCpus")
    private final Float reclaimableCpus;
    @JsonProperty(value="provisionableCpus")
    private final List<Float> provisionableCpus;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "dbUniqueName", "serviceLevelAgreementType", "autonomousExadataInfrastructureId", "autonomousVmClusterId", "infrastructureType", "cloudAutonomousVmClusterId", "kmsKeyId", "vaultId", "kmsKeyVersionId", "keyHistoryEntry", "lifecycleState", "lifecycleDetails", "timeCreated", "timeSnapshotStandbyRevert", "patchModel", "patchId", "lastMaintenanceRunId", "nextMaintenanceRunId", "maintenanceWindow", "standbyMaintenanceBufferInDays", "versionPreference", "freeformTags", "definedTags", "role", "availabilityDomain", "dbVersion", "backupConfig", "keyStoreId", "keyStoreWalletName", "memoryPerOracleComputeUnitInGBs", "availableCpus", "totalCpus", "reclaimableCpus", "provisionableCpus", "computeModel"})
    public AutonomousContainerDatabaseSummary(String id, String compartmentId, String displayName, String dbUniqueName, ServiceLevelAgreementType serviceLevelAgreementType, String autonomousExadataInfrastructureId, String autonomousVmClusterId, InfrastructureType infrastructureType, String cloudAutonomousVmClusterId, String kmsKeyId, String vaultId, String kmsKeyVersionId, List<AutonomousDatabaseKeyHistoryEntry> keyHistoryEntry, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeSnapshotStandbyRevert, PatchModel patchModel, String patchId, String lastMaintenanceRunId, String nextMaintenanceRunId, MaintenanceWindow maintenanceWindow, Integer standbyMaintenanceBufferInDays, VersionPreference versionPreference, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Role role, String availabilityDomain, String dbVersion, AutonomousContainerDatabaseBackupConfig backupConfig, String keyStoreId, String keyStoreWalletName, Integer memoryPerOracleComputeUnitInGBs, Float availableCpus, Integer totalCpus, Float reclaimableCpus, List<Float> provisionableCpus, ComputeModel computeModel) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.dbUniqueName = dbUniqueName;
        this.serviceLevelAgreementType = serviceLevelAgreementType;
        this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
        this.autonomousVmClusterId = autonomousVmClusterId;
        this.infrastructureType = infrastructureType;
        this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        this.kmsKeyId = kmsKeyId;
        this.vaultId = vaultId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.keyHistoryEntry = keyHistoryEntry;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeSnapshotStandbyRevert = timeSnapshotStandbyRevert;
        this.patchModel = patchModel;
        this.patchId = patchId;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.maintenanceWindow = maintenanceWindow;
        this.standbyMaintenanceBufferInDays = standbyMaintenanceBufferInDays;
        this.versionPreference = versionPreference;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.role = role;
        this.availabilityDomain = availabilityDomain;
        this.dbVersion = dbVersion;
        this.backupConfig = backupConfig;
        this.keyStoreId = keyStoreId;
        this.keyStoreWalletName = keyStoreWalletName;
        this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        this.availableCpus = availableCpus;
        this.totalCpus = totalCpus;
        this.reclaimableCpus = reclaimableCpus;
        this.provisionableCpus = provisionableCpus;
        this.computeModel = computeModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public ServiceLevelAgreementType getServiceLevelAgreementType() {
        return this.serviceLevelAgreementType;
    }

    public String getAutonomousExadataInfrastructureId() {
        return this.autonomousExadataInfrastructureId;
    }

    public String getAutonomousVmClusterId() {
        return this.autonomousVmClusterId;
    }

    public InfrastructureType getInfrastructureType() {
        return this.infrastructureType;
    }

    public String getCloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public List<AutonomousDatabaseKeyHistoryEntry> getKeyHistoryEntry() {
        return this.keyHistoryEntry;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeSnapshotStandbyRevert() {
        return this.timeSnapshotStandbyRevert;
    }

    public PatchModel getPatchModel() {
        return this.patchModel;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public MaintenanceWindow getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public Integer getStandbyMaintenanceBufferInDays() {
        return this.standbyMaintenanceBufferInDays;
    }

    public VersionPreference getVersionPreference() {
        return this.versionPreference;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Role getRole() {
        return this.role;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public AutonomousContainerDatabaseBackupConfig getBackupConfig() {
        return this.backupConfig;
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getKeyStoreWalletName() {
        return this.keyStoreWalletName;
    }

    public Integer getMemoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public Float getAvailableCpus() {
        return this.availableCpus;
    }

    public Integer getTotalCpus() {
        return this.totalCpus;
    }

    public Float getReclaimableCpus() {
        return this.reclaimableCpus;
    }

    public List<Float> getProvisionableCpus() {
        return this.provisionableCpus;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousContainerDatabaseSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", serviceLevelAgreementType=").append(String.valueOf((Object)this.serviceLevelAgreementType));
        sb.append(", autonomousExadataInfrastructureId=").append(String.valueOf(this.autonomousExadataInfrastructureId));
        sb.append(", autonomousVmClusterId=").append(String.valueOf(this.autonomousVmClusterId));
        sb.append(", infrastructureType=").append(String.valueOf((Object)this.infrastructureType));
        sb.append(", cloudAutonomousVmClusterId=").append(String.valueOf(this.cloudAutonomousVmClusterId));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", keyHistoryEntry=").append(String.valueOf(this.keyHistoryEntry));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeSnapshotStandbyRevert=").append(String.valueOf(this.timeSnapshotStandbyRevert));
        sb.append(", patchModel=").append(String.valueOf((Object)this.patchModel));
        sb.append(", patchId=").append(String.valueOf(this.patchId));
        sb.append(", lastMaintenanceRunId=").append(String.valueOf(this.lastMaintenanceRunId));
        sb.append(", nextMaintenanceRunId=").append(String.valueOf(this.nextMaintenanceRunId));
        sb.append(", maintenanceWindow=").append(String.valueOf((Object)this.maintenanceWindow));
        sb.append(", standbyMaintenanceBufferInDays=").append(String.valueOf(this.standbyMaintenanceBufferInDays));
        sb.append(", versionPreference=").append(String.valueOf((Object)this.versionPreference));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", backupConfig=").append(String.valueOf((Object)this.backupConfig));
        sb.append(", keyStoreId=").append(String.valueOf(this.keyStoreId));
        sb.append(", keyStoreWalletName=").append(String.valueOf(this.keyStoreWalletName));
        sb.append(", memoryPerOracleComputeUnitInGBs=").append(String.valueOf(this.memoryPerOracleComputeUnitInGBs));
        sb.append(", availableCpus=").append(String.valueOf(this.availableCpus));
        sb.append(", totalCpus=").append(String.valueOf(this.totalCpus));
        sb.append(", reclaimableCpus=").append(String.valueOf(this.reclaimableCpus));
        sb.append(", provisionableCpus=").append(String.valueOf(this.provisionableCpus));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousContainerDatabaseSummary)) {
            return false;
        }
        AutonomousContainerDatabaseSummary other = (AutonomousContainerDatabaseSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals((Object)this.serviceLevelAgreementType, (Object)other.serviceLevelAgreementType) && Objects.equals(this.autonomousExadataInfrastructureId, other.autonomousExadataInfrastructureId) && Objects.equals(this.autonomousVmClusterId, other.autonomousVmClusterId) && Objects.equals((Object)this.infrastructureType, (Object)other.infrastructureType) && Objects.equals(this.cloudAutonomousVmClusterId, other.cloudAutonomousVmClusterId) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.keyHistoryEntry, other.keyHistoryEntry) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeSnapshotStandbyRevert, other.timeSnapshotStandbyRevert) && Objects.equals((Object)this.patchModel, (Object)other.patchModel) && Objects.equals(this.patchId, other.patchId) && Objects.equals(this.lastMaintenanceRunId, other.lastMaintenanceRunId) && Objects.equals(this.nextMaintenanceRunId, other.nextMaintenanceRunId) && Objects.equals((Object)this.maintenanceWindow, (Object)other.maintenanceWindow) && Objects.equals(this.standbyMaintenanceBufferInDays, other.standbyMaintenanceBufferInDays) && Objects.equals((Object)this.versionPreference, (Object)other.versionPreference) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals((Object)this.backupConfig, (Object)other.backupConfig) && Objects.equals(this.keyStoreId, other.keyStoreId) && Objects.equals(this.keyStoreWalletName, other.keyStoreWalletName) && Objects.equals(this.memoryPerOracleComputeUnitInGBs, other.memoryPerOracleComputeUnitInGBs) && Objects.equals(this.availableCpus, other.availableCpus) && Objects.equals(this.totalCpus, other.totalCpus) && Objects.equals(this.reclaimableCpus, other.reclaimableCpus) && Objects.equals(this.provisionableCpus, other.provisionableCpus) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.serviceLevelAgreementType == null ? 43 : this.serviceLevelAgreementType.hashCode());
        result = result * 59 + (this.autonomousExadataInfrastructureId == null ? 43 : this.autonomousExadataInfrastructureId.hashCode());
        result = result * 59 + (this.autonomousVmClusterId == null ? 43 : this.autonomousVmClusterId.hashCode());
        result = result * 59 + (this.infrastructureType == null ? 43 : this.infrastructureType.hashCode());
        result = result * 59 + (this.cloudAutonomousVmClusterId == null ? 43 : this.cloudAutonomousVmClusterId.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.keyHistoryEntry == null ? 43 : this.keyHistoryEntry.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeSnapshotStandbyRevert == null ? 43 : this.timeSnapshotStandbyRevert.hashCode());
        result = result * 59 + (this.patchModel == null ? 43 : this.patchModel.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.lastMaintenanceRunId == null ? 43 : this.lastMaintenanceRunId.hashCode());
        result = result * 59 + (this.nextMaintenanceRunId == null ? 43 : this.nextMaintenanceRunId.hashCode());
        result = result * 59 + (this.maintenanceWindow == null ? 43 : this.maintenanceWindow.hashCode());
        result = result * 59 + (this.standbyMaintenanceBufferInDays == null ? 43 : this.standbyMaintenanceBufferInDays.hashCode());
        result = result * 59 + (this.versionPreference == null ? 43 : this.versionPreference.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.backupConfig == null ? 43 : this.backupConfig.hashCode());
        result = result * 59 + (this.keyStoreId == null ? 43 : this.keyStoreId.hashCode());
        result = result * 59 + (this.keyStoreWalletName == null ? 43 : this.keyStoreWalletName.hashCode());
        result = result * 59 + (this.memoryPerOracleComputeUnitInGBs == null ? 43 : this.memoryPerOracleComputeUnitInGBs.hashCode());
        result = result * 59 + (this.availableCpus == null ? 43 : this.availableCpus.hashCode());
        result = result * 59 + (this.totalCpus == null ? 43 : this.totalCpus.hashCode());
        result = result * 59 + (this.reclaimableCpus == null ? 43 : this.reclaimableCpus.hashCode());
        result = result * 59 + (this.provisionableCpus == null ? 43 : this.provisionableCpus.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeModel.class);
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        BackupCopy("BACKUP_COPY"),
        SnapshotStandby("SNAPSHOT_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum VersionPreference implements BmcEnum
    {
        NextReleaseUpdate("NEXT_RELEASE_UPDATE"),
        LatestReleaseUpdate("LATEST_RELEASE_UPDATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, VersionPreference> map;

        private VersionPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static VersionPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'VersionPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(VersionPreference.class);
            map = new HashMap<String, VersionPreference>();
            for (VersionPreference v : VersionPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PatchModel implements BmcEnum
    {
        ReleaseUpdates("RELEASE_UPDATES"),
        ReleaseUpdateRevisions("RELEASE_UPDATE_REVISIONS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchModel> map;

        private PatchModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchModel.class);
            map = new HashMap<String, PatchModel>();
            for (PatchModel v : PatchModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        Restoring("RESTORING"),
        RestoreFailed("RESTORE_FAILED"),
        Restarting("RESTARTING"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        RoleChangeInProgress("ROLE_CHANGE_IN_PROGRESS"),
        Unavailable("UNAVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InfrastructureType implements BmcEnum
    {
        Cloud("CLOUD"),
        CloudAtCustomer("CLOUD_AT_CUSTOMER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InfrastructureType> map;

        private InfrastructureType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InfrastructureType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InfrastructureType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InfrastructureType.class);
            map = new HashMap<String, InfrastructureType>();
            for (InfrastructureType v : InfrastructureType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ServiceLevelAgreementType implements BmcEnum
    {
        Standard("STANDARD"),
        MissionCritical("MISSION_CRITICAL"),
        AutonomousDataguard("AUTONOMOUS_DATAGUARD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ServiceLevelAgreementType> map;

        private ServiceLevelAgreementType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceLevelAgreementType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ServiceLevelAgreementType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ServiceLevelAgreementType.class);
            map = new HashMap<String, ServiceLevelAgreementType>();
            for (ServiceLevelAgreementType v : ServiceLevelAgreementType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="serviceLevelAgreementType")
        private ServiceLevelAgreementType serviceLevelAgreementType;
        @JsonProperty(value="autonomousExadataInfrastructureId")
        private String autonomousExadataInfrastructureId;
        @JsonProperty(value="autonomousVmClusterId")
        private String autonomousVmClusterId;
        @JsonProperty(value="infrastructureType")
        private InfrastructureType infrastructureType;
        @JsonProperty(value="cloudAutonomousVmClusterId")
        private String cloudAutonomousVmClusterId;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="keyHistoryEntry")
        private List<AutonomousDatabaseKeyHistoryEntry> keyHistoryEntry;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeSnapshotStandbyRevert")
        private Date timeSnapshotStandbyRevert;
        @JsonProperty(value="patchModel")
        private PatchModel patchModel;
        @JsonProperty(value="patchId")
        private String patchId;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="maintenanceWindow")
        private MaintenanceWindow maintenanceWindow;
        @JsonProperty(value="standbyMaintenanceBufferInDays")
        private Integer standbyMaintenanceBufferInDays;
        @JsonProperty(value="versionPreference")
        private VersionPreference versionPreference;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="backupConfig")
        private AutonomousContainerDatabaseBackupConfig backupConfig;
        @JsonProperty(value="keyStoreId")
        private String keyStoreId;
        @JsonProperty(value="keyStoreWalletName")
        private String keyStoreWalletName;
        @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
        private Integer memoryPerOracleComputeUnitInGBs;
        @JsonProperty(value="availableCpus")
        private Float availableCpus;
        @JsonProperty(value="totalCpus")
        private Integer totalCpus;
        @JsonProperty(value="reclaimableCpus")
        private Float reclaimableCpus;
        @JsonProperty(value="provisionableCpus")
        private List<Float> provisionableCpus;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder serviceLevelAgreementType(ServiceLevelAgreementType serviceLevelAgreementType) {
            this.serviceLevelAgreementType = serviceLevelAgreementType;
            this.__explicitlySet__.add("serviceLevelAgreementType");
            return this;
        }

        public Builder autonomousExadataInfrastructureId(String autonomousExadataInfrastructureId) {
            this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
            this.__explicitlySet__.add("autonomousExadataInfrastructureId");
            return this;
        }

        public Builder autonomousVmClusterId(String autonomousVmClusterId) {
            this.autonomousVmClusterId = autonomousVmClusterId;
            this.__explicitlySet__.add("autonomousVmClusterId");
            return this;
        }

        public Builder infrastructureType(InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            this.__explicitlySet__.add("infrastructureType");
            return this;
        }

        public Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            this.__explicitlySet__.add("cloudAutonomousVmClusterId");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder keyHistoryEntry(List<AutonomousDatabaseKeyHistoryEntry> keyHistoryEntry) {
            this.keyHistoryEntry = keyHistoryEntry;
            this.__explicitlySet__.add("keyHistoryEntry");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeSnapshotStandbyRevert(Date timeSnapshotStandbyRevert) {
            this.timeSnapshotStandbyRevert = timeSnapshotStandbyRevert;
            this.__explicitlySet__.add("timeSnapshotStandbyRevert");
            return this;
        }

        public Builder patchModel(PatchModel patchModel) {
            this.patchModel = patchModel;
            this.__explicitlySet__.add("patchModel");
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            this.__explicitlySet__.add("patchId");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            this.__explicitlySet__.add("maintenanceWindow");
            return this;
        }

        public Builder standbyMaintenanceBufferInDays(Integer standbyMaintenanceBufferInDays) {
            this.standbyMaintenanceBufferInDays = standbyMaintenanceBufferInDays;
            this.__explicitlySet__.add("standbyMaintenanceBufferInDays");
            return this;
        }

        public Builder versionPreference(VersionPreference versionPreference) {
            this.versionPreference = versionPreference;
            this.__explicitlySet__.add("versionPreference");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder backupConfig(AutonomousContainerDatabaseBackupConfig backupConfig) {
            this.backupConfig = backupConfig;
            this.__explicitlySet__.add("backupConfig");
            return this;
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            this.__explicitlySet__.add("keyStoreId");
            return this;
        }

        public Builder keyStoreWalletName(String keyStoreWalletName) {
            this.keyStoreWalletName = keyStoreWalletName;
            this.__explicitlySet__.add("keyStoreWalletName");
            return this;
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            this.__explicitlySet__.add("memoryPerOracleComputeUnitInGBs");
            return this;
        }

        public Builder availableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
            this.__explicitlySet__.add("availableCpus");
            return this;
        }

        public Builder totalCpus(Integer totalCpus) {
            this.totalCpus = totalCpus;
            this.__explicitlySet__.add("totalCpus");
            return this;
        }

        public Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            this.__explicitlySet__.add("reclaimableCpus");
            return this;
        }

        public Builder provisionableCpus(List<Float> provisionableCpus) {
            this.provisionableCpus = provisionableCpus;
            this.__explicitlySet__.add("provisionableCpus");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public AutonomousContainerDatabaseSummary build() {
            AutonomousContainerDatabaseSummary model = new AutonomousContainerDatabaseSummary(this.id, this.compartmentId, this.displayName, this.dbUniqueName, this.serviceLevelAgreementType, this.autonomousExadataInfrastructureId, this.autonomousVmClusterId, this.infrastructureType, this.cloudAutonomousVmClusterId, this.kmsKeyId, this.vaultId, this.kmsKeyVersionId, this.keyHistoryEntry, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeSnapshotStandbyRevert, this.patchModel, this.patchId, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.maintenanceWindow, this.standbyMaintenanceBufferInDays, this.versionPreference, this.freeformTags, this.definedTags, this.role, this.availabilityDomain, this.dbVersion, this.backupConfig, this.keyStoreId, this.keyStoreWalletName, this.memoryPerOracleComputeUnitInGBs, this.availableCpus, this.totalCpus, this.reclaimableCpus, this.provisionableCpus, this.computeModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousContainerDatabaseSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("serviceLevelAgreementType")) {
                this.serviceLevelAgreementType(model.getServiceLevelAgreementType());
            }
            if (model.wasPropertyExplicitlySet("autonomousExadataInfrastructureId")) {
                this.autonomousExadataInfrastructureId(model.getAutonomousExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("autonomousVmClusterId")) {
                this.autonomousVmClusterId(model.getAutonomousVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("infrastructureType")) {
                this.infrastructureType(model.getInfrastructureType());
            }
            if (model.wasPropertyExplicitlySet("cloudAutonomousVmClusterId")) {
                this.cloudAutonomousVmClusterId(model.getCloudAutonomousVmClusterId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("keyHistoryEntry")) {
                this.keyHistoryEntry(model.getKeyHistoryEntry());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeSnapshotStandbyRevert")) {
                this.timeSnapshotStandbyRevert(model.getTimeSnapshotStandbyRevert());
            }
            if (model.wasPropertyExplicitlySet("patchModel")) {
                this.patchModel(model.getPatchModel());
            }
            if (model.wasPropertyExplicitlySet("patchId")) {
                this.patchId(model.getPatchId());
            }
            if (model.wasPropertyExplicitlySet("lastMaintenanceRunId")) {
                this.lastMaintenanceRunId(model.getLastMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("nextMaintenanceRunId")) {
                this.nextMaintenanceRunId(model.getNextMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindow")) {
                this.maintenanceWindow(model.getMaintenanceWindow());
            }
            if (model.wasPropertyExplicitlySet("standbyMaintenanceBufferInDays")) {
                this.standbyMaintenanceBufferInDays(model.getStandbyMaintenanceBufferInDays());
            }
            if (model.wasPropertyExplicitlySet("versionPreference")) {
                this.versionPreference(model.getVersionPreference());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("backupConfig")) {
                this.backupConfig(model.getBackupConfig());
            }
            if (model.wasPropertyExplicitlySet("keyStoreId")) {
                this.keyStoreId(model.getKeyStoreId());
            }
            if (model.wasPropertyExplicitlySet("keyStoreWalletName")) {
                this.keyStoreWalletName(model.getKeyStoreWalletName());
            }
            if (model.wasPropertyExplicitlySet("memoryPerOracleComputeUnitInGBs")) {
                this.memoryPerOracleComputeUnitInGBs(model.getMemoryPerOracleComputeUnitInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableCpus")) {
                this.availableCpus(model.getAvailableCpus());
            }
            if (model.wasPropertyExplicitlySet("totalCpus")) {
                this.totalCpus(model.getTotalCpus());
            }
            if (model.wasPropertyExplicitlySet("reclaimableCpus")) {
                this.reclaimableCpus(model.getReclaimableCpus());
            }
            if (model.wasPropertyExplicitlySet("provisionableCpus")) {
                this.provisionableCpus(model.getProvisionableCpus());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            return this;
        }
    }
}

