/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.CustomerContact;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudExadataInfrastructure
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="computeCount")
    private final Integer computeCount;
    @JsonProperty(value="storageCount")
    private final Integer storageCount;
    @JsonProperty(value="totalStorageSizeInGBs")
    private final Integer totalStorageSizeInGBs;
    @JsonProperty(value="availableStorageSizeInGBs")
    private final Integer availableStorageSizeInGBs;
    @JsonProperty(value="cpuCount")
    private final Integer cpuCount;
    @JsonProperty(value="maxCpuCount")
    private final Integer maxCpuCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="maxMemoryInGBs")
    private final Integer maxMemoryInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="maxDbNodeStorageInGBs")
    private final Integer maxDbNodeStorageInGBs;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Double dataStorageSizeInTBs;
    @JsonProperty(value="maxDataStorageInTBs")
    private final Double maxDataStorageInTBs;
    @JsonProperty(value="additionalStorageCount")
    private final Integer additionalStorageCount;
    @JsonProperty(value="activatedStorageCount")
    private final Integer activatedStorageCount;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="maintenanceWindow")
    private final MaintenanceWindow maintenanceWindow;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="customerContacts")
    private final List<CustomerContact> customerContacts;
    @JsonProperty(value="storageServerVersion")
    private final String storageServerVersion;
    @JsonProperty(value="dbServerVersion")
    private final String dbServerVersion;
    @JsonProperty(value="monthlyStorageServerVersion")
    private final String monthlyStorageServerVersion;
    @JsonProperty(value="monthlyDbServerVersion")
    private final String monthlyDbServerVersion;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "lifecycleState", "displayName", "shape", "availabilityDomain", "computeCount", "storageCount", "totalStorageSizeInGBs", "availableStorageSizeInGBs", "cpuCount", "maxCpuCount", "memorySizeInGBs", "maxMemoryInGBs", "dbNodeStorageSizeInGBs", "maxDbNodeStorageInGBs", "dataStorageSizeInTBs", "maxDataStorageInTBs", "additionalStorageCount", "activatedStorageCount", "timeCreated", "lifecycleDetails", "maintenanceWindow", "lastMaintenanceRunId", "nextMaintenanceRunId", "freeformTags", "definedTags", "customerContacts", "storageServerVersion", "dbServerVersion", "monthlyStorageServerVersion", "monthlyDbServerVersion"})
    public CloudExadataInfrastructure(String id, String compartmentId, LifecycleState lifecycleState, String displayName, String shape, String availabilityDomain, Integer computeCount, Integer storageCount, Integer totalStorageSizeInGBs, Integer availableStorageSizeInGBs, Integer cpuCount, Integer maxCpuCount, Integer memorySizeInGBs, Integer maxMemoryInGBs, Integer dbNodeStorageSizeInGBs, Integer maxDbNodeStorageInGBs, Double dataStorageSizeInTBs, Double maxDataStorageInTBs, Integer additionalStorageCount, Integer activatedStorageCount, Date timeCreated, String lifecycleDetails, MaintenanceWindow maintenanceWindow, String lastMaintenanceRunId, String nextMaintenanceRunId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<CustomerContact> customerContacts, String storageServerVersion, String dbServerVersion, String monthlyStorageServerVersion, String monthlyDbServerVersion) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.shape = shape;
        this.availabilityDomain = availabilityDomain;
        this.computeCount = computeCount;
        this.storageCount = storageCount;
        this.totalStorageSizeInGBs = totalStorageSizeInGBs;
        this.availableStorageSizeInGBs = availableStorageSizeInGBs;
        this.cpuCount = cpuCount;
        this.maxCpuCount = maxCpuCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.maxMemoryInGBs = maxMemoryInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.maxDataStorageInTBs = maxDataStorageInTBs;
        this.additionalStorageCount = additionalStorageCount;
        this.activatedStorageCount = activatedStorageCount;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.maintenanceWindow = maintenanceWindow;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.customerContacts = customerContacts;
        this.storageServerVersion = storageServerVersion;
        this.dbServerVersion = dbServerVersion;
        this.monthlyStorageServerVersion = monthlyStorageServerVersion;
        this.monthlyDbServerVersion = monthlyDbServerVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShape() {
        return this.shape;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Integer getComputeCount() {
        return this.computeCount;
    }

    public Integer getStorageCount() {
        return this.storageCount;
    }

    public Integer getTotalStorageSizeInGBs() {
        return this.totalStorageSizeInGBs;
    }

    public Integer getAvailableStorageSizeInGBs() {
        return this.availableStorageSizeInGBs;
    }

    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public Integer getMaxCpuCount() {
        return this.maxCpuCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getMaxMemoryInGBs() {
        return this.maxMemoryInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public Integer getMaxDbNodeStorageInGBs() {
        return this.maxDbNodeStorageInGBs;
    }

    public Double getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public Double getMaxDataStorageInTBs() {
        return this.maxDataStorageInTBs;
    }

    public Integer getAdditionalStorageCount() {
        return this.additionalStorageCount;
    }

    public Integer getActivatedStorageCount() {
        return this.activatedStorageCount;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public MaintenanceWindow getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<CustomerContact> getCustomerContacts() {
        return this.customerContacts;
    }

    public String getStorageServerVersion() {
        return this.storageServerVersion;
    }

    public String getDbServerVersion() {
        return this.dbServerVersion;
    }

    public String getMonthlyStorageServerVersion() {
        return this.monthlyStorageServerVersion;
    }

    public String getMonthlyDbServerVersion() {
        return this.monthlyDbServerVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CloudExadataInfrastructure(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", computeCount=").append(String.valueOf(this.computeCount));
        sb.append(", storageCount=").append(String.valueOf(this.storageCount));
        sb.append(", totalStorageSizeInGBs=").append(String.valueOf(this.totalStorageSizeInGBs));
        sb.append(", availableStorageSizeInGBs=").append(String.valueOf(this.availableStorageSizeInGBs));
        sb.append(", cpuCount=").append(String.valueOf(this.cpuCount));
        sb.append(", maxCpuCount=").append(String.valueOf(this.maxCpuCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", maxMemoryInGBs=").append(String.valueOf(this.maxMemoryInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", maxDbNodeStorageInGBs=").append(String.valueOf(this.maxDbNodeStorageInGBs));
        sb.append(", dataStorageSizeInTBs=").append(String.valueOf(this.dataStorageSizeInTBs));
        sb.append(", maxDataStorageInTBs=").append(String.valueOf(this.maxDataStorageInTBs));
        sb.append(", additionalStorageCount=").append(String.valueOf(this.additionalStorageCount));
        sb.append(", activatedStorageCount=").append(String.valueOf(this.activatedStorageCount));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", maintenanceWindow=").append(String.valueOf((Object)this.maintenanceWindow));
        sb.append(", lastMaintenanceRunId=").append(String.valueOf(this.lastMaintenanceRunId));
        sb.append(", nextMaintenanceRunId=").append(String.valueOf(this.nextMaintenanceRunId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", customerContacts=").append(String.valueOf(this.customerContacts));
        sb.append(", storageServerVersion=").append(String.valueOf(this.storageServerVersion));
        sb.append(", dbServerVersion=").append(String.valueOf(this.dbServerVersion));
        sb.append(", monthlyStorageServerVersion=").append(String.valueOf(this.monthlyStorageServerVersion));
        sb.append(", monthlyDbServerVersion=").append(String.valueOf(this.monthlyDbServerVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudExadataInfrastructure)) {
            return false;
        }
        CloudExadataInfrastructure other = (CloudExadataInfrastructure)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.shape, other.shape) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.computeCount, other.computeCount) && Objects.equals(this.storageCount, other.storageCount) && Objects.equals(this.totalStorageSizeInGBs, other.totalStorageSizeInGBs) && Objects.equals(this.availableStorageSizeInGBs, other.availableStorageSizeInGBs) && Objects.equals(this.cpuCount, other.cpuCount) && Objects.equals(this.maxCpuCount, other.maxCpuCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.maxMemoryInGBs, other.maxMemoryInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals(this.maxDbNodeStorageInGBs, other.maxDbNodeStorageInGBs) && Objects.equals(this.dataStorageSizeInTBs, other.dataStorageSizeInTBs) && Objects.equals(this.maxDataStorageInTBs, other.maxDataStorageInTBs) && Objects.equals(this.additionalStorageCount, other.additionalStorageCount) && Objects.equals(this.activatedStorageCount, other.activatedStorageCount) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals((Object)this.maintenanceWindow, (Object)other.maintenanceWindow) && Objects.equals(this.lastMaintenanceRunId, other.lastMaintenanceRunId) && Objects.equals(this.nextMaintenanceRunId, other.nextMaintenanceRunId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.customerContacts, other.customerContacts) && Objects.equals(this.storageServerVersion, other.storageServerVersion) && Objects.equals(this.dbServerVersion, other.dbServerVersion) && Objects.equals(this.monthlyStorageServerVersion, other.monthlyStorageServerVersion) && Objects.equals(this.monthlyDbServerVersion, other.monthlyDbServerVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.computeCount == null ? 43 : this.computeCount.hashCode());
        result = result * 59 + (this.storageCount == null ? 43 : this.storageCount.hashCode());
        result = result * 59 + (this.totalStorageSizeInGBs == null ? 43 : this.totalStorageSizeInGBs.hashCode());
        result = result * 59 + (this.availableStorageSizeInGBs == null ? 43 : this.availableStorageSizeInGBs.hashCode());
        result = result * 59 + (this.cpuCount == null ? 43 : this.cpuCount.hashCode());
        result = result * 59 + (this.maxCpuCount == null ? 43 : this.maxCpuCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.maxMemoryInGBs == null ? 43 : this.maxMemoryInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.maxDbNodeStorageInGBs == null ? 43 : this.maxDbNodeStorageInGBs.hashCode());
        result = result * 59 + (this.dataStorageSizeInTBs == null ? 43 : this.dataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.maxDataStorageInTBs == null ? 43 : this.maxDataStorageInTBs.hashCode());
        result = result * 59 + (this.additionalStorageCount == null ? 43 : this.additionalStorageCount.hashCode());
        result = result * 59 + (this.activatedStorageCount == null ? 43 : this.activatedStorageCount.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.maintenanceWindow == null ? 43 : this.maintenanceWindow.hashCode());
        result = result * 59 + (this.lastMaintenanceRunId == null ? 43 : this.lastMaintenanceRunId.hashCode());
        result = result * 59 + (this.nextMaintenanceRunId == null ? 43 : this.nextMaintenanceRunId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.customerContacts == null ? 43 : this.customerContacts.hashCode());
        result = result * 59 + (this.storageServerVersion == null ? 43 : this.storageServerVersion.hashCode());
        result = result * 59 + (this.dbServerVersion == null ? 43 : this.dbServerVersion.hashCode());
        result = result * 59 + (this.monthlyStorageServerVersion == null ? 43 : this.monthlyStorageServerVersion.hashCode());
        result = result * 59 + (this.monthlyDbServerVersion == null ? 43 : this.monthlyDbServerVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="computeCount")
        private Integer computeCount;
        @JsonProperty(value="storageCount")
        private Integer storageCount;
        @JsonProperty(value="totalStorageSizeInGBs")
        private Integer totalStorageSizeInGBs;
        @JsonProperty(value="availableStorageSizeInGBs")
        private Integer availableStorageSizeInGBs;
        @JsonProperty(value="cpuCount")
        private Integer cpuCount;
        @JsonProperty(value="maxCpuCount")
        private Integer maxCpuCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="maxMemoryInGBs")
        private Integer maxMemoryInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="maxDbNodeStorageInGBs")
        private Integer maxDbNodeStorageInGBs;
        @JsonProperty(value="dataStorageSizeInTBs")
        private Double dataStorageSizeInTBs;
        @JsonProperty(value="maxDataStorageInTBs")
        private Double maxDataStorageInTBs;
        @JsonProperty(value="additionalStorageCount")
        private Integer additionalStorageCount;
        @JsonProperty(value="activatedStorageCount")
        private Integer activatedStorageCount;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="maintenanceWindow")
        private MaintenanceWindow maintenanceWindow;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="customerContacts")
        private List<CustomerContact> customerContacts;
        @JsonProperty(value="storageServerVersion")
        private String storageServerVersion;
        @JsonProperty(value="dbServerVersion")
        private String dbServerVersion;
        @JsonProperty(value="monthlyStorageServerVersion")
        private String monthlyStorageServerVersion;
        @JsonProperty(value="monthlyDbServerVersion")
        private String monthlyDbServerVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            this.__explicitlySet__.add("computeCount");
            return this;
        }

        public Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            this.__explicitlySet__.add("storageCount");
            return this;
        }

        public Builder totalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
            this.__explicitlySet__.add("totalStorageSizeInGBs");
            return this;
        }

        public Builder availableStorageSizeInGBs(Integer availableStorageSizeInGBs) {
            this.availableStorageSizeInGBs = availableStorageSizeInGBs;
            this.__explicitlySet__.add("availableStorageSizeInGBs");
            return this;
        }

        public Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            this.__explicitlySet__.add("cpuCount");
            return this;
        }

        public Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            this.__explicitlySet__.add("maxCpuCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            this.__explicitlySet__.add("maxMemoryInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder maxDbNodeStorageInGBs(Integer maxDbNodeStorageInGBs) {
            this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
            this.__explicitlySet__.add("maxDbNodeStorageInGBs");
            return this;
        }

        public Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            this.__explicitlySet__.add("dataStorageSizeInTBs");
            return this;
        }

        public Builder maxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
            this.__explicitlySet__.add("maxDataStorageInTBs");
            return this;
        }

        public Builder additionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
            this.__explicitlySet__.add("additionalStorageCount");
            return this;
        }

        public Builder activatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
            this.__explicitlySet__.add("activatedStorageCount");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            this.__explicitlySet__.add("maintenanceWindow");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder customerContacts(List<CustomerContact> customerContacts) {
            this.customerContacts = customerContacts;
            this.__explicitlySet__.add("customerContacts");
            return this;
        }

        public Builder storageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
            this.__explicitlySet__.add("storageServerVersion");
            return this;
        }

        public Builder dbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
            this.__explicitlySet__.add("dbServerVersion");
            return this;
        }

        public Builder monthlyStorageServerVersion(String monthlyStorageServerVersion) {
            this.monthlyStorageServerVersion = monthlyStorageServerVersion;
            this.__explicitlySet__.add("monthlyStorageServerVersion");
            return this;
        }

        public Builder monthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
            this.__explicitlySet__.add("monthlyDbServerVersion");
            return this;
        }

        public CloudExadataInfrastructure build() {
            CloudExadataInfrastructure model = new CloudExadataInfrastructure(this.id, this.compartmentId, this.lifecycleState, this.displayName, this.shape, this.availabilityDomain, this.computeCount, this.storageCount, this.totalStorageSizeInGBs, this.availableStorageSizeInGBs, this.cpuCount, this.maxCpuCount, this.memorySizeInGBs, this.maxMemoryInGBs, this.dbNodeStorageSizeInGBs, this.maxDbNodeStorageInGBs, this.dataStorageSizeInTBs, this.maxDataStorageInTBs, this.additionalStorageCount, this.activatedStorageCount, this.timeCreated, this.lifecycleDetails, this.maintenanceWindow, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.freeformTags, this.definedTags, this.customerContacts, this.storageServerVersion, this.dbServerVersion, this.monthlyStorageServerVersion, this.monthlyDbServerVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CloudExadataInfrastructure model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("computeCount")) {
                this.computeCount(model.getComputeCount());
            }
            if (model.wasPropertyExplicitlySet("storageCount")) {
                this.storageCount(model.getStorageCount());
            }
            if (model.wasPropertyExplicitlySet("totalStorageSizeInGBs")) {
                this.totalStorageSizeInGBs(model.getTotalStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableStorageSizeInGBs")) {
                this.availableStorageSizeInGBs(model.getAvailableStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("cpuCount")) {
                this.cpuCount(model.getCpuCount());
            }
            if (model.wasPropertyExplicitlySet("maxCpuCount")) {
                this.maxCpuCount(model.getMaxCpuCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryInGBs")) {
                this.maxMemoryInGBs(model.getMaxMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("maxDbNodeStorageInGBs")) {
                this.maxDbNodeStorageInGBs(model.getMaxDbNodeStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInTBs")) {
                this.dataStorageSizeInTBs(model.getDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("maxDataStorageInTBs")) {
                this.maxDataStorageInTBs(model.getMaxDataStorageInTBs());
            }
            if (model.wasPropertyExplicitlySet("additionalStorageCount")) {
                this.additionalStorageCount(model.getAdditionalStorageCount());
            }
            if (model.wasPropertyExplicitlySet("activatedStorageCount")) {
                this.activatedStorageCount(model.getActivatedStorageCount());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindow")) {
                this.maintenanceWindow(model.getMaintenanceWindow());
            }
            if (model.wasPropertyExplicitlySet("lastMaintenanceRunId")) {
                this.lastMaintenanceRunId(model.getLastMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("nextMaintenanceRunId")) {
                this.nextMaintenanceRunId(model.getNextMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("customerContacts")) {
                this.customerContacts(model.getCustomerContacts());
            }
            if (model.wasPropertyExplicitlySet("storageServerVersion")) {
                this.storageServerVersion(model.getStorageServerVersion());
            }
            if (model.wasPropertyExplicitlySet("dbServerVersion")) {
                this.dbServerVersion(model.getDbServerVersion());
            }
            if (model.wasPropertyExplicitlySet("monthlyStorageServerVersion")) {
                this.monthlyStorageServerVersion(model.getMonthlyStorageServerVersion());
            }
            if (model.wasPropertyExplicitlySet("monthlyDbServerVersion")) {
                this.monthlyDbServerVersion(model.getMonthlyDbServerVersion());
            }
            return this;
        }
    }
}

