/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.history.DiffResultsView;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.subversion.ui.history.SummaryView;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
DiffSetupSource,
DocumentListener,
ActionListener {
    private final File[] roots;
    private final SVNUrl repositoryUrl;
    private final SearchCriteriaPanel criteria;
    private Action searchAction;
    private SearchExecutor currentSearch;
    private Search currentAdditionalSearch;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List<RepositoryRevision> results;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private SearchHistoryTopComponent.DiffResultsViewFactory diffViewFactory;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private static final Icon ICON_COLLAPSED = UIManager.getIcon("Tree.collapsedIcon");
    private static final Icon ICON_EXPANDED = UIManager.getIcon("Tree.expandedIcon");
    private int showingResults;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap;
    private List<SummaryView.SvnLogEntry> logEntries;
    private boolean selectFirstRevision;
    private final Timer filterTimer;
    private ExplorerManager explorerManager;
    final JButton bNext = new JButton();
    final JButton bPrev = new JButton();
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JComboBox cmbFilterKind;
    private LinkButton expandCriteriaButton;
    final JCheckBox fileInfoCheckBox = new JCheckBox();
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JLabel lblFilter;
    private JLabel lblFilterContains;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;
    private JTextField txtFilter;

    public SearchHistoryPanel(File[] roots, SearchCriteriaPanel criteria) {
        this.roots = roots;
        this.repositoryUrl = null;
        this.criteria = criteria;
        this.diffViewFactory = new SearchHistoryTopComponent.DiffResultsViewFactory();
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.initializeFilter();
        this.filterTimer = new Timer(500, this);
        this.filterTimer.setRepeats(false);
        this.filterTimer.stop();
        this.aquaBackgroundWorkaround();
        this.setupComponents();
        this.refreshComponents(true);
    }

    public SearchHistoryPanel(SVNUrl repositoryUrl, File localRoot, SearchCriteriaPanel criteria) {
        this.repositoryUrl = repositoryUrl;
        this.roots = new File[]{localRoot};
        this.criteria = criteria;
        this.diffViewFactory = new SearchHistoryTopComponent.DiffResultsViewFactory();
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.initializeFilter();
        this.filterTimer = new Timer(500, this);
        this.filterTimer.stop();
        this.aquaBackgroundWorkaround();
        this.setupComponents();
        this.refreshComponents(true);
    }

    private void aquaBackgroundWorkaround() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jToolBar1.setBackground(color);
            this.resultsPanel.setBackground(color);
            this.searchCriteriaPanel.setBackground(color);
            this.criteria.setBackground(color);
        }
    }

    public void setDiffResultsViewFactory(SearchHistoryTopComponent.DiffResultsViewFactory fac) {
        if (fac != null) {
            this.diffViewFactory = fac;
        }
    }

    void setSearchCriteria(boolean showCriteria) {
        this.criteriaVisible = showCriteria;
        this.refreshComponents(false);
    }

    private void enableFilters(boolean enabled) {
        this.lblFilter.setEnabled(enabled);
        this.cmbFilterKind.setEnabled(enabled);
        this.lblFilterContains.setEnabled(enabled);
        this.txtFilter.setEnabled(enabled);
    }

    private void setupComponents() {
        this.searchCriteriaPanel.add(this.criteria);
        this.searchAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.search();
            }
        };
        this.searchCriteriaPanel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.searchCriteriaPanel.getActionMap().put("search", this.searchAction);
        this.bSearch.setAction(this.searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension d1 = this.tbSummary.getPreferredSize();
        Dimension d2 = this.tbDiff.getPreferredSize();
        if (d1.width > d2.width) {
            this.tbDiff.setPreferredSize(d1);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.criteria.tfFrom.getDocument().addDocumentListener(this);
        this.criteria.tfTo.getDocument().addDocumentListener(this);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
        this.fileInfoCheckBox.setSelected(SvnModuleConfig.getDefault().getShowFileAllInfo());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean refreshResults) {
        if (refreshResults) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
            } else if (this.tbSummary.isSelected()) {
                if (this.summaryView == null) {
                    this.logEntries = this.createLogEntries(this.results);
                    this.summaryView = new SummaryView(this, this.logEntries, this.kenaiUserMap);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
                this.summaryView.requestFocusInWindow();
            } else {
                if (this.diffView == null) {
                    this.diffView = this.diffViewFactory.createDiffResultsView(this, this.filter(this.results));
                }
                this.resultsPanel.add(this.diffView.getComponent());
                if (this.selectFirstRevision) {
                    this.selectFirstRevision();
                }
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.expandCriteriaButton.setIcon(this.criteriaVisible ? ICON_EXPANDED : ICON_COLLAPSED);
        this.fileInfoCheckBox.setEnabled(this.tbSummary.isSelected());
        this.enableFilters(this.results != null);
        this.revalidate();
        this.repaint();
    }

    private void selectFirstRevision() {
        if (this.diffView != null && this.results != null && !this.results.isEmpty()) {
            this.diffView.select(this.results.get(0));
        }
    }

    void setResults(List<RepositoryRevision> newResults, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap, int limit) {
        this.setResults(newResults, kenaiUserMap, false, limit);
    }

    private void setResults(List<RepositoryRevision> newResults, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap, boolean searching, int limit) {
        this.results = newResults;
        this.kenaiUserMap = kenaiUserMap;
        this.searchInProgress = searching;
        this.showingResults = limit;
        if (newResults != null && newResults.size() < limit) {
            this.showingResults = -1;
        }
        this.summaryView = null;
        this.diffView = null;
        this.refreshComponents(true);
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public SVNUrl getSearchRepositoryRootUrl() throws SVNClientException {
        if (this.repositoryUrl != null) {
            return this.repositoryUrl;
        }
        return SvnUtils.getRepositoryRootUrl(this.roots[0]);
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    boolean isShowInfo() {
        return this.fileInfoCheckBox.isSelected();
    }

    private synchronized void search() {
        this.cancelBackgroundTasks();
        this.setResults(null, null, true, -1);
        this.currentSearch = new SearchExecutor(this);
        this.currentSearch.start();
    }

    void windowClosed() {
        this.cancelBackgroundTasks();
        if (this.diffView != null) {
            this.diffView.cancelBackgroundTasks();
        }
    }

    void cancelBackgroundTasks() {
        if (this.currentSearch != null) {
            this.currentSearch.cancel();
        }
        if (this.currentAdditionalSearch != null) {
            this.currentAdditionalSearch.cancel();
        }
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(final RepositoryRevision.Event revision) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SearchHistoryPanel.this.tbDiff.setSelected(true);
                SearchHistoryPanel.this.refreshComponents(true);
                SearchHistoryPanel.this.diffView.select(revision);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public void showDiff(final RepositoryRevision container) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SearchHistoryPanel.this.tbDiff.setSelected(true);
                SearchHistoryPanel.this.refreshComponents(true);
                SearchHistoryPanel.this.diffView.select(container);
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public Collection getSetups() {
        if (this.results == null) {
            return Collections.EMPTY_SET;
        }
        if (this.tbDiff.isSelected()) {
            return this.diffView.getSetups();
        }
        return this.summaryView.getSetups();
    }

    Collection<Setup> getSetups(RepositoryRevision[] revisions, RepositoryRevision.Event[] events) {
        long rev;
        long fromRevision = Long.MAX_VALUE;
        long toRevision = Long.MIN_VALUE;
        HashSet<File> filesToDiff = new HashSet<File>();
        for (RepositoryRevision revision : revisions) {
            rev = revision.getLog().getRevision().getNumber();
            if (rev > toRevision) {
                toRevision = rev;
            }
            if (rev < fromRevision) {
                fromRevision = rev;
            }
            List<RepositoryRevision.Event> evs = revision.getEvents();
            for (RepositoryRevision.Event event : evs) {
                File file = event.getFile();
                if (file == null) continue;
                filesToDiff.add(file);
            }
        }
        for (RepositoryRevision.Event event : events) {
            rev = event.getLogInfoHeader().getLog().getRevision().getNumber();
            if (rev > toRevision) {
                toRevision = rev;
            }
            if (rev < fromRevision) {
                fromRevision = rev;
            }
            if (event.getFile() == null) continue;
            filesToDiff.add(event.getFile());
        }
        ArrayList<Setup> setups = new ArrayList<Setup>();
        for (File file : filesToDiff) {
            Setup setup = new Setup(file, Long.toString(fromRevision - 1L), Long.toString(toRevision), false);
            setups.add(setup);
        }
        return setups;
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    public static int compareRevisions(String r1, String r2) {
        int n2;
        int n1;
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return st2.hasMoreTokens() ? -1 : 0;
            }
            if (st2.hasMoreTokens()) continue;
            return st1.hasMoreTokens() ? 1 : 0;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n2 - n1;
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.tbDiff.setSelected(true);
        this.selectFirstRevision = selectFirstRevision;
        this.selectFirstRevision();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JToolBar.Separator();
        this.lblFilter = new JLabel();
        this.cmbFilterKind = new JComboBox();
        this.lblFilterContains = new JLabel();
        this.txtFilter = new JTextField();
        this.resultsPanel = new JPanel();
        this.expandCriteriaButton = new LinkButton();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/history/Bundle");
        this.bSearch.setToolTipText(bundle.getString("TT_Search"));
        this.jToolBar1.setLayout(new BoxLayout(this.jToolBar1, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)bundle.getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(bundle.getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)bundle.getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(bundle.getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSN_NextDifference"));
        this.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSN_PrevDifference"));
        this.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryPanel.class, (String)"ACSD_PrevDifference"));
        this.jToolBar1.add(this.jSeparator3);
        Mnemonics.setLocalizedText((AbstractButton)this.fileInfoCheckBox, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistoryPanel_AllInfo"));
        this.fileInfoCheckBox.setOpaque(false);
        this.fileInfoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.fileInfoCheckBoxActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.fileInfoCheckBox);
        Mnemonics.setLocalizedText((JLabel)this.lblFilter, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"filterLabel.text"));
        this.lblFilter.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jToolBar1.add(this.lblFilter);
        this.cmbFilterKind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.cmbFilterKindActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmbFilterKind);
        Mnemonics.setLocalizedText((JLabel)this.lblFilterContains, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"containsLabel"));
        this.lblFilterContains.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jToolBar1.add(this.lblFilterContains);
        this.jToolBar1.add(this.txtFilter);
        this.resultsPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.expandCriteriaButton, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_expandCriteriaButton.text"));
        this.expandCriteriaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.expandCriteriaButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar1, -2, 504, Short.MAX_VALUE).addComponent(this.searchCriteriaPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.bSearch)).addGroup(layout.createSequentialGroup().addComponent((Component)this.expandCriteriaButton, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsPanel, -1, 288, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.expandCriteriaButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchCriteriaPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addContainerGap()));
    }

    private void onViewToggle(ActionEvent evt) {
        this.refreshComponents(true);
    }

    private void expandCriteriaButtonActionPerformed(ActionEvent evt) {
        this.searchCriteriaPanel.setVisible(!this.searchCriteriaPanel.isVisible());
        this.expandCriteriaButton.setIcon(this.searchCriteriaPanel.isVisible() ? ICON_EXPANDED : ICON_COLLAPSED);
        this.criteriaVisible = this.searchCriteriaPanel.isVisible();
    }

    private void fileInfoCheckBoxActionPerformed(ActionEvent evt) {
        SvnModuleConfig.getDefault().setShowFileAllInfo(this.fileInfoCheckBox.isSelected());
        if (this.summaryView != null) {
            this.summaryView.refreshView();
        }
    }

    private void cmbFilterKindActionPerformed(ActionEvent evt) {
        boolean filterCritVisible = this.cmbFilterKind.getSelectedItem() != FilterKind.ALL;
        this.lblFilterContains.setVisible(filterCritVisible);
        this.txtFilter.setVisible(filterCritVisible);
        if (filterCritVisible) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SearchHistoryPanel.this.cmbFilterKind.isPopupVisible()) {
                        SearchHistoryPanel.this.txtFilter.requestFocusInWindow();
                    }
                }
            });
        }
        if (this.filterTimer != null && !this.txtFilter.getText().trim().isEmpty()) {
            this.filterTimer.restart();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e);
    }

    private void documentChanged(DocumentEvent e) {
        if (e.getDocument() == this.txtFilter.getDocument()) {
            this.filterTimer.restart();
        } else {
            this.validateUserInput();
        }
    }

    private void validateUserInput() {
        SVNRevision from = this.criteria.getFrom();
        if (from == null && this.criteria.tfFrom.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        SVNRevision to = this.criteria.getTo();
        if (to == null && this.criteria.tfTo.getText().trim().length() > 0) {
            this.bSearch.setEnabled(false);
            return;
        }
        this.bSearch.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.filterTimer) {
            if (this.summaryView != null) {
                this.summaryView.refreshView();
            }
            if (this.diffView != null) {
                this.diffView.refreshResults(this.filter(this.results));
            }
        }
    }

    List<RepositoryRevision> getResults() {
        return this.results;
    }

    boolean hasMoreResults() {
        return this.showingResults > -1;
    }

    static Map<String, VCSKenaiAccessor.KenaiUser> createKenaiUsersMap(List<RepositoryRevision> results) {
        HashMap<String, Object> kenaiUsersMap = new HashMap<String, VCSKenaiAccessor.KenaiUser>();
        if (!results.isEmpty()) {
            boolean isKenaiRepository;
            SVNUrl url = results.get(0).getRepositoryRootUrl();
            boolean bl = isKenaiRepository = url != null && SvnKenaiAccessor.getInstance().isKenai(url.toString());
            if (isKenaiRepository) {
                kenaiUsersMap = new HashMap();
                for (RepositoryRevision repositoryRevision : results) {
                    VCSKenaiAccessor.KenaiUser kenaiUser;
                    String author = repositoryRevision.getLog().getAuthor();
                    if (author == null || author.isEmpty() || kenaiUsersMap.containsKey(author) || (kenaiUser = SvnKenaiAccessor.getInstance().forName(author, url.toString())) == null) continue;
                    kenaiUsersMap.put(author, kenaiUser);
                }
            }
        }
        return kenaiUsersMap;
    }

    void getMoreRevisions(PropertyChangeListener callback, int count) {
        if (this.currentSearch == null) {
            throw new IllegalStateException("No search task active");
        }
        if (this.currentAdditionalSearch != null) {
            this.currentAdditionalSearch.cancel();
        }
        count = count < 0 || this.showingResults < 0 ? 0 : (count += this.showingResults);
        try {
            this.currentAdditionalSearch = new Search(this.getSearchRepositoryRootUrl(), count);
            this.currentAdditionalSearch.start(Subversion.getInstance().getParallelRequestProcessor(), this.currentAdditionalSearch.repoUrl, NbBundle.getMessage(SearchHistoryPanel.class, (String)"MSG_SearchHistoryPanel.GettingMoreRevisions"));
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
        }
    }

    Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> getSearchHighlights() {
        String filterText = this.txtFilter.getText().trim();
        Object selectedFilterKind = this.cmbFilterKind.getSelectedItem();
        if (selectedFilterKind == FilterKind.ALL || filterText.isEmpty() || !(selectedFilterKind instanceof FilterKind)) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AbstractSummaryView.SummaryViewMaster.SearchHighlight(((FilterKind)((Object)selectedFilterKind)).kind, filterText));
    }

    private void initializeFilter() {
        DefaultComboBoxModel<FilterKind> filterModel = new DefaultComboBoxModel<FilterKind>();
        filterModel.addElement(FilterKind.ALL);
        filterModel.addElement(FilterKind.ID);
        filterModel.addElement(FilterKind.MESSAGE);
        filterModel.addElement(FilterKind.USER);
        this.cmbFilterKind.setModel(filterModel);
        this.cmbFilterKind.setSelectedItem((Object)FilterKind.ALL);
        this.txtFilter.getDocument().addDocumentListener(this);
    }

    private List<RepositoryRevision> filter(List<RepositoryRevision> results) {
        ArrayList<RepositoryRevision> newResults = new ArrayList<RepositoryRevision>(results.size());
        for (RepositoryRevision rev : results) {
            if (!this.applyFilter(rev)) continue;
            newResults.add(rev);
        }
        return newResults;
    }

    boolean applyFilter(RepositoryRevision rev) {
        boolean visible = true;
        String filterText = this.txtFilter.getText().trim().toLowerCase();
        Object selectedFilterKind = this.cmbFilterKind.getSelectedItem();
        if (selectedFilterKind != FilterKind.ALL && !filterText.isEmpty()) {
            if (selectedFilterKind == FilterKind.MESSAGE) {
                visible = rev.getLog().getMessage().toLowerCase().contains(filterText);
            } else if (selectedFilterKind == FilterKind.USER) {
                visible = rev.getLog().getAuthor().toLowerCase().contains(filterText);
            } else if (selectedFilterKind == FilterKind.ID) {
                visible = rev.getLog().getRevision().toString().contains(filterText);
            }
        }
        return visible;
    }

    List<SummaryView.SvnLogEntry> createLogEntries(List<RepositoryRevision> results) {
        LinkedList<SummaryView.SvnLogEntry> ret = new LinkedList<SummaryView.SvnLogEntry>();
        for (RepositoryRevision repositoryRevision : results) {
            ret.add(new SummaryView.SvnLogEntry(repositoryRevision, this));
        }
        return ret;
    }

    private class Search
    extends SvnProgressSupport {
        private final int count;
        private final SearchExecutor executor;
        private final SVNUrl repoUrl;

        private Search(SVNUrl repoUrl, int count) {
            this.repoUrl = repoUrl;
            this.count = count;
            this.executor = SearchHistoryPanel.this.currentSearch;
        }

        @Override
        protected void perform() {
            final List<RepositoryRevision> newResults = this.executor.search(this.repoUrl, this.count, this);
            final Map<String, VCSKenaiAccessor.KenaiUser> additionalUsersMap = SearchHistoryPanel.createKenaiUsersMap(newResults);
            if (!this.isCanceled()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Search.this.isCanceled()) {
                            HashSet<SVNRevision.Number> visibleRevisions = new HashSet<SVNRevision.Number>(SearchHistoryPanel.this.results.size());
                            for (RepositoryRevision rev : SearchHistoryPanel.this.results) {
                                visibleRevisions.add(rev.getLog().getRevision());
                            }
                            ArrayList<RepositoryRevision> toAdd = new ArrayList<RepositoryRevision>(newResults.size());
                            for (RepositoryRevision rev : SearchHistoryPanel.this.filter(newResults)) {
                                if (visibleRevisions.contains(rev.getLog().getRevision())) continue;
                                toAdd.add(rev);
                            }
                            SearchHistoryPanel.this.results.addAll(toAdd);
                            if (Search.this.count == 0) {
                                SearchHistoryPanel.this.showingResults = -1;
                            } else {
                                SearchHistoryPanel.this.showingResults = Search.this.count;
                            }
                            if (SearchHistoryPanel.this.showingResults > newResults.size()) {
                                SearchHistoryPanel.this.showingResults = -1;
                            }
                            SearchHistoryPanel.this.logEntries = SearchHistoryPanel.this.createLogEntries(SearchHistoryPanel.this.results);
                            SearchHistoryPanel.this.kenaiUserMap.putAll(additionalUsersMap);
                            if (SearchHistoryPanel.this.diffView != null) {
                                SearchHistoryPanel.this.diffView.refreshResults(SearchHistoryPanel.this.results);
                            }
                            if (SearchHistoryPanel.this.summaryView != null) {
                                SearchHistoryPanel.this.summaryView.entriesChanged(SearchHistoryPanel.this.logEntries);
                            }
                        }
                    }
                });
            }
        }
    }

    static enum FilterKind {
        ALL(null, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.All")),
        MESSAGE(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.Message")),
        USER(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.User")),
        ID(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.REVISION, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.Commit")),
        FILE(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.FILE, NbBundle.getMessage(SearchHistoryPanel.class, (String)"Filter.File"));

        private String label;
        private AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind kind;

        private FilterKind(AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind kind, String label) {
            this.kind = kind;
            this.label = label;
        }

        public final String toString() {
            return this.label;
        }
    }
}

