/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;

public abstract class YamlStructureItem
implements StructureItem,
ElementHandle {
    private static final Logger LOGGER = Logger.getLogger(YamlStructureItem.class.getName());
    private final NodeType type;
    private final FileObject fileObject;
    private final long startMark;
    private long endMark;

    public YamlStructureItem(NodeType type, FileObject fileObject, long startMark, long endMark) {
        this.type = type;
        this.fileObject = fileObject;
        this.startMark = startMark;
        this.endMark = endMark;
    }

    public NodeType getType() {
        return this.type;
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        try {
            return XMLUtil.toElementContent((String)this.getName());
        }
        catch (CharConversionException cce) {
            LOGGER.log(Level.FINE, "NAME:" + this.getName(), cce);
            return this.getName();
        }
    }

    public ElementHandle getElementHandle() {
        return this;
    }

    public ElementKind getKind() {
        return ElementKind.ATTRIBUTE;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return this.getNestedItems().isEmpty();
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public long getPosition() {
        return this.startMark;
    }

    public long getEndPosition() {
        return this.endMark;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return new OffsetRange((int)this.startMark, (int)this.endMark);
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public String getIn() {
        return null;
    }

    public String getMimeType() {
        return "text/x-yaml";
    }

    public boolean signatureEquals(ElementHandle handle) {
        if (handle instanceof YamlStructureItem) {
            return this.equals(handle);
        }
        return false;
    }

    public String toString() {
        return "" + this.getPosition() + ": " + this.getName();
    }

    void setEndMark(long end) {
        this.endMark = end;
    }

    public static final class MapEntry
    extends YamlStructureItem {
        final YamlStructureItem keyItem;
        final YamlStructureItem valueItem;

        public MapEntry(YamlStructureItem keyItem, YamlStructureItem valueItem) {
            super(NodeType.MAPPING, keyItem.fileObject, keyItem.startMark, valueItem.endMark);
            this.keyItem = keyItem;
            this.valueItem = valueItem;
        }

        public String getName() {
            return this.keyItem.getName();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.valueItem.getNestedItems();
        }

        @Override
        public long getEndPosition() {
            return this.valueItem.getEndPosition();
        }
    }

    public static final class Collection
    extends YamlStructureItem {
        private final List<YamlStructureItem> children = new ArrayList<YamlStructureItem>();

        public Collection(NodeType type, FileObject fileObject, long startMark) {
            super(type, fileObject, startMark, startMark);
        }

        public String getName() {
            return "list item";
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public List<? extends YamlStructureItem> getChildren() {
            return this.children;
        }

        public void add(YamlStructureItem item) {
            this.setEndMark(item.getEndPosition());
            this.children.add(item);
        }
    }

    public static final class Simple
    extends YamlStructureItem {
        final String name;

        public Simple(NodeType type, FileObject fileObject, String name, long startMark, long endMark) {
            super(type, fileObject, startMark, endMark);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }
    }

    public static enum NodeType {
        MAP,
        SEQUENCE,
        MAPPING,
        SCALAR,
        ALIAS;

    }
}

