/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;
import org.netbeans.modules.languages.hcl.grammar.HCLParserBaseListener;
import org.netbeans.modules.parsing.api.Snapshot;

public class ASTBuilderListener
extends HCLParserBaseListener {
    final HCLDocument document = new HCLDocument();
    final SourceRef references;
    private HCLContainer current = this.document;

    public ASTBuilderListener(Snapshot source) {
        this.references = new SourceRef(source);
    }

    public HCLDocument getDocument() {
        return this.document;
    }

    public SourceRef getReferences() {
        return this.references;
    }

    private void addReference(HCLElement e, Token token) {
        this.references.add(e, token.getStartIndex(), token.getStopIndex() + 1);
    }

    private void addReference(HCLElement e, ParserRuleContext ctx) {
        this.references.add(e, ctx.start.getStartIndex(), ctx.stop.getStopIndex() + 1);
    }

    @Override
    public void exitBlock(HCLParser.BlockContext ctx) {
        HCLIdentifier id;
        HCLBlock block = (HCLBlock)this.current;
        ArrayList<HCLIdentifier.SimpleId> decl = new ArrayList<HCLIdentifier.SimpleId>(4);
        for (TerminalNode terminalNode : ctx.IDENTIFIER()) {
            Token token = terminalNode.getSymbol();
            id = new HCLIdentifier.SimpleId(block, token.getText());
            this.addReference((HCLElement)id, token);
            decl.add((HCLIdentifier.SimpleId)id);
        }
        for (HCLParser.StringLitContext stringLitContext : ctx.stringLit()) {
            String sid = stringLitContext.getText();
            if (sid.length() <= 1) continue;
            sid = sid.substring(1, sid.length() - (sid.endsWith("\"") ? 1 : 0));
            id = new HCLIdentifier.StringId(block, sid);
            this.addReference((HCLElement)id, stringLitContext);
            decl.add((HCLIdentifier.SimpleId)id);
        }
        block.setDeclaration(this.references.sortBySource(decl));
        this.current = this.current.getContainer();
        this.current.add(block);
        this.addReference((HCLElement)block, ctx);
    }

    @Override
    public void exitBody(HCLParser.BodyContext ctx) {
        for (HCLParser.AttributeContext actx : ctx.attribute()) {
            HCLAttribute attr = new HCLAttribute(this.current);
            attr.name = new HCLIdentifier.SimpleId(attr, actx.IDENTIFIER().getText());
            this.addReference((HCLElement)attr.name, actx.IDENTIFIER().getSymbol());
            this.addReference((HCLElement)attr, actx);
            this.current.add(attr);
        }
    }

    @Override
    public void enterBlock(HCLParser.BlockContext ctx) {
        this.current = new HCLBlock(this.current);
    }
}

