/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.html;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.CustomAttribute;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.html.RequireJsAttributeCompletionItem;
import org.netbeans.modules.javascript2.requirejs.html.RequireJsCustomAttribute;
import org.netbeans.modules.javascript2.requirejs.html.RequireJsFileReferenceCompletion;
import org.netbeans.modules.javascript2.requirejs.html.RequireJsHtmlCompletionItem;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;

public class RequireJsHtmlExtension
extends HtmlExtension {
    private static final String DATAMAIN = "data-main";
    private static final String SCRIPT = "script";
    private static final ValueCompletion<HtmlCompletionItem> FILE_NAME_SUPPORT = new FilenameSupport();

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        Element element = context.getCurrentNode();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        if (element != null) {
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    String name = ot.unqualifiedName().toString();
                    if (!SCRIPT.equalsIgnoreCase(name)) break;
                    Collection<CustomAttribute> customAttributes = RequireJsCustomAttribute.getCustomAttributes();
                    for (CustomAttribute ca : customAttributes) {
                        if (!LexerUtils.startsWith((CharSequence)ca.getName(), (CharSequence)context.getPrefix(), (boolean)true, (boolean)false)) continue;
                        items.add((CompletionItem)new RequireJsAttributeCompletionItem(ca, context.getCCItemStartOffset()));
                    }
                    break;
                }
            }
        }
        return items;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext context) {
        FileObject fileObject;
        String attributeName = context.getAttributeName();
        if (attributeName.equals(DATAMAIN) && (fileObject = context.getResult().getSnapshot().getSource().getFileObject()) != null) {
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
            items.addAll(FILE_NAME_SUPPORT.getItems(fileObject, context.getCCItemStartOffset(), context.getPrefix()));
            return items;
        }
        return Collections.emptyList();
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        TokenSequence ts = Utils.getJoinedHtmlSequence((Document)doc, (int)caretOffset);
        if (ts == null) {
            return super.getReferenceSpan(doc, caretOffset);
        }
        ts.move(caretOffset);
        if (ts.moveNext()) {
            Token token = ts.token();
            int offset = ts.offset();
            if (this.getDataMainValue((TokenSequence<HTMLTokenId>)ts, caretOffset) != null) {
                return new OffsetRange(offset + 1, offset + token.length() - 1);
            }
        }
        return super.getReferenceSpan(doc, caretOffset);
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        FileObject fo;
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return super.findDeclaration(info, caretOffset);
        }
        TokenSequence ts = Utils.getJoinedHtmlSequence((TokenHierarchy)th, (int)caretOffset);
        if (ts == null) {
            return super.findDeclaration(info, caretOffset);
        }
        int eOffset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        String value = this.getDataMainValue((TokenSequence<HTMLTokenId>)ts, eOffset);
        if (value != null && (fo = info.getSnapshot().getSource().getFileObject()) != null) {
            String name = value.toLowerCase().endsWith(".js") ? value : value + ".js";
            FileObject targetFO = FSCompletionUtils.findFileObject(fo, name, true);
            if (targetFO != null) {
                return new DeclarationFinder.DeclarationLocation(targetFO, 0);
            }
            name = value + ".JS";
            targetFO = FSCompletionUtils.findFileObject(fo, name, true);
            if (targetFO != null) {
                return new DeclarationFinder.DeclarationLocation(targetFO, 0);
            }
            name = value + ".Js";
            targetFO = FSCompletionUtils.findFileObject(fo, name, true);
            if (targetFO != null) {
                return new DeclarationFinder.DeclarationLocation(targetFO, 0);
            }
        }
        return super.findDeclaration(info, caretOffset);
    }

    private String getDataMainValue(TokenSequence<HTMLTokenId> ts, int offset) {
        Token token;
        HTMLTokenId tokenId;
        ts.move(offset);
        if (ts.moveNext() && (tokenId = (HTMLTokenId)(token = ts.token()).id()) == HTMLTokenId.VALUE) {
            String value = token.text().toString();
            token = LexerUtils.followsToken(ts, Arrays.asList(HTMLTokenId.ARGUMENT), (boolean)true, (boolean)false, (TokenId[])new TokenId[]{HTMLTokenId.OPERATOR, HTMLTokenId.WS, HTMLTokenId.BLOCK_COMMENT});
            if (token != null && token.id() == HTMLTokenId.ARGUMENT && DATAMAIN.equals(token.text().toString())) {
                return value.substring(1, value.length() - 1);
            }
        }
        return null;
    }

    private static class FilenameSupport
    extends RequireJsFileReferenceCompletion<HtmlCompletionItem> {
        private FilenameSupport() {
        }

        public HtmlCompletionItem createFileItem(FileObject file, int anchor) {
            return RequireJsHtmlCompletionItem.createFileCompletionItem(file, anchor);
        }

        public HtmlCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createGoUpFileCompletionItem((int)anchor, (Color)color, (ImageIcon)icon);
        }
    }
}

