/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.search.project.SearchInfoHelper;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.SubTreeSearchOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

abstract class AbstractProjectSearchScope
extends SearchScopeDefinition
implements PropertyChangeListener {
    private final String interestingProperty;
    private PropertyChangeListener openProjectsWeakListener;

    protected AbstractProjectSearchScope(String interestingProperty) {
        this.interestingProperty = interestingProperty;
        OpenProjects openProjects = OpenProjects.getDefault();
        this.openProjectsWeakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)openProjects);
        openProjects.addPropertyChangeListener(this.openProjectsWeakListener);
    }

    public void clean() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsWeakListener);
        this.openProjectsWeakListener = null;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        if (this.interestingProperty.equals(e.getPropertyName())) {
            this.notifyListeners();
        }
    }

    static SearchInfo createSingleProjectSearchInfo(Project project) {
        SearchInfo prjSearchInfo = SearchInfoHelper.getSearchInfoForLookup(project.getLookup());
        if (prjSearchInfo != null) {
            return prjSearchInfo;
        }
        return AbstractProjectSearchScope.createDefaultProjectSearchInfo(project);
    }

    static SearchInfo createDefaultProjectSearchInfo(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        FileObject base = project.getProjectDirectory();
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        if (base != null) {
            roots.add(base);
        }
        for (SourceGroup sg : sourceGroups) {
            FileObject dir = sg.getRootFolder();
            if (dir == null || base != null && AbstractProjectSearchScope.isUnderBase(base, dir)) continue;
            roots.add(dir);
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        for (int i = 0; i < roots.size(); ++i) {
            rootArray[i] = (FileObject)roots.get(i);
        }
        SubTreeSearchOptions stso = (SubTreeSearchOptions)project.getLookup().lookup(SubTreeSearchOptions.class);
        if (stso == null) {
            return SearchInfoUtils.createSearchInfoForRoots((FileObject[])rootArray);
        }
        return SearchInfoUtils.createSearchInfoForRoots((FileObject[])rootArray, (boolean)false, (SearchFilterDefinition[])SearchInfoHelper.subTreeFilters(stso));
    }

    private static boolean isUnderBase(FileObject base, FileObject dir) {
        return dir == base || FileUtil.isParentOf((FileObject)base, (FileObject)dir);
    }
}

