/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private Map<Class<?>, Lookup> classLookups = new HashMap();
    private Map<List<String>, Lookup> pathsLookups = new HashMap<List<String>, Lookup>();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class<?> clazz) {
        String string = this.LOCK;
        synchronized (string) {
            Lookup lookup = this.classLookups.get(clazz);
            if (lookup == null) {
                lookup = this.createLookup(clazz);
                this.classLookups.put(clazz, lookup);
            }
            return lookup;
        }
    }

    private Lookup createLookup(Class<?> forClass) {
        Lookup lookup;
        MimeLocation loc = forClass.getAnnotation(MimeLocation.class);
        if (loc == null) {
            loc = new MimeLocation(){

                public String subfolderName() {
                    return null;
                }

                public Class<? extends InstanceProvider> instanceProviderClass() {
                    return null;
                }

                public Class<? extends Annotation> annotationType() {
                    return MimeLocation.class;
                }
            };
        }
        List<String> paths = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, loc.subfolderName());
        if (loc.instanceProviderClass() != null && loc.instanceProviderClass() != InstanceProvider.class) {
            try {
                lookup = this.getLookupForProvider(paths, (InstanceProvider)loc.instanceProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                lookup = Lookup.EMPTY;
            }
        } else {
            lookup = this.getLookupForPaths(paths);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List<String> paths) {
        Object lookup = this.pathsLookups.get(paths);
        if (lookup == null) {
            lookup = new FolderPathLookup(paths.toArray(new String[0]));
            this.pathsLookups.put(paths, (Lookup)lookup);
        }
        return lookup;
    }

    private Lookup getLookupForProvider(List<String> paths, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(paths.toArray(new String[0]), instanceProvider);
    }

    private static List<String> computePaths(MimePath mimePath, String prefixPath, String suffixPath) {
        try {
            Method m = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            m.setAccessible(true);
            List paths = (List)m.invoke((Object)mimePath, prefixPath, suffixPath);
            return paths;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", e);
            StringBuilder sb = new StringBuilder();
            if (prefixPath != null && prefixPath.length() > 0) {
                sb.append(prefixPath);
            }
            if (mimePath.size() > 0) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(mimePath.getPath());
            }
            if (suffixPath != null && suffixPath.length() > 0) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(suffixPath);
            }
            return Collections.singletonList(sb.toString());
        }
    }
}

