/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.BorderLayout;
import java.io.Externalizable;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserPanel;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(persistenceType=0, preferredID="GitRepositories")
public class GitRepositoryTopComponent
extends TopComponent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private RepositoryBrowserPanel repositoryPanel;
    public static final String PREFERRED_ID = "GitRepositories";
    private static GitRepositoryTopComponent instance;

    public GitRepositoryTopComponent() {
        this.putClientProperty("SlidingName", NbBundle.getMessage(GitRepositoryTopComponent.class, (String)"CTL_Repository_TopComponent_Title"));
        this.setName(NbBundle.getMessage(GitRepositoryTopComponent.class, (String)"CTL_Repository_TopComponent_Title"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/git/resources/icons/versioning-view.png"));
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GitRepositoryTopComponent.class, (String)"CTL_Repository_TopComponent_Title"));
        this.repositoryPanel = new RepositoryBrowserPanel();
        this.add(this.repositoryPanel, "Center");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected void componentOpened() {
        super.componentOpened();
        this.setName(NbBundle.getMessage(GitRepositoryTopComponent.class, (String)"CTL_Repository_TopComponent_Title"));
    }

    public static synchronized GitRepositoryTopComponent getDefault() {
        if (instance == null) {
            instance = new GitRepositoryTopComponent();
        }
        return instance;
    }

    public static synchronized GitRepositoryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Git.LOG.log(Level.FINE, "Cannot find GitRepositories component. It will not be located properly in the window system.");
            return GitRepositoryTopComponent.getDefault();
        }
        if (win instanceof GitRepositoryTopComponent) {
            return (GitRepositoryTopComponent)win;
        }
        Git.LOG.log(Level.FINE, "There seem to be multiple components with the 'GitRepositories' ID. That is a potential source of errors and unexpected behavior.");
        return GitRepositoryTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void requestActive() {
        super.requestActive();
        this.repositoryPanel.requestFocusInWindow();
    }

    void selectRepository(File repository) {
        this.repositoryPanel.selectRepository(repository);
    }
}

