/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.io.IOException;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssProjectSupport {
    private static final WeakHashMap<Project, CssProjectSupport> INSTANCIES = new WeakHashMap();
    private Project project;
    private CssIndex index;

    public static CssProjectSupport findFor(Source source) {
        FileObject fo = source.getFileObject();
        if (fo == null) {
            return null;
        }
        return CssProjectSupport.findFor(fo);
    }

    public static CssProjectSupport findFor(Document doc) {
        return CssProjectSupport.findFor(DataLoadersBridge.getDefault().getFileObject(doc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CssProjectSupport findFor(FileObject fo) {
        try {
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p == null) {
                return null;
            }
            WeakHashMap<Project, CssProjectSupport> weakHashMap = INSTANCIES;
            synchronized (weakHashMap) {
                CssProjectSupport instance = INSTANCIES.get(p);
                if (instance == null) {
                    instance = new CssProjectSupport(p);
                    INSTANCIES.put(p, instance);
                }
                return instance;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public CssProjectSupport(Project project) throws IOException {
        this.project = project;
        this.index = CssIndex.create(project);
    }

    public CssIndex getIndex() {
        return this.index;
    }

    public Project getProject() {
        return this.project;
    }
}

