/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.netbeans.modules.project.dependency.spi.ProjectArtifactsImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class MavenArtifactsImplementation
implements ProjectArtifactsImplementation<Res> {
    private static final Logger LOG = Logger.getLogger(ProjectArtifactsImplementation.class.getName());
    private final Project project;
    private static final RequestProcessor MAVEN_ARTIFACTS_RP = new RequestProcessor(MavenArtifactsImplementation.class);

    public MavenArtifactsImplementation(Project project) {
        this.project = project;
    }

    public Res evaluate(ProjectArtifactsQuery.Filter query) {
        ProjectActionContext ctx = query.getBuildContext();
        if (ctx != null) {
            if (ctx.getProjectAction() != null) {
                switch (ctx.getProjectAction()) {
                    case "build": 
                    case "rebuild": 
                    case "run": 
                    case "debug": 
                    case "run.single": 
                    case "debug.single": 
                    case "test": 
                    case "test.single": 
                    case "debug.stepinto": {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (ctx.getProfiles() != null && !ctx.getProfiles().isEmpty()) {
                LOG.log(Level.WARNING, "Custom action profiles are not supported yet by Maven projects");
            }
            if (ctx.getConfiguration() != null) {
                LOG.log(Level.WARNING, "Custom action configurations are not supported yet by Maven projects");
            }
            if (ctx.getProperties() != null && !ctx.getProperties().isEmpty()) {
                LOG.log(Level.WARNING, "Custom action properties are not supported yet by Maven projects");
            }
        }
        return new Res(this.project, query);
    }

    public Project findProject(Res r) {
        return r.getProject();
    }

    public List<ArtifactSpec> findArtifacts(Res r) {
        return r.getArtifacts();
    }

    public Collection<ArtifactSpec> findExcludedArtifacts(Res r) {
        return r.getExcludedArtifacts();
    }

    public void handleChangeListener(Res r, ChangeListener l, boolean add) {
        if (add) {
            r.addChangeListener(l);
        } else {
            r.removeChangeListener(l);
        }
    }

    public boolean computeSupportsChanges(Res r) {
        return r.supportsChanges();
    }

    static class Res
    implements PropertyChangeListener {
        private final Project project;
        private final ProjectArtifactsQuery.Filter filter;
        private List<ArtifactSpec> artifacts;
        private List<ChangeListener> listeners;
        private RequestProcessor.Task refreshTask;

        public Res(Project project, ProjectArtifactsQuery.Filter filter) {
            this.project = project;
            this.filter = filter;
        }

        public Project getProject() {
            return this.project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ArtifactSpec> getArtifacts() {
            Res res = this;
            synchronized (res) {
                if (this.artifacts != null) {
                    return this.artifacts;
                }
            }
            NbMavenProject mvnProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            MavenQuery q = new MavenQuery(this.project, mvnProject, this.filter);
            q.run();
            Res res2 = this;
            synchronized (res2) {
                if (this.artifacts == null) {
                    this.artifacts = q.specs;
                }
            }
            return q.specs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(List<ArtifactSpec> copy, RequestProcessor.Task self) {
            ChangeListener[] ll;
            NbMavenProject mvnProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            MavenQuery q = new MavenQuery(this.project, mvnProject, this.filter);
            q.run();
            Res res = this;
            synchronized (res) {
                if (this.artifacts == null) {
                    this.artifacts = q.specs;
                    return;
                }
                if (this.artifacts.equals(q.specs)) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[0]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }

        public Collection<ArtifactSpec> getExcludedArtifacts() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            Res res = this;
            synchronized (res) {
                if (this.listeners == null) {
                    NbMavenProject mvnProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
                    mvnProject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (String)"MavenProject", (Object)mvnProject));
                }
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            Res res = this;
            synchronized (res) {
                if (this.listeners == null) {
                    return;
                }
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"MavenProject".equals(evt.getPropertyName())) {
                return;
            }
            Res res = this;
            synchronized (res) {
                this.artifacts = null;
                if (this.listeners == null || this.listeners.isEmpty()) {
                    return;
                }
                if (this.refreshTask != null) {
                    this.refreshTask.cancel();
                }
                ArrayList<ArtifactSpec> copy = this.artifacts == null ? Collections.emptyList() : new ArrayList<ArtifactSpec>(this.artifacts);
                RequestProcessor.Task[] arr = new RequestProcessor.Task[1];
                this.artifacts = null;
                arr[0] = this.refreshTask = MAVEN_ARTIFACTS_RP.create(() -> this.update(copy, arr[0]));
            }
        }

        public boolean supportsChanges() {
            return true;
        }
    }

    static class MavenQuery {
        final Project project;
        final NbMavenProject nbMavenProject;
        final ProjectArtifactsQuery.Filter filter;
        MavenProject evalProject;
        List<ArtifactSpec> specs;
        boolean skipDefaultOutput;

        public MavenQuery(Project project, NbMavenProject nbMavenProject, ProjectArtifactsQuery.Filter filter) {
            this.project = project;
            this.nbMavenProject = nbMavenProject;
            this.filter = filter;
        }

        void addArtifactSpec(ArtifactSpec spec) {
            if (this.specs.contains(spec)) {
                return;
            }
            this.specs.add(spec);
        }

        private void appendShadePluginOutput(MavenProject evalProject) {
            Plugin plugin = (Plugin)evalProject.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:maven-shade-plugin");
            if (plugin == null) {
                return;
            }
            for (PluginExecution exec : plugin.getExecutions()) {
                if (!exec.getGoals().contains("shade")) continue;
                ShadedEvaluator shadedEval = new ShadedEvaluator(evalProject, exec);
                shadedEval.process();
            }
        }

        private static String getValueOrNull(Xpp3Dom parent, String childName) {
            return MavenQuery.getChildValue(parent, childName, null);
        }

        private static String getChildValue(Xpp3Dom parent, String childName, String defValue) {
            Xpp3Dom child = null;
            if (parent != null) {
                child = parent.getChild(childName);
            }
            return child != null ? child.getValue() : defValue;
        }

        private void appendPluginOutput(MavenProject evalProject, String pluginId, String goal, String packagingAndType) {
            this.appendPluginOutput(evalProject, pluginId, goal, packagingAndType, packagingAndType, null, new String[0]);
        }

        private void appendPluginOutput(MavenProject evalProject, String pluginId, String goal, String type, String packaging, String defaultClassifier, String ... tags) {
            if (this.filter != null && (this.filter.getArtifactType() == null ? !evalProject.getPackaging().equals(packaging) : !this.filter.getArtifactType().equals(type) && !"<all>".equals(this.filter.getArtifactType()))) {
                return;
            }
            Artifact mA = evalProject.getArtifact();
            Model mdl = evalProject.getModel();
            Plugin plugin = (Plugin)evalProject.getBuild().getPluginsAsMap().get("org.apache.maven.plugins:" + pluginId);
            if (plugin == null) {
                return;
            }
            for (PluginExecution exec : plugin.getExecutions()) {
                String classifier;
                if (!exec.getGoals().contains(goal)) continue;
                Xpp3Dom dom = evalProject.getGoalConfiguration("org.apache.maven.plugins", pluginId, exec.getId(), goal);
                Xpp3Dom domClassifier = dom == null ? null : dom.getChild("classifier");
                Xpp3Dom domOutputDir = dom == null ? null : dom.getChild("outputDirectory");
                String string = classifier = domClassifier == null ? null : domClassifier.getValue();
                if (classifier == null) {
                    classifier = defaultClassifier;
                }
                if (this.filter != null && !"<any>".equals(this.filter.getClassifier()) && !Objects.equals(classifier, this.filter.getClassifier())) {
                    return;
                }
                StringBuilder finalNameExt = new StringBuilder(mdl.getBuild().getFinalName());
                if (classifier != null) {
                    finalNameExt.append("-").append(classifier);
                }
                finalNameExt.append(".").append(packaging);
                ArtifactSpec.Builder builder = ArtifactSpec.builder((String)mA.getGroupId(), (String)mA.getArtifactId(), (String)mA.getVersion(), (Object)this.nbMavenProject.getMavenProject().getArtifact()).classifier(classifier).tags(tags).type(type);
                try {
                    Path dir = Paths.get(mdl.getBuild().getDirectory(), new String[0]);
                    if (domOutputDir != null) {
                        dir = mdl.getProjectDirectory().toPath().resolve(domOutputDir.getValue());
                    }
                    Path artPath = dir.resolve(finalNameExt.toString());
                    URI uri = artPath.toUri();
                    builder.location(uri);
                    if (Files.exists(artPath, new LinkOption[0])) {
                        builder.forceLocalFile(FileUtil.toFileObject((File)artPath.toFile()));
                    }
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
                this.addArtifactSpec(builder.build());
            }
        }

        public void run() {
            this.specs = new ArrayList<ArtifactSpec>();
            ProjectActionContext buildCtx = this.filter != null && this.filter.getBuildContext() != null ? (this.filter.getBuildContext().getProjectAction() == null ? this.filter.getBuildContext().newDerivedBuilder().forProjectAction("build").context() : this.filter.getBuildContext()) : ProjectActionContext.newBuilder((Project)this.project).forProjectAction("build").context();
            MavenProject mp = this.nbMavenProject.getEvaluatedProject(buildCtx);
            Model mdl = mp.getModel();
            this.evalProject = mp;
            String packaging = mdl.getPackaging();
            if (packaging == null) {
                packaging = "jar";
            }
            this.appendShadePluginOutput(this.evalProject);
            if (!this.skipDefaultOutput) {
                this.appendPluginOutput(mp, "maven-jar-plugin", "jar", "jar");
            }
            this.appendPluginOutput(mp, "maven-jar-plugin", "test-jar", "test-jar", "jar", "tests", new String[0]);
            this.appendPluginOutput(mp, "maven-source-plugin", "jar", "sources", "jar", "sources", "java-source");
            this.appendPluginOutput(mp, "maven-source-plugin", "test-jar", "sources", "jar", "test-sources", "java-source", "test");
            this.appendPluginOutput(mp, "maven-war-plugin", "war", "war");
            this.appendPluginOutput(mp, "maven-ear-plugin", "ear", "ear");
            this.appendPluginOutput(mp, "maven-ejb-plugin", "ejb", "ejb");
        }

        private class ShadedEvaluator {
            private static final String DEFAULT_SHADE_CLASSIFIER = "shaded";
            private final MavenProject evalProject;
            private final PluginExecution exec;
            private String t;
            private String c;
            String classifier;
            String outputDir;
            String outputFile;
            String finalName;
            String artifactId;
            boolean attached;
            boolean createSourcesJar;
            boolean createTestJar;
            boolean createTestSourcesJar;
            String outD;
            String name;
            Path basePath;
            Artifact mA;
            boolean any;
            boolean tagBase;
            boolean tagShaded;
            boolean renamed;

            public ShadedEvaluator(MavenProject evalProject, PluginExecution exec) {
                this.evalProject = evalProject;
                this.exec = exec;
            }

            public void process() {
                String suffix;
                Xpp3Dom dom = this.evalProject.getGoalConfiguration("org.apache.maven.plugins", "maven-shade-plugin", this.exec.getId(), "shade");
                this.mA = this.evalProject.getArtifact();
                this.t = MavenQuery.this.filter.getArtifactType();
                this.c = MavenQuery.this.filter.getClassifier();
                this.classifier = MavenQuery.getValueOrNull(dom, "shadedClassifierName");
                this.outputDir = MavenQuery.getValueOrNull(dom, "outputDirectory");
                this.outputFile = MavenQuery.getValueOrNull(dom, "outputFile");
                this.finalName = MavenQuery.getValueOrNull(dom, "finalName");
                this.artifactId = MavenQuery.getValueOrNull(dom, "shadedArtifactId");
                this.attached = Boolean.valueOf(MavenQuery.getValueOrNull(dom, "shadedArtifactAttached"));
                this.createSourcesJar = Boolean.valueOf(MavenQuery.getValueOrNull(dom, "createSourcesJar"));
                this.createTestJar = Boolean.valueOf(MavenQuery.getValueOrNull(dom, "shadeTestJar"));
                this.createTestSourcesJar = Boolean.valueOf(MavenQuery.getValueOrNull(dom, "createTestSourcesJar"));
                this.outD = this.evalProject.getModel().getBuild().getDirectory();
                this.name = this.evalProject.getBuild().getFinalName();
                if (this.artifactId == null) {
                    this.artifactId = this.mA.getArtifactId();
                }
                if (this.outputDir != null) {
                    this.outD = this.outputDir;
                }
                if (this.finalName != null && this.finalName.length() > 0) {
                    this.name = this.finalName;
                }
                this.basePath = Paths.get(this.outD, this.name);
                this.any = "<any>".equals(this.c);
                this.tagShaded = MavenQuery.this.filter.hasTag("<shaded>") || MavenQuery.this.filter.hasTag(this.classifier);
                this.tagBase = MavenQuery.this.filter.hasTag("<basic>");
                if (this.attached && this.classifier == null) {
                    this.classifier = DEFAULT_SHADE_CLASSIFIER;
                }
                boolean classifierMatch = this.any || this.classifier != null && this.classifier.equals(this.c) || this.c == null && !this.attached || this.tagBase;
                String gID = this.mA.getGroupId();
                if (this.outputFile != null) {
                    this.addExplicitOutputFile();
                    suffix = "-" + this.classifier;
                } else {
                    if (this.name != null && !this.name.equals(this.evalProject.getBuild().getFinalName())) {
                        this.renamed = true;
                        this.basePath = this.basePath.resolveSibling(this.name);
                        suffix = "";
                    } else {
                        suffix = "";
                    }
                    if (this.attached) {
                        suffix = "-" + this.classifier;
                    }
                    if (classifierMatch) {
                        boolean reportShaded;
                        if (this.any && !this.tagShaded || this.tagBase) {
                            MavenQuery.this.skipDefaultOutput = !this.attached;
                            Path file = this.basePath.resolveSibling("original-" + this.basePath.getFileName() + suffix + ".jar");
                            ArtifactSpec spec = ArtifactSpec.builder((String)(this.attached ? gID : null), (String)(this.attached ? this.artifactId : null), (String)this.mA.getVersion(), (Object)this.evalProject).classifier(this.classifier).location(file.toUri()).type("jar").tag("<basic>").build();
                            MavenQuery.this.addArtifactSpec(spec);
                        }
                        if (this.any) {
                            reportShaded = !this.tagBase || this.tagShaded;
                        } else {
                            boolean bl = reportShaded = !this.tagBase;
                        }
                        if (reportShaded) {
                            Path file = this.basePath.resolveSibling(this.basePath.getFileName() + suffix + ".jar");
                            ArtifactSpec spec = ArtifactSpec.builder((String)gID, (String)this.artifactId, (String)this.mA.getVersion(), (Object)this.evalProject).classifier(this.classifier).location(file.toUri()).type("jar").tag("<shaded>").build();
                            MavenQuery.this.addArtifactSpec(spec);
                        }
                    }
                }
                if (classifierMatch) {
                    if (this.createSourcesJar) {
                        this.addClassifiedArtifact("sources", suffix, "sources", "sources", "java-source");
                    }
                    if (this.createTestJar) {
                        this.addClassifiedArtifact("test-jar", suffix, "tests", "tests", "test");
                    }
                    if (this.createTestSourcesJar) {
                        this.addClassifiedArtifact("sources", suffix, "test-sources", "test-sources", "java-source", "test");
                    }
                }
            }

            private void addClassifiedArtifact(String type, String suffix, String typeSuffix, String defaultClassifier, String ... tags) {
                ArtifactSpec spec;
                Path file;
                if (!("<all>".equals(this.t) || type.equals(this.t) || this.any && this.t == null)) {
                    return;
                }
                String clas = this.classifier;
                if (clas == null) {
                    clas = defaultClassifier;
                }
                if (this.any || !this.tagBase || this.tagShaded) {
                    file = this.basePath.resolveSibling(this.basePath.getFileName() + suffix + "-" + typeSuffix + ".jar");
                    spec = ArtifactSpec.builder((String)this.mA.getGroupId(), (String)this.artifactId, (String)this.mA.getVersion(), (Object)this.evalProject).classifier(clas).location(file.toUri()).type(type).tag("<shaded>").tags(tags).build();
                    MavenQuery.this.addArtifactSpec(spec);
                }
                if (this.any || this.tagBase) {
                    file = this.basePath.resolveSibling("original-" + this.basePath.getFileName() + suffix + "-" + typeSuffix + ".jar");
                    spec = ArtifactSpec.builder((String)(this.attached ? this.mA.getGroupId() : null), (String)(this.attached ? this.artifactId : null), (String)this.mA.getVersion(), (Object)this.evalProject).classifier(clas).location(file.toUri()).type(type).tag("<basic>").tags(tags).build();
                    MavenQuery.this.addArtifactSpec(spec);
                }
            }

            void addExplicitOutputFile() {
                ArtifactSpec spec2;
                if (("<all>".equals(this.t) || this.t == null || "jar".equals(this.t)) && (this.any || this.c == null && MavenQuery.this.filter.hasTag("<shaded>"))) {
                    Path file = null;
                    try {
                        file = Paths.get(this.outputFile, new String[0]);
                        spec2 = ArtifactSpec.builder(null, null, (String)this.mA.getVersion(), (Object)this.evalProject).classifier(this.classifier).location(file.toUri()).type("jar").tag("<shaded>").build();
                        MavenQuery.this.addArtifactSpec(spec2);
                    }
                    catch (InvalidPathException spec2) {
                        // empty catch block
                    }
                }
                if (("<all>".equals(this.t) || this.t == null || "jar".equals(this.t)) && (this.any || this.c == null && (MavenQuery.this.filter.hasTag("<basic>") || MavenQuery.this.filter.hasTag(DEFAULT_SHADE_CLASSIFIER)))) {
                    Path p = this.basePath.resolveSibling("original-" + this.basePath.getFileName() + ".jar");
                    spec2 = ArtifactSpec.builder(null, null, (String)this.mA.getVersion(), (Object)this.evalProject).classifier(this.classifier).location(p.toUri()).type("jar").tag("<basic>").build();
                    MavenQuery.this.addArtifactSpec(spec2);
                }
            }
        }
    }
}

