/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.mylyn.commons.core.HtmlTag;

public class HtmlStreamTokenizer {
    private State state;
    private final BufferedReader in;
    private final URL base;
    private final StringBuffer textBuffer = new StringBuffer();
    private final StringBuffer whitespaceBuffer = new StringBuffer();
    private Token pushbackToken;
    private int pushbackChar = 0;
    private int quoteChar;
    private boolean escapeTagValues;
    private static HashMap<String, Character> entities = new HashMap();

    static {
        entities.put("nbsp", Character.valueOf('\u00a0'));
        entities.put("iexcl", Character.valueOf('\u00a1'));
        entities.put("cent", Character.valueOf('\u00a2'));
        entities.put("pound", Character.valueOf('\u00a3'));
        entities.put("curren", Character.valueOf('\u00a4'));
        entities.put("yen", Character.valueOf('\u00a5'));
        entities.put("brvbar", Character.valueOf('\u00a6'));
        entities.put("sect", Character.valueOf('\u00a7'));
        entities.put("uml", Character.valueOf('\u00a8'));
        entities.put("copy", Character.valueOf('\u00a9'));
        entities.put("ordf", Character.valueOf('\u00aa'));
        entities.put("laquo", Character.valueOf('\u00ab'));
        entities.put("not", Character.valueOf('\u00ac'));
        entities.put("shy", Character.valueOf('\u00ad'));
        entities.put("reg", Character.valueOf('\u00ae'));
        entities.put("macr", Character.valueOf('\u00af'));
        entities.put("deg", Character.valueOf('\u00b0'));
        entities.put("plusmn", Character.valueOf('\u00b1'));
        entities.put("sup2", Character.valueOf('\u00b2'));
        entities.put("sup3", Character.valueOf('\u00b3'));
        entities.put("acute", Character.valueOf('\u00b4'));
        entities.put("micro", Character.valueOf('\u00b5'));
        entities.put("para", Character.valueOf('\u00b6'));
        entities.put("middot", Character.valueOf('\u00b7'));
        entities.put("cedil", Character.valueOf('\u00b8'));
        entities.put("sup1", Character.valueOf('\u00b9'));
        entities.put("ordm", Character.valueOf('\u00ba'));
        entities.put("raquo", Character.valueOf('\u00bb'));
        entities.put("frac14", Character.valueOf('\u00bc'));
        entities.put("frac12", Character.valueOf('\u00bd'));
        entities.put("frac34", Character.valueOf('\u00be'));
        entities.put("iquest", Character.valueOf('\u00bf'));
        entities.put("Agrave", Character.valueOf('\u00c0'));
        entities.put("Aacute", Character.valueOf('\u00c1'));
        entities.put("Acirc", Character.valueOf('\u00c2'));
        entities.put("Atilde", Character.valueOf('\u00c3'));
        entities.put("Auml", Character.valueOf('\u00c4'));
        entities.put("Aring", Character.valueOf('\u00c5'));
        entities.put("AElig", Character.valueOf('\u00c6'));
        entities.put("Ccedil", Character.valueOf('\u00c7'));
        entities.put("Egrave", Character.valueOf('\u00c8'));
        entities.put("Eacute", Character.valueOf('\u00c9'));
        entities.put("Ecirc", Character.valueOf('\u00ca'));
        entities.put("Euml", Character.valueOf('\u00cb'));
        entities.put("Igrave", Character.valueOf('\u00cc'));
        entities.put("Iacute", Character.valueOf('\u00cd'));
        entities.put("Icirc", Character.valueOf('\u00ce'));
        entities.put("Iuml", Character.valueOf('\u00cf'));
        entities.put("ETH", Character.valueOf('\u00d0'));
        entities.put("Ntilde", Character.valueOf('\u00d1'));
        entities.put("Ograve", Character.valueOf('\u00d2'));
        entities.put("Oacute", Character.valueOf('\u00d3'));
        entities.put("Ocirc", Character.valueOf('\u00d4'));
        entities.put("Otilde", Character.valueOf('\u00d5'));
        entities.put("Ouml", Character.valueOf('\u00d6'));
        entities.put("times", Character.valueOf('\u00d7'));
        entities.put("Oslash", Character.valueOf('\u00d8'));
        entities.put("Ugrave", Character.valueOf('\u00d9'));
        entities.put("Uacute", Character.valueOf('\u00da'));
        entities.put("Ucirc", Character.valueOf('\u00db'));
        entities.put("Uuml", Character.valueOf('\u00dc'));
        entities.put("Yacute", Character.valueOf('\u00dd'));
        entities.put("THORN", Character.valueOf('\u00de'));
        entities.put("szlig", Character.valueOf('\u00df'));
        entities.put("agrave", Character.valueOf('\u00e0'));
        entities.put("aacute", Character.valueOf('\u00e1'));
        entities.put("acirc", Character.valueOf('\u00e2'));
        entities.put("atilde", Character.valueOf('\u00e3'));
        entities.put("auml", Character.valueOf('\u00e4'));
        entities.put("aring", Character.valueOf('\u00e5'));
        entities.put("aelig", Character.valueOf('\u00e6'));
        entities.put("ccedil", Character.valueOf('\u00e7'));
        entities.put("egrave", Character.valueOf('\u00e8'));
        entities.put("eacute", Character.valueOf('\u00e9'));
        entities.put("ecirc", Character.valueOf('\u00ea'));
        entities.put("euml", Character.valueOf('\u00eb'));
        entities.put("igrave", Character.valueOf('\u00ec'));
        entities.put("iacute", Character.valueOf('\u00ed'));
        entities.put("icirc", Character.valueOf('\u00ee'));
        entities.put("iuml", Character.valueOf('\u00ef'));
        entities.put("eth", Character.valueOf('\u00f0'));
        entities.put("ntilde", Character.valueOf('\u00f1'));
        entities.put("ograve", Character.valueOf('\u00f2'));
        entities.put("oacute", Character.valueOf('\u00f3'));
        entities.put("ocirc", Character.valueOf('\u00f4'));
        entities.put("otilde", Character.valueOf('\u00f5'));
        entities.put("ouml", Character.valueOf('\u00f6'));
        entities.put("divide", Character.valueOf('\u00f7'));
        entities.put("oslash", Character.valueOf('\u00f8'));
        entities.put("ugrave", Character.valueOf('\u00f9'));
        entities.put("uacute", Character.valueOf('\u00fa'));
        entities.put("ucirc", Character.valueOf('\u00fb'));
        entities.put("uuml", Character.valueOf('\u00fc'));
        entities.put("yacute", Character.valueOf('\u00fd'));
        entities.put("thorn", Character.valueOf('\u00fe'));
        entities.put("yuml", Character.valueOf('\u00ff'));
        entities.put("quot", Character.valueOf('\"'));
        entities.put("amp", Character.valueOf('&'));
        entities.put("lt", Character.valueOf('<'));
        entities.put("gt", Character.valueOf('>'));
        entities.put("OElig", Character.valueOf('\u0152'));
        entities.put("oelig", Character.valueOf('\u0153'));
        entities.put("Scaron", Character.valueOf('\u0160'));
        entities.put("scaron", Character.valueOf('\u0161'));
        entities.put("Yuml", Character.valueOf('\u0178'));
        entities.put("circ", Character.valueOf('\u02c6'));
        entities.put("tilde", Character.valueOf('\u02dc'));
        entities.put("ensp", Character.valueOf('\u2002'));
        entities.put("emsp", Character.valueOf('\u2003'));
        entities.put("thinsp", Character.valueOf('\u2009'));
        entities.put("zwnj", Character.valueOf('\u200c'));
        entities.put("zwj", Character.valueOf('\u200d'));
        entities.put("lrm", Character.valueOf('\u200e'));
        entities.put("rlm", Character.valueOf('\u200f'));
        entities.put("ndash", Character.valueOf('\u2013'));
        entities.put("mdash", Character.valueOf('\u2014'));
        entities.put("lsquo", Character.valueOf('\u2018'));
        entities.put("rsquo", Character.valueOf('\u2019'));
        entities.put("sbquo", Character.valueOf('\u201a'));
        entities.put("ldquo", Character.valueOf('\u201c'));
        entities.put("rdquo", Character.valueOf('\u201d'));
        entities.put("bdquo", Character.valueOf('\u201e'));
        entities.put("dagger", Character.valueOf('\u2020'));
        entities.put("Dagger", Character.valueOf('\u2021'));
        entities.put("permil", Character.valueOf('\u2030'));
        entities.put("lsaquo", Character.valueOf('\u2039'));
        entities.put("rsaquo", Character.valueOf('\u203a'));
        entities.put("euro", Character.valueOf('\u20ac'));
    }

    public HtmlStreamTokenizer(Reader in, URL base) {
        this.state = State.TEXT;
        this.in = new BufferedReader(in);
        this.base = base;
        this.escapeTagValues = true;
    }

    public void escapeTagAttributes(boolean value) {
        this.escapeTagValues = value;
    }

    public Token nextToken() throws IOException, ParseException {
        if (this.pushbackToken != null) {
            Token token = this.pushbackToken;
            this.pushbackToken = null;
            return token;
        }
        int closingComment = 0;
        this.textBuffer.setLength(0);
        this.whitespaceBuffer.setLength(0);
        while (true) {
            int ch;
            if (this.pushbackChar != 0) {
                ch = this.pushbackChar;
                this.pushbackChar = 0;
            } else {
                ch = this.in.read();
            }
            if (ch < 0) {
                State oldState = this.state;
                this.state = State.EOF;
                if (this.textBuffer.length() > 0 && oldState == State.TEXT) {
                    return new Token(this.textBuffer, this.whitespaceBuffer, false);
                }
                return new Token();
            }
            if (this.state == State.TEXT) {
                if (ch == 60) {
                    this.state = State.TAG;
                    if (this.textBuffer.length() <= 0) continue;
                    return new Token(this.textBuffer, this.whitespaceBuffer, false);
                }
                if (Character.isWhitespace((char)ch)) {
                    this.pushbackChar = ch;
                    this.state = State.WS;
                    if (this.textBuffer.length() <= 0) continue;
                    return new Token(this.textBuffer, this.whitespaceBuffer, false);
                }
                this.textBuffer.append((char)ch);
                continue;
            }
            if (this.state == State.WS) {
                if (!Character.isWhitespace((char)ch)) {
                    this.pushbackChar = ch;
                    this.state = State.TEXT;
                    continue;
                }
                this.whitespaceBuffer.append((char)ch);
                continue;
            }
            if (this.state == State.TAG) {
                if (ch == 62) {
                    this.state = State.TEXT;
                    HtmlTag tag = new HtmlTag(this.base);
                    HtmlStreamTokenizer.parseTag(this.textBuffer.toString(), tag, this.escapeTagValues);
                    return new Token(tag, this.whitespaceBuffer);
                }
                if (ch == 60 && this.textBuffer.length() == 0) {
                    this.textBuffer.append("<<");
                    this.state = State.TEXT;
                    continue;
                }
                if (ch == 45 && this.textBuffer.length() == 2 && this.textBuffer.charAt(1) == '-' && this.textBuffer.charAt(0) == '!') {
                    this.textBuffer.setLength(0);
                    this.state = State.COMMENT;
                    continue;
                }
                if (ch == 39 || ch == 34) {
                    this.quoteChar = ch;
                    this.textBuffer.append((char)ch);
                    this.state = State.TAG_QUOTE;
                    continue;
                }
                this.textBuffer.append((char)ch);
                continue;
            }
            if (this.state == State.TAG_QUOTE) {
                if (ch == 62) {
                    this.pushbackChar = ch;
                    this.state = State.TAG;
                    continue;
                }
                this.textBuffer.append((char)ch);
                if (ch != this.quoteChar) continue;
                this.state = State.TAG;
                continue;
            }
            if (this.state != State.COMMENT) continue;
            if (ch == 62 && closingComment >= 2) {
                this.textBuffer.setLength(this.textBuffer.length() - 2);
                closingComment = 0;
                this.state = State.TEXT;
                return new Token(this.textBuffer, this.whitespaceBuffer, true);
            }
            closingComment = ch == 45 ? ++closingComment : 0;
            this.textBuffer.append((char)ch);
        }
    }

    public void pushback(Token token) {
        this.pushbackToken = token;
    }

    private static void parseTag(String s, HtmlTag tag, boolean escapeValues) throws ParseException {
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i == s.length()) {
            throw new ParseException("parse empty tag", 0);
        }
        int start = i;
        while (i < s.length() && !Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (s.charAt(i - 1) == '/') {
            tag.setSelfTerminating(true);
            tag.setTagName(s.substring(start, i - 1));
            return;
        }
        tag.setTagName(s.substring(start, i));
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i == s.length()) {
            return;
        }
        HtmlStreamTokenizer.parseAttributes(tag, s, i, escapeValues);
    }

    /*
     * Unable to fully structure code
     */
    private static void parseAttributes(HtmlTag tag, String s, int i, boolean escapeValues) throws ParseException {
        ** GOTO lbl52
        {
            ++i;
            do {
                if (i < s.length() && Character.isWhitespace(s.charAt(i))) continue block0;
                if (i == s.length()) {
                    return;
                }
                start = i;
                while (i < s.length() && !Character.isWhitespace(s.charAt(i)) && s.charAt(i) != '=') {
                    ++i;
                }
                attributeName = s.substring(start, i).toLowerCase(Locale.ENGLISH);
                if (!attributeName.equals("/")) ** GOTO lbl16
                tag.setSelfTerminating(true);
                continue;
lbl-1000:
                // 1 sources

                {
                    ++i;
lbl16:
                    // 2 sources

                    ** while (i < s.length() && Character.isWhitespace((char)s.charAt((int)i)))
                }
lbl17:
                // 1 sources

                if (i == s.length() || s.charAt(i) != '=') {
                    tag.setAttribute(attributeName, "");
                    continue;
                }
                ++i;
                while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
                    ++i;
                }
                if (i == s.length()) {
                    return;
                }
                if (s.charAt(i) == '\"') {
                    start = ++i;
                    while (i < s.length() && s.charAt(i) != '\"') {
                        ++i;
                    }
                    if (i == s.length()) {
                        return;
                    }
                    attributeValue = escapeValues != false ? HtmlStreamTokenizer.unescape(s.substring(start, i)) : s.substring(start, i);
                    ++i;
                } else if (s.charAt(i) == '\'') {
                    start = ++i;
                    while (i < s.length() && s.charAt(i) != '\'') {
                        ++i;
                    }
                    if (i == s.length()) {
                        return;
                    }
                    attributeValue = HtmlStreamTokenizer.unescape(s.substring(start, i));
                    ++i;
                } else {
                    start = i;
                    while (i < s.length() && !Character.isWhitespace(s.charAt(i))) {
                        ++i;
                    }
                    attributeValue = s.substring(start, i);
                }
                tag.setAttribute(attributeName, attributeValue);
lbl52:
                // 4 sources

            } while (i < s.length());
        }
    }

    @Deprecated
    public static String unescape(String s) {
        if (s.indexOf(38) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        HtmlStreamTokenizer.unescape(sb);
        return sb.toString();
    }

    @Deprecated
    public static StringBuffer unescape(StringBuffer sb) {
        int i = 0;
        int j = 0;
        while (i < sb.length()) {
            int ch = sb.charAt(i);
            if (ch == 38) {
                int start = i++;
                String escape = null;
                while (i < sb.length()) {
                    ch = sb.charAt(i);
                    if (!(Character.isLetterOrDigit((char)ch) || ch == 35 && i == start + 1)) {
                        escape = sb.substring(start + 1, i);
                        break;
                    }
                    ++i;
                }
                if (i == sb.length() && i != start + 1) {
                    escape = sb.substring(start + 1);
                }
                if (escape != null) {
                    Character character = HtmlStreamTokenizer.parseReference(escape);
                    if (!(character == null || '\n' == character.charValue() || '\r' == character.charValue() || 9 == ch || character.charValue() >= ' ' && character.charValue() <= '\ud7ff' || character.charValue() >= '\ue000' && character.charValue() <= '\ufffd' || character.charValue() >= '\u10000' && character.charValue() <= '\u10ffff')) {
                        character = null;
                    }
                    if (character != null) {
                        ch = character.charValue();
                    } else {
                        i = start;
                        ch = 38;
                    }
                }
            }
            sb.setCharAt(j, (char)ch);
            ++i;
            ++j;
        }
        sb.setLength(j);
        return sb;
    }

    private static Character parseReference(String s) {
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(0) == '#') {
            if (s.length() == 1) {
                return null;
            }
            try {
                int value = s.charAt(1) == 'x' ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s.substring(1));
                return new Character((char)value);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return entities.get(s);
    }

    private static class State {
        static final State EOF = new State();
        static final State COMMENT = new State();
        static final State TEXT = new State();
        static final State TAG = new State();
        static final State WS = new State();
        static final State TAG_QUOTE = new State();

        private State() {
        }
    }

    public static class Token {
        public static final Type EOF = new Type();
        public static final Type TEXT = new Type();
        public static final Type TAG = new Type();
        public static final Type COMMENT = new Type();
        private Type type;
        private final Object value;
        private final StringBuffer whitespace;

        protected Token() {
            this.type = EOF;
            this.value = null;
            this.whitespace = null;
        }

        protected Token(HtmlTag tag, StringBuffer whitespace) {
            this.type = TAG;
            this.value = tag;
            this.whitespace = whitespace;
        }

        protected Token(StringBuffer text, StringBuffer whitespace, boolean comment) {
            this.type = comment ? COMMENT : TEXT;
            this.value = text;
            this.whitespace = whitespace;
        }

        public Type getType() {
            return this.type;
        }

        public StringBuffer getWhitespace() {
            return this.whitespace;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.whitespace != null) {
                sb.append(this.whitespace);
            }
            if (this.value != null) {
                if (this.type != TAG && this.type == COMMENT) {
                    sb.append("<!--");
                }
                sb.append(this.value);
                if (this.type != TAG && this.type == COMMENT) {
                    sb.append("-->");
                }
            }
            return sb.toString();
        }

        private static class Type {
            private Type() {
            }
        }
    }
}

