/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui;

import java.awt.EventQueue;
import java.util.List;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public final class EditorUtils {
    public static final String CURRENT_LINE_ANNOTATION_TYPE = "CurrentPC";
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE = "CallSite";

    private EditorUtils() {
    }

    public static Line getLine(CDTDebugger dbg, FileObject fo, int line, Integer column) {
        if (fo == null) {
            return null;
        }
        SourceMapsTranslator smtr = dbg.getScriptsHandler().getSourceMapsTranslator();
        if (smtr != null) {
            if (column == 0) {
                column = 0;
            }
            SourceMapsTranslator.Location loc = new SourceMapsTranslator.Location(fo, line, column.intValue());
            loc = smtr.getSourceLocation(loc);
            fo = loc.getFile();
            line = loc.getLine();
        }
        LineCookie lineCookie = (LineCookie)fo.getLookup().lookup(LineCookie.class);
        try {
            return lineCookie.getLineSet().getCurrent(line);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (!lines.isEmpty()) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    public static void showLine(final Line line, final boolean toFront) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                line.show(Line.ShowOpenType.REUSE, toFront ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FOCUS);
            }
        });
    }

    public static void showLine(Line line) {
        EditorUtils.showLine(line, false);
    }

    public static void showFrameLine(CDTDebugger dbg, CallFrame frame, boolean toFront) {
        ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
        CDTScript script = scriptsHandler.getScript(frame.getLocation().getScriptId());
        if (script == null) {
            return;
        }
        FileObject fo = scriptsHandler.getFile(script);
        Line line = EditorUtils.getLine(dbg, fo, frame.getLocation().getLineNumber(), frame.getLocation().getColumnNumber());
        if (line != null) {
            EditorUtils.showLine(line, toFront);
        }
    }
}

