/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.ResourceJavaScript;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.WadlModeler;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ClientStubsGenerator
extends AbstractGenerator {
    public static final String REST = "rest";
    public static final String RJS = "rjs";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String TXT = "txt";
    public static final String JSON = "json";
    public static final String GIF = "gif";
    public static final String IMAGES = "images";
    public static final String BUNDLE = "Bundle";
    public static final String PROPERTIES = "properties";
    public static final String JS_SUPPORT = "Support";
    public static final String JS_TESTSTUBS = "TestStubs";
    public static final String JS_README = "Readme";
    public static final String JS_TESTSTUBS_TEMPLATE = "Templates/WebServices/JsTestStubs.html";
    public static final String JS_STUBSUPPORT_TEMPLATE = "Templates/WebServices/JsStubSupport.js";
    public static final String JS_PROJECTSTUB_TEMPLATE = "Templates/WebServices/JsProjectStub.js";
    public static final String JS_STUB_TEMPLATE = "Templates/WebServices/JsStub.js";
    public static final String JS_ENTITY_TEMPLATE = "Templates/WebServices/JsEntity.js";
    public static final String JS_README_TEMPLATE = "Templates/WebServices/JsReadme.html";
    public static final String PROXY = "RestProxyServlet";
    public static final String PROXY_URL = "/restproxy";
    public static final String PROXY_TEMPLATE = "Templates/WebServices/RestProxyServlet.txt";
    public static final String MSG_Readme = "MSG_Readme";
    public static final String README_VAR = "msg_readme";
    public static final String MSG_TestPage = "MSG_TestPage";
    public static final String TESTPAGE_VAR = "test_page";
    public static final String TTL_RestClient_Stubs = "TTL_RestClient_Stubs";
    public static final String RESTCLIENT_STABS_VAR = "rest_client_stubs";
    public static final String MSG_JS_Readme_Content = "MSG_JS_Readme_Content";
    public static final String README_CONTENT_VAR = "readme_content";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    public static final String DEFAULT_BASE_URL = "http://localhost:8080";
    public static final String BASE_URL_TOKEN = "base_url";
    private FileObject stubFolder;
    private Project p;
    private boolean overwrite;
    private String projectName;
    private ResourceModel model;
    private FileObject rjsDir;
    private FileObject wadl;
    private String folderName;
    private String baseUrl;
    private String proxyUrl;
    private Charset baseEncoding;
    private FileObject rootFolder;

    public ClientStubsGenerator(FileObject rootFolder, String folderName, Project p, boolean overwrite) throws IOException {
        assert (p != null);
        this.rootFolder = rootFolder;
        this.folderName = folderName;
        this.p = p;
        this.overwrite = overwrite;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)rootFolder);
    }

    public ClientStubsGenerator(FileObject rootFolder, String folderName, FileObject wadl, boolean overwrite) throws IOException {
        this.rootFolder = rootFolder;
        this.folderName = folderName;
        this.wadl = wadl;
        this.overwrite = overwrite;
        this.projectName = "NewProject";
        this.baseEncoding = FileEncodingQuery.getEncoding((FileObject)rootFolder);
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public FileObject getStubFolder() {
        if (this.stubFolder == null) {
            try {
                this.stubFolder = this.createFolder(this.getRootFolder(), this.getFolderName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.stubFolder;
    }

    public void setStubFolder(FileObject stubFolder) {
        this.stubFolder = stubFolder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ResourceModel getModel() {
        return this.model;
    }

    public String getDefaultBaseUrl() {
        return DEFAULT_BASE_URL;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public Charset getBaseEncoding() {
        return this.baseEncoding;
    }

    private String getApplicationNameFromUrl(String url) {
        String[] paths;
        String appName = url.replaceAll("http://", "");
        if (appName.endsWith("/")) {
            appName = appName.substring(0, appName.length() - 1);
        }
        if ((paths = appName.split("/")) != null && paths.length > 0) {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path == null || !path.startsWith(DEFAULT_HOST) || i + 1 >= paths.length || paths[i + 1] == null || paths[i + 1].trim().length() <= 0) continue;
                return ClientStubModel.normalizeName(paths[i + 1]);
            }
        }
        return ClientStubModel.normalizeName(appName);
    }

    private String findBaseUrl(Project p) {
        String url = null;
        J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            String sID = provider.getServerInstanceID();
            ServerInstance si = Deployment.getDefault().getServerInstance(sID);
            if (si != null) {
                try {
                    ServerInstance.Descriptor descriptor = si.getDescriptor();
                    url = descriptor.getHttpPort() == 80 ? descriptor.getHostname() : descriptor.getHostname() + ":" + descriptor.getHttpPort();
                    url = "http://" + url;
                }
                catch (InstanceRemovedException ex) {
                    url = null;
                }
            }
        }
        return url;
    }

    private String findAppContext(Project p) {
        String cPath = WebModule.getWebModule((FileObject)p.getProjectDirectory()).getContextPath();
        cPath = cPath != null ? cPath.substring(1) : ProjectUtils.getInformation((Project)p).getName();
        return cPath;
    }

    @Override
    public Set<FileObject> generate(ProgressHandle pHandle) throws IOException {
        FileObject readme;
        String url;
        if (pHandle != null) {
            this.initProgressReporting(pHandle, false);
        }
        Project targetPrj = FileOwnerQuery.getOwner((FileObject)this.getRootFolder());
        if (this.p != null) {
            String proxyUrl2;
            this.model = new ClientStubModel().createModel(this.p);
            this.model.build();
            url = this.findBaseUrl(this.p);
            if (url == null) {
                url = this.getDefaultBaseUrl();
            }
            if ((proxyUrl2 = this.findBaseUrl(targetPrj)) == null) {
                proxyUrl2 = url;
            }
            RestSupport restSupport = (RestSupport)this.p.getLookup().lookup(RestSupport.class);
            String path = restSupport.getApplicationPath();
            this.setBaseUrl((url.endsWith("/") ? url : url + "/") + this.findAppContext(this.getProject()) + (String)(path.startsWith("/") ? path : "/" + (String)path));
            this.setProxyUrl((proxyUrl2.endsWith("/") ? proxyUrl2 : proxyUrl2 + "/") + this.findAppContext(targetPrj) + PROXY_URL);
        } else if (this.wadl != null) {
            this.model = new ClientStubModel().createModel(this.wadl);
            this.model.build();
            url = ((WadlModeler)this.model).getBaseUrl();
            if (url == null) {
                url = this.getDefaultBaseUrl();
            }
            this.setBaseUrl(url);
            this.setProxyUrl(url + ".." + PROXY_URL);
            this.projectName = this.getApplicationNameFromUrl(url);
        }
        List<Resource> resourceList = this.getModel().getResources();
        this.rjsDir = this.getStubFolder();
        FileObject prjStubDir = this.createFolder(this.rjsDir, this.getProjectName().toLowerCase());
        this.createDataObjectFromTemplate(JS_PROJECTSTUB_TEMPLATE, prjStubDir, this.getProjectName(), JS, this.canOverwrite(), this.getProjectStubParameters(this.getProjectName()));
        HashSet<String> entities = new HashSet<String>();
        for (Resource r : resourceList) {
            if (pHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingClass", (Object)r.getName(), (Object)JS));
            }
            ResourceJavaScript js = new ResourceJavaScript(this, r, prjStubDir, entities);
            js.generate();
            r.getEntities();
            Set<String> generated = r.getEntities();
            entities.addAll(generated);
        }
        this.initJs(this.p, this.getRestStubContentParams(resourceList, ""));
        HashSet<FileObject> files = new HashSet<FileObject>();
        FileObject rjsTest = this.rjsDir.getFileObject(JS_TESTSTUBS, HTML);
        if (rjsTest != null) {
            files.add(rjsTest);
        }
        if ((readme = this.rjsDir.getFileObject(JS_README, TXT)) != null) {
            files.add(readme);
        }
        return files;
    }

    protected FileObject createDataObjectFromTemplate(String template, FileObject dir, String fileName, String ext, boolean overwrite, Map<String, String> parameters) throws IOException {
        FileObject rF0 = dir.getFileObject(fileName, ext);
        if (rF0 != null) {
            if (overwrite) {
                DataObject d = DataObject.find((FileObject)rF0);
                if (d != null) {
                    d.delete();
                }
            } else {
                return rF0;
            }
        }
        DataObject d0 = RestUtils.createDataObjectFromTemplate(template, dir, fileName, parameters);
        return d0.getPrimaryFile();
    }

    protected FileObject createDataObjectFromTemplate(String template, FileObject dir, String fileName, String ext, boolean overwrite) throws IOException {
        return this.createDataObjectFromTemplate(template, dir, fileName, ext, overwrite, null);
    }

    protected void copyDirectory(FileSystem fs, final File src, final File dst) throws IOException {
        if (src.isDirectory()) {
            if (!dst.exists()) {
                dst.mkdir();
            }
            String[] files = src.list();
            for (int i = 0; i < files.length; ++i) {
                this.copyDirectory(fs, new File(src, files[i]), new File(dst, files[i]));
            }
        } else {
            if (!src.exists()) {
                throw new IOException("File or directory does not exist.");
            }
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileInputStream in = null;
                    OutputStream out = null;
                    try {
                        int len;
                        in = new FileInputStream(src);
                        out = new FileOutputStream(dst);
                        byte[] buf = new byte[1024];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                    }
                    finally {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                }
            });
        }
    }

    private void initJs(Project p, Map<String, String> testStubsParams) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RESTCLIENT_STABS_VAR, NbBundle.getMessage(ClientStubsGenerator.class, (String)TTL_RestClient_Stubs));
        map.put(README_VAR, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_Readme));
        map.put(TESTPAGE_VAR, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_TestPage));
        map.put(README_CONTENT_VAR, NbBundle.getMessage(ClientStubsGenerator.class, (String)MSG_JS_Readme_Content));
        testStubsParams.putAll(map);
        FileObject fo = this.createDataObjectFromTemplate(JS_TESTSTUBS_TEMPLATE, this.rjsDir, JS_TESTSTUBS, HTML, false, testStubsParams);
        this.createDataObjectFromTemplate(JS_STUBSUPPORT_TEMPLATE, this.rjsDir, JS_SUPPORT, JS, false);
        fo = this.createDataObjectFromTemplate(JS_README_TEMPLATE, this.rjsDir, JS_README, HTML, false, map);
        fo = this.createDataObjectFromTemplate(PROXY_TEMPLATE, this.rjsDir, PROXY, TXT, false);
        File cssDir = new File(FileUtil.toFile((FileObject)this.rjsDir), CSS);
        cssDir.mkdirs();
        this.copySupportFiles(cssDir);
    }

    private void copySupportFiles(File cssDir) throws IOException {
        String[] fileNames = new String[]{"clientstubs.css", "css_master-all.css", "images/background_border_bottom.gif", "images/pbsel.png", "images/bg_gradient.gif", "images/pname-clientstubs.png", "images/level1_selected-1lvl.jpg", "images/primary-enabled.gif", "images/masthead.png", "images/primary-roll.gif", "images/pbdis.png", "images/secondary-enabled.gif", "images/pbena.png", "images/tbsel.png", "images/pbmou.png", "images/tbuns.png"};
        File imagesDir = new File(cssDir, IMAGES);
        imagesDir.mkdirs();
        for (String file : fileNames) {
            MiscUtilities.copyFile((File)cssDir, (String)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String resourceName, File destFile) throws IOException {
        String path = "resources/" + resourceName;
        if (!destFile.exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                int c;
                is = ClientStubsGenerator.class.getResourceAsStream(path);
                os = new FileOutputStream(destFile);
                while ((c = is.read()) != -1) {
                    os.write(c);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    protected FileObject createFolder(FileObject parent, String folderName) throws IOException {
        FileObject folder = parent.getFileObject(folderName);
        if (folder == null) {
            folder = parent.createFolder(folderName);
        }
        return folder;
    }

    private Map<String, String> getProjectStubParameters(String prjName) {
        HashMap<String, String> map = new HashMap<String, String>();
        String url = this.getBaseUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        map.put(BASE_URL_TOKEN, url);
        map.put("project_name", prjName);
        StringBuilder initBody = new StringBuilder();
        int count = 0;
        List<Resource> resourceList = this.getModel().getResources();
        for (Resource resource : resourceList) {
            if (!resource.hasDefaultGet()) continue;
            initBody.append("      this.resources[");
            initBody.append(count++);
            initBody.append("] = new ");
            initBody.append(resource.getName());
            initBody.append("(this.uri+'");
            String path = resource.getPath();
            if (!path.startsWith("/")) {
                initBody.append('/');
            }
            initBody.append(path);
            initBody.append("');\n");
        }
        map.put("project_init_body", initBody.toString());
        return map;
    }

    private Map<String, String> getRestStubContentParams(List<Resource> resourceList, String pkg) throws IOException {
        String prjName = this.getProjectName();
        String prjStubDir = prjName.toLowerCase();
        StringBuilder sb1 = new StringBuilder();
        sb1.append("\t<script type='text/javascript' src='./");
        sb1.append(prjStubDir);
        sb1.append('/');
        sb1.append(prjName);
        sb1.append('.');
        sb1.append(JS);
        sb1.append("'></script>\n");
        for (Resource r : resourceList) {
            sb1.append("\t<script type='text/javascript' src='./");
            sb1.append(prjStubDir);
            sb1.append('/');
            sb1.append(r.getName());
            sb1.append('.');
            sb1.append(JS);
            sb1.append("'></script>\n");
            Iterator<String> iterator = r.getEntities().iterator();
            while (iterator.hasNext()) {
                sb1.append("\t<script type='text/javascript' src='./");
                sb1.append(prjStubDir);
                sb1.append('/');
                sb1.append(iterator.next());
                sb1.append('.');
                sb1.append(JS);
                sb1.append("'></script>\n");
            }
        }
        StringBuilder sb2 = new StringBuilder();
        String url = this.getBaseUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        sb2.append("\n\t<!-- Using JavaScript files for project " + prjName + "-->\n");
        sb2.append("\t<script language='Javascript'>\n");
        sb2.append("\t\tvar str = '';\n");
        sb2.append("\t\t//Example test code for " + prjName + "\n");
        sb2.append("\t\tstr = '<h2>Resources for " + prjName + ":</h2><br><table border=\"1\">';\n");
        sb2.append("\t\tvar app = new " + pkg + prjName + "('" + url + "');\n");
        sb2.append("\t\t//Uncomment below if using proxy for javascript cross-domain.\n");
        sb2.append("\t\t//app.setProxy(\"" + this.getProxyUrl() + "\");\n");
        sb2.append("\t\tvar resources = app.getResources();\n");
        sb2.append("\t\tfor(i=0;i<resources.length;i++) {\n");
        sb2.append("\t\t  var resource = resources[i];\n");
        sb2.append("\t\t  var uri = resource.getUri();\n");
        sb2.append("\t\t  str += '<tr><td valign=\"top\"><a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a></td><td>';\n");
        sb2.append("\t\t  var items  = resource.getEntities();\n");
        sb2.append("\t\t  if (items != undefined) {\n");
        sb2.append("\t\t    if (items.length > 0) {\n");
        sb2.append("\t\t      for(j=0;j<items.length;j++) {\n");
        sb2.append("\t\t        var item = items[j];\n");
        sb2.append("\t\t        var uri2 = item.getUri();\n");
        sb2.append("\t\t        if ( uri2 != null && uri2 != undefined ){\n");
        sb2.append("\t\t            str += '<a href=\"'+uri2+'\" target=\"_blank\">'+uri2+'</a><br/>';\n");
        sb2.append("\t\t        }\n");
        sb2.append("\t\t        str += '&nbsp;&nbsp;<font size=\"-3\">'+item.toString()+'</font><br/>';\n");
        sb2.append("\t\t      }\n");
        sb2.append("\t\t    } else {\n");
        sb2.append("\t\t      str += 'No items detected';\n");
        sb2.append("\t\t    }\n");
        sb2.append("\t\t  } else {\n");
        sb2.append("\t\t    str += 'No items, please check the url: <a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a>.<br/>Set proxy if RESTful web service is not running on the same domain as this application.';\n");
        sb2.append("\t\t  }\n");
        sb2.append("\t\t  str += '</td></tr>';\n");
        sb2.append("\t\t}\n");
        sb2.append("\t\tstr += '</table><br>';\n");
        sb2.append("\t\tvar n = document.getElementById('containerContent');\n");
        sb2.append("\t\tn.innerHTML = n.innerHTML + str;\n\n");
        sb2.append("\t</script>\n");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("js_scripts_declaration", sb1.toString());
        map.put("js_usage", sb2.toString());
        return map;
    }
}

