/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class Unbalanced {
    private static final String SEEN_KEY = Unbalanced.class.getName() + ".seen";

    private static boolean isAcceptable(Element el) {
        return el != null && (el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.FIELD && el.getModifiers().contains((Object)Modifier.PRIVATE));
    }

    private static void record(CompilationInfo info, VariableElement el, State ... states) {
        HashMap<Element, Set> cache = (HashMap<Element, Set>)info.getCachedValue((Object)SEEN_KEY);
        if (cache == null) {
            cache = new HashMap<Element, Set>();
            info.putCachedValue((Object)SEEN_KEY, cache, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        }
        cache.computeIfAbsent(el, k -> EnumSet.noneOf(State.class)).addAll(Arrays.asList(states));
    }

    private static ErrorDescription produceWarning(HintContext ctx, String keyBase) {
        Element el = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (el == null) {
            return null;
        }
        Map cache = (Map)ctx.getInfo().getCachedValue((Object)SEEN_KEY);
        if (cache == null) {
            return null;
        }
        Set state = (Set)cache.remove(el);
        if (state == null) {
            return null;
        }
        if (state.isEmpty() || state.size() == 2) {
            return null;
        }
        String warningKey = keyBase + ((State)((Object)state.iterator().next())).name();
        String warning = NbBundle.getMessage(Array.class, (String)warningKey, (Object)el.getSimpleName().toString());
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)warning, (Fix[])new Fix[0]);
    }

    public static enum State {
        READ,
        WRITE;

    }

    public static final class Array {
        private static VariableElement testElement(HintContext ctx) {
            Element el = ctx.getInfo().getTrees().getElement(ctx.getPath());
            if (!Unbalanced.isAcceptable(el) || el.asType().getKind() != TypeKind.ARRAY) {
                return null;
            }
            if (((ArrayType)el.asType()).getComponentType().getKind() == TypeKind.ARRAY) {
                return null;
            }
            return (VariableElement)el;
        }

        public static ErrorDescription before(HintContext ctx) {
            VariableElement var = Array.testElement(ctx);
            if (var == null) {
                return null;
            }
            TreePath tp = ctx.getPath();
            if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.ARRAY_ACCESS) {
                State accessType = State.READ;
                State secondAccess = null;
                Tree access = tp.getParentPath().getLeaf();
                Tree assign = tp.getParentPath().getParentPath().getLeaf();
                switch (assign.getKind()) {
                    case ASSIGNMENT: {
                        if (((AssignmentTree)assign).getVariable() != access) break;
                        accessType = State.WRITE;
                        break;
                    }
                    case AND_ASSIGNMENT: 
                    case DIVIDE_ASSIGNMENT: 
                    case LEFT_SHIFT_ASSIGNMENT: 
                    case MINUS_ASSIGNMENT: 
                    case MULTIPLY_ASSIGNMENT: 
                    case OR_ASSIGNMENT: 
                    case PLUS_ASSIGNMENT: 
                    case REMAINDER_ASSIGNMENT: 
                    case RIGHT_SHIFT_ASSIGNMENT: 
                    case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                    case XOR_ASSIGNMENT: {
                        if (((CompoundAssignmentTree)assign).getVariable() != access) break;
                        secondAccess = State.WRITE;
                        break;
                    }
                    case POSTFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: 
                    case PREFIX_DECREMENT: 
                    case PREFIX_INCREMENT: {
                        secondAccess = State.WRITE;
                    }
                }
                Unbalanced.record(ctx.getInfo(), var, new State[]{accessType});
                if (secondAccess != null) {
                    Unbalanced.record(ctx.getInfo(), var, new State[]{secondAccess});
                }
            } else {
                Unbalanced.record(ctx.getInfo(), var, new State[]{State.WRITE, State.READ});
            }
            return null;
        }

        public static ErrorDescription after(HintContext ctx) {
            VariableElement var = Array.testElement(ctx);
            if (var == null) {
                return null;
            }
            Tree parent = ctx.getPath().getParentPath().getLeaf();
            if (parent.getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)parent).getVariable() == ctx.getPath().getLeaf()) {
                return null;
            }
            TreePath init = (TreePath)ctx.getVariables().get("$init$");
            if (init != null) {
                NewArrayTree nat;
                boolean asWrite = true;
                if (init.getLeaf().getKind() == Tree.Kind.NEW_ARRAY && ((nat = (NewArrayTree)init.getLeaf()).getInitializers() == null || nat.getInitializers().isEmpty())) {
                    asWrite = false;
                }
                if (asWrite) {
                    Unbalanced.record(ctx.getInfo(), var, new State[]{State.WRITE});
                }
            }
            return Unbalanced.produceWarning(ctx, "ERR_UnbalancedArray");
        }
    }

    public static final class Collection {
        private static final Set<String> READ_METHODS = new HashSet<String>(Arrays.asList("get", "getOrDefault", "contains", "remove", "containsAll", "removeAll", "removeIf", "retain", "retainAll", "containsKey", "containsValue", "iterator", "listIterator", "isEmpty", "size", "toArray", "entrySet", "keySet", "values", "indexOf", "lastIndexOf", "stream", "parallelStream", "spliterator", "reversed", "getFirst", "getLast", "removeFirst", "removeLast"));
        private static final Set<String> STANDALONE_READ_METHODS = new HashSet<String>(Arrays.asList("forEach"));
        private static final Set<String> WRITE_METHODS = new HashSet<String>(Arrays.asList("add", "addAll", "set", "put", "putAll", "putIfAbsent", "addFirst", "addLast"));

        private static boolean testType(CompilationInfo info, TypeMirror actualType, String superClass) {
            TypeElement juCollection = info.getElements().getTypeElement(superClass);
            if (juCollection == null) {
                return false;
            }
            Types t = info.getTypes();
            return t.isAssignable(t.erasure(actualType), t.erasure(juCollection.asType()));
        }

        private static VariableElement testElement(HintContext ctx) {
            TreePath tp = ctx.getPath();
            Element el = ctx.getInfo().getTrees().getElement(tp);
            if (!Unbalanced.isAcceptable(el)) {
                return null;
            }
            TypeMirror actualType = ctx.getInfo().getTrees().getTypeMirror(tp);
            if (actualType == null || actualType.getKind() != TypeKind.DECLARED) {
                return null;
            }
            if (Collection.testType(ctx.getInfo(), actualType, "java.util.Collection") || Collection.testType(ctx.getInfo(), actualType, "java.util.Map")) {
                return (VariableElement)el;
            }
            return null;
        }

        public static ErrorDescription before(HintContext ctx) {
            TreePath tp = ctx.getPath();
            VariableElement var = Collection.testElement(ctx);
            if (var == null) {
                return null;
            }
            if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.MEMBER_SELECT && tp.getParentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                String methodName = ((MemberSelectTree)tp.getParentPath().getLeaf()).getIdentifier().toString();
                if (READ_METHODS.contains(methodName)) {
                    if (tp.getParentPath().getParentPath().getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                        Unbalanced.record(ctx.getInfo(), var, new State[]{State.READ});
                    }
                    return null;
                }
                if (STANDALONE_READ_METHODS.contains(methodName)) {
                    Unbalanced.record(ctx.getInfo(), var, new State[]{State.READ});
                    return null;
                }
                if (WRITE_METHODS.contains(methodName)) {
                    if (tp.getParentPath().getParentPath().getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                        Unbalanced.record(ctx.getInfo(), var, new State[]{State.WRITE, State.READ});
                    } else {
                        Unbalanced.record(ctx.getInfo(), var, new State[]{State.WRITE});
                    }
                    return null;
                }
            }
            Unbalanced.record(ctx.getInfo(), var, new State[]{State.WRITE, State.READ});
            return null;
        }

        public static ErrorDescription after(HintContext ctx) {
            if (Collection.testElement(ctx) == null) {
                return null;
            }
            TreePath init = (TreePath)ctx.getVariables().get("$init$");
            if (init != null) {
                TypeMirror tm;
                if (init.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                    return null;
                }
                NewClassTree nct = (NewClassTree)init.getLeaf();
                if (nct.getClassBody() != null || nct.getArguments().size() > 1) {
                    return null;
                }
                if (nct.getArguments().size() == 1 && ((tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(init, nct.getArguments().get(0)))) == null || tm.getKind() != TypeKind.INT)) {
                    return null;
                }
            }
            if (ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)ctx.getPath().getParentPath().getLeaf()).getVariable() == ctx.getPath().getLeaf()) {
                return null;
            }
            return Unbalanced.produceWarning(ctx, "ERR_UnbalancedCollection");
        }
    }
}

