/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.ChangeParametersFix;
import org.netbeans.modules.java.hints.errors.ModificationResultBasedFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NotInitializedVariable
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.var.might.not.have.been.initialized", "compiler.err.var.not.initialized.in.default.constructor"));
    private volatile boolean canceled;

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        assert (ERROR_CODES.contains(diagnosticKey));
        ArrayList<Fix> result = new ArrayList<Fix>();
        if (!this.canceled) {
            Trees t = compilationInfo.getTrees();
            Element e = t.getElement(treePath);
            if (!this.canceled && e != null) {
                switch (e.getKind()) {
                    case FIELD: {
                        TreePath declaration = t.getPath(e);
                        if (this.canceled || declaration == null) break;
                        result.add(new NIVFix(e.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo)).toEditorFix());
                        TreePath clsDeclaration = declaration.getParentPath();
                        if (clsDeclaration == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)clsDeclaration.getLeaf().getKind())) break;
                        result.add(new NIVCtorFix(e.getSimpleName().toString(), (ElementHandle<VariableElement>)ElementHandle.create((Element)((VariableElement)e)), TreePathHandle.create((TreePath)clsDeclaration, (CompilationInfo)compilationInfo)).toEditorFix());
                        TypeMirror type = e.asType();
                        TypeKind kind = type.getKind();
                        String value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? "false" : "0") : "null";
                        ClassTree ct = (ClassTree)clsDeclaration.getLeaf();
                        for (Tree tree : ct.getMembers()) {
                            TreePath methodPath;
                            boolean assigned;
                            if (tree.getKind() != Tree.Kind.METHOD || !"<init>".contentEquals(((MethodTree)tree).getName()) || (assigned = Flow.definitellyAssigned(compilationInfo, (VariableElement)e, Collections.singletonList(new TreePath(methodPath = new TreePath(clsDeclaration, tree), ((MethodTree)tree).getBody())), () -> this.canceled))) continue;
                            result.add(new NIVAddCtorParamFix(compilationInfo, methodPath, (VariableElement)e, value));
                        }
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        TreePath declaration = t.getPath(e);
                        if (this.canceled || declaration == null) break;
                        result.add(new NIVFix(e.getSimpleName().toString(), TreePathHandle.create((TreePath)declaration, (CompilationInfo)compilationInfo)).toEditorFix());
                        break;
                    }
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public String getId() {
        return "NotInitializedVariable";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable");
    }

    public void cancel() {
        this.canceled = true;
    }

    private static class NIVFix
    extends JavaFix {
        private final String variableName;

        public NIVFix(String variableName, TreePathHandle variable) {
            super(variable);
            assert (variableName != null);
            assert (variable != null);
            this.variableName = variableName;
        }

        public String getText() {
            return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable_fix", (Object)this.variableName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            VariableTree vt = (VariableTree)tp.getLeaf();
            ExpressionTree init = vt.getInitializer();
            if (init != null) {
                return;
            }
            Element decl = wc.getTrees().getElement(tp);
            if (decl == null) {
                return;
            }
            TypeMirror type = decl.asType();
            TypeKind kind = type.getKind();
            Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
            LiteralTree newInit = wc.getTreeMaker().Literal((Object)value);
            VariableTree newVt = wc.getTreeMaker().Variable(vt.getModifiers(), (CharSequence)vt.getName(), vt.getType(), (ExpressionTree)newInit);
            wc.rewrite((Tree)vt, (Tree)newVt);
        }
    }

    private static class NIVCtorFix
    extends JavaFix {
        private final String variableName;
        private final ElementHandle<VariableElement> field;

        public NIVCtorFix(String variableName, ElementHandle<VariableElement> field, TreePathHandle constructor) {
            super(constructor);
            this.variableName = variableName;
            this.field = field;
        }

        protected String getText() {
            return Bundle.LBL_NotInitializedVariableCtor_fix(this.variableName);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            ClassTree ct = (ClassTree)tp.getLeaf();
            VariableElement ve = (VariableElement)this.field.resolve((CompilationInfo)wc);
            if (ve != null) {
                TreeMaker make = wc.getTreeMaker();
                Trees trees = wc.getTrees();
                TreeUtilities tu = wc.getTreeUtilities();
                boolean isStatic = ve.getModifiers().contains((Object)Modifier.STATIC);
                TypeMirror type = ve.asType();
                TypeKind kind = type.getKind();
                Comparable<Boolean> value = kind.isPrimitive() ? (kind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
                LiteralTree init = make.Literal(value);
                ExpressionTree var = make.QualIdent((isStatic ? ct.getSimpleName().toString() : "this") + '.' + this.variableName);
                ExpressionStatementTree stat = make.ExpressionStatement((ExpressionTree)make.Assignment(var, (ExpressionTree)init));
                for (Tree tree : ct.getMembers()) {
                    boolean assigned;
                    if (tree.getKind() != Tree.Kind.METHOD || !"<init>".contentEquals(((MethodTree)tree).getName())) continue;
                    MethodTree method = (MethodTree)tree;
                    TreePath methodPath = new TreePath(tp, method);
                    boolean synthetic = tu.isSynthetic(methodPath);
                    BlockTree body = method.getBody();
                    if (body == null || (assigned = Flow.definitellyAssigned((CompilationInfo)wc, ve, Collections.singletonList(new TreePath(methodPath, body)), () -> false))) continue;
                    if (synthetic) {
                        Tree constructor = tp.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS ? make.Block(Collections.singletonList(stat), false) : make.Constructor(make.Modifiers(method.getModifiers().getFlags(), method.getModifiers().getAnnotations()), method.getTypeParameters(), method.getParameters(), method.getThrows(), make.addBlockStatement(body, (StatementTree)stat));
                        ClassTree newClass = GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(ct, constructor);
                        wc.rewrite((Tree)ct, (Tree)newClass);
                        continue;
                    }
                    BlockTree newBody = wc.getTreeMaker().addBlockStatement(body, (StatementTree)stat);
                    wc.rewrite((Tree)body, (Tree)newBody);
                }
            }
        }
    }

    private static class NIVAddCtorParamFix
    extends ModificationResultBasedFix
    implements Fix {
        private final ChangeParametersFix fix;
        private final String ctorHeader;
        private final TreePathHandle tph;
        private final String fieldName;
        private final String name;

        public NIVAddCtorParamFix(CompilationInfo compilationInfo, TreePath tp, VariableElement ve, String value) {
            assert (tp != null && tp.getLeaf().getKind() == Tree.Kind.METHOD);
            this.ctorHeader = ElementHeaders.getHeader((TreePath)tp, (CompilationInfo)compilationInfo, (String)"%name%%parameters%");
            this.tph = TreePathHandle.create((TreePath)tp, (CompilationInfo)compilationInfo);
            MethodTree method = (MethodTree)tp.getLeaf();
            Scope scope = compilationInfo.getTreeUtilities().scopeFor((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), method.getBody()) - 1);
            List<? extends VariableTree> parameters = method.getParameters();
            ChangeParametersRefactoring.ParameterInfo[] parameterInfo = new ChangeParametersRefactoring.ParameterInfo[parameters.size() + 1];
            for (int i = 0; i < parameters.size(); ++i) {
                VariableTree param = parameters.get(i);
                parameterInfo[i] = new ChangeParametersRefactoring.ParameterInfo(i, param.getName().toString(), param.getType().toString(), null);
            }
            this.fieldName = ve.getSimpleName().toString();
            this.name = NIVAddCtorParamFix.uniqueName(compilationInfo, scope, this.fieldName);
            parameterInfo[parameterInfo.length - 1] = new ChangeParametersRefactoring.ParameterInfo(-1, this.name, ve.asType().toString(), value);
            this.fix = new ChangeParametersFix(false, this.tph, method.getModifiers().getFlags(), "", "", parameterInfo, true);
        }

        public String getText() {
            return Bundle.LBL_AddCtorParameter_fix(this.ctorHeader);
        }

        public ChangeInfo implement() throws Exception {
            ModificationResult result = this.getModificationResult();
            if (result != null) {
                result.commit();
            }
            this.fix.implement();
            return null;
        }

        @Override
        public List<ModificationResult> getModificationResults() throws IOException {
            ModificationResult result;
            List<ModificationResult> results = this.fix.getModificationResults();
            if (!results.isEmpty() && (result = this.getModificationResult()) != null) {
                NIVAddCtorParamFix.mergeResults(results, result);
            }
            return results;
        }

        @Override
        public ModificationResult getModificationResult() throws IOException {
            JavaSource js;
            FileObject fo = this.tph.getFileObject();
            JavaSource javaSource = js = fo != null ? JavaSource.forFileObject((FileObject)fo) : null;
            if (js != null) {
                return js.runModificationTask(wc -> {
                    BlockTree body;
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = this.tph.resolve((CompilationInfo)wc);
                    if (tp != null && tp.getLeaf().getKind() == Tree.Kind.METHOD && "<init>".contentEquals(((MethodTree)tp.getLeaf()).getName()) && (body = ((MethodTree)tp.getLeaf()).getBody()) != null) {
                        TreeMaker make = wc.getTreeMaker();
                        ExpressionStatementTree stat = make.ExpressionStatement((ExpressionTree)make.Assignment(make.QualIdent("this." + this.fieldName), (ExpressionTree)make.Identifier((CharSequence)this.name)));
                        BlockTree newBody = wc.getTreeMaker().addBlockStatement(body, (StatementTree)stat);
                        wc.rewrite((Tree)body, (Tree)newBody);
                    }
                });
            }
            return null;
        }

        private static String uniqueName(CompilationInfo info, Scope s, String name) {
            int counter = 0;
            boolean cont = true;
            String proposedName = name;
            block0: while (cont) {
                cont = false;
                proposedName = name + (counter > 0 ? String.valueOf(counter) : "");
                if (s == null) continue;
                for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new Utilities.VariablesFilter())) {
                    if (e.getKind().isField() || !proposedName.equals(e.getSimpleName().toString())) continue;
                    ++counter;
                    cont = true;
                    continue block0;
                }
            }
            return proposedName;
        }

        private static void mergeResults(List<ModificationResult> results, ModificationResult result) {
            for (FileObject fo : result.getModifiedFileObjects()) {
                for (ModificationResult r : results) {
                    if (!r.getModifiedFileObjects().contains(fo)) continue;
                    List differences = r.getDifferences(fo);
                    ArrayList<ModificationResult.Difference> unhandled = new ArrayList<ModificationResult.Difference>();
                    block2: for (ModificationResult.Difference diff : result.getDifferences(fo)) {
                        for (int i = 0; i < differences.size(); ++i) {
                            ModificationResult.Difference d = (ModificationResult.Difference)differences.get(i);
                            if (diff.getKind() != d.getKind() || diff.getStartPosition().getOffset() != d.getStartPosition().getOffset() || diff.getEndPosition().getOffset() != d.getEndPosition().getOffset()) continue;
                            String t1 = diff.getNewText();
                            int idx1 = t1.indexOf(40);
                            String t2 = d.getNewText();
                            int idx2 = t2.indexOf(40);
                            if (idx1 <= 0 || idx1 != idx2 || !t1.substring(0, idx1).equals(t2.substring(0, idx2))) continue;
                            idx1 = t1.indexOf(123, idx1);
                            idx2 = t2.indexOf(123, idx2);
                            if (idx1 <= 0 || idx2 <= 0) continue block2;
                            String newText = t2.substring(0, idx2) + t1.substring(idx1);
                            ModificationResult.Difference cd = JavaSourceAccessor.getINSTANCE().createDifference(d.getKind(), d.getStartPosition(), d.getEndPosition(), d.getOldText(), newText, d.getDescription(), null);
                            differences.set(i, cd);
                            continue block2;
                        }
                        unhandled.add(diff);
                    }
                    for (ModificationResult.Difference diff : unhandled) {
                        differences.add(diff);
                    }
                }
            }
        }
    }
}

