/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.actions.PolicyManager;
import org.openide.filesystems.FileObject;

class InsertTask
implements CancellableTask<WorkingCopy> {
    private final String serviceJavaName;
    private final String serviceFName;
    private final String wsdlUrl;
    private final boolean containsWsRefInjection;
    private final PolicyManager manager;

    public InsertTask(String serviceJavaName, String serviceFName, String wsdlUrl, PolicyManager manager, boolean containsWsRefInjection) {
        this.serviceJavaName = serviceJavaName;
        this.serviceFName = serviceFName;
        this.wsdlUrl = wsdlUrl;
        this.containsWsRefInjection = containsWsRefInjection;
        this.manager = manager;
    }

    public void run(WorkingCopy workingCopy) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        TreeMaker make = workingCopy.getTreeMaker();
        ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
        TypeElement classElement = (TypeElement)workingCopy.getTrees().getElement(TreePath.getPath(workingCopy.getCompilationUnit(), (Tree)javaClass));
        if (javaClass != null) {
            ClassTree modifiedClass = this.generateWsServiceRef(workingCopy, make, javaClass);
            if (this.manager.isSupported()) {
                modifiedClass = this.modifyJavaClass(workingCopy, make, modifiedClass, classElement);
            }
            workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
        }
    }

    public void cancel() {
    }

    private ClassTree generateWsServiceRef(WorkingCopy workingCopy, TreeMaker make, ClassTree javaClass) {
        if (this.containsWsRefInjection) {
            return javaClass;
        }
        AnnotationTree wsRefAnnotation = make.Annotation((Tree)make.QualIdent("javax.xml.ws.WebServiceRef"), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)this.wsdlUrl))));
        FileObject targetFo = workingCopy.getFileObject();
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE);
        if (Car.getCar((FileObject)targetFo) != null) {
            modifiers.add(Modifier.STATIC);
        }
        ModifiersTree methodModifiers = make.Modifiers(modifiers, Collections.singletonList(wsRefAnnotation));
        TypeElement typeElement = workingCopy.getElements().getTypeElement(this.serviceJavaName);
        VariableTree serviceRefInjection = make.Variable(methodModifiers, (CharSequence)this.serviceFName, typeElement != null ? make.Type(typeElement.asType()) : make.Identifier((CharSequence)this.serviceJavaName), null);
        ClassTree modifiedClass = make.insertClassMember(javaClass, 0, (Tree)serviceRefInjection);
        return modifiedClass;
    }

    private ClassTree modifyJavaClass(WorkingCopy workingCopy, TreeMaker make, ClassTree javaClass, TypeElement classElement) {
        CompilationUnitTree original;
        Collection<String> existingImports = InsertTask.getImports((CompilationController)workingCopy);
        CompilationUnitTree modified = original = workingCopy.getCompilationUnit();
        for (String imp : this.manager.getImports()) {
            if (existingImports.contains(imp)) continue;
            modified = make.addCompUnitImport(modified, make.Import((Tree)make.Identifier((CharSequence)imp), false));
        }
        workingCopy.rewrite((Tree)original, (Tree)modified);
        return this.insertSecurityFetaureField(workingCopy, make, javaClass, classElement);
    }

    private ClassTree insertSecurityFetaureField(WorkingCopy workingCopy, TreeMaker make, ClassTree javaClass, TypeElement classElement) {
        for (VariableElement var : ElementFilter.fieldsIn(classElement.getEnclosedElements())) {
            TypeMirror varType = var.asType();
            if (varType.getKind() != TypeKind.ARRAY || !var.getSimpleName().contentEquals("securityFeature")) continue;
            return javaClass;
        }
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        ModifiersTree modifiersTree = make.Modifiers(modifiers);
        Tree typeTree = this.manager.createSecurityFeatureType(workingCopy, make);
        ExpressionTree initializer = this.manager.createSecurityFeatureInitializer(workingCopy, make);
        VariableTree securityFeature = make.Variable(modifiersTree, (CharSequence)"securityFeature", typeTree, initializer);
        if (this.manager.isSupported()) {
            this.manager.modifySecurityFeatureAttribute(securityFeature, workingCopy, make);
        }
        return make.insertClassMember(javaClass, 0, (Tree)securityFeature);
    }

    public static Collection<String> getImports(CompilationController controller) {
        HashSet<String> imports = new HashSet<String>();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends ImportTree> importTrees = cu.getImports();
            for (ImportTree importTree : importTrees) {
                imports.add(importTree.getQualifiedIdentifier().toString());
            }
        }
        return imports;
    }
}

