/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.frames;

import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.ReferencedValues;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.Bundle;
import org.netbeans.modules.javascript2.debug.NamesTranslator;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;

public final class CallFrame {
    private final V8Debugger dbg;
    private final V8Frame frame;
    private final ReferencedValues rvals;
    private final boolean topFrame;
    private NamesTranslator nt;
    private final AtomicBoolean checkNamesTranslator = new AtomicBoolean(true);

    public CallFrame(V8Debugger dbg, V8Frame frame, ReferencedValues rvals, boolean topFrame) {
        this.dbg = dbg;
        this.frame = frame;
        this.rvals = rvals;
        this.topFrame = topFrame;
    }

    public V8Frame getFrame() {
        return this.frame;
    }

    public ReferencedValues getRvals() {
        return this.rvals;
    }

    public boolean isTopFrame() {
        return this.topFrame;
    }

    @CheckForNull
    public V8Script getScript() {
        long ref = this.frame.getScriptRef();
        V8Value val = this.rvals.getReferencedValue(ref);
        if (val instanceof V8ScriptValue) {
            return ((V8ScriptValue)val).getScript();
        }
        return null;
    }

    @CheckForNull
    public String getThisName() {
        ReferencedValue receiver = this.frame.getReceiver();
        V8Value thisValue = receiver.hasValue() ? receiver.getValue() : this.rvals.getReferencedValue(receiver.getReference());
        if (!(thisValue instanceof V8Object)) {
            return null;
        }
        String className = ((V8Object)thisValue).getClassName();
        NamesTranslator nt = this.getNamesTranslator();
        if (nt != null) {
            className = nt.translate(className);
        }
        return className;
    }

    @NonNull
    public String getFunctionName() {
        String name;
        ReferencedValue functionRV = this.frame.getFunction();
        V8Value functionValue = functionRV.hasValue() ? functionRV.getValue() : this.rvals.getReferencedValue(functionRV.getReference());
        if (functionValue instanceof V8Function) {
            V8Function function = (V8Function)functionValue;
            name = function.getName();
            if (name == null || name.isEmpty()) {
                name = function.getInferredName();
            }
        } else {
            name = null;
        }
        if (name == null || name.isEmpty()) {
            name = "[" + Bundle.CTL_anonymousFunction() + "]";
        } else {
            NamesTranslator nt = this.getNamesTranslator();
            if (nt != null) {
                name = nt.translateDeclarationNodeName(name);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public NamesTranslator getNamesTranslator() {
        AtomicBoolean atomicBoolean = this.checkNamesTranslator;
        synchronized (atomicBoolean) {
            if (this.checkNamesTranslator.get()) {
                V8Script script;
                this.checkNamesTranslator.set(false);
                SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
                if (smt != null && (script = this.getScript()) != null) {
                    FileObject fo = this.dbg.getScriptsHandler().getFile(script);
                    int line = (int)this.frame.getLine();
                    int column = (int)this.frame.getColumn();
                    if (column < 0) {
                        column = 0;
                    } else if (line == 0) {
                        column -= this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(fo);
                    }
                    this.nt = NamesTranslator.create((SourceMapsTranslator)smt, (FileObject)fo, (int)line, (int)column);
                }
            }
            return this.nt;
        }
    }

    @CheckForNull
    public SourceMapsTranslator.Location getTranslatedLocation() {
        V8Script script;
        SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
        if (smt != null && (script = this.getScript()) != null) {
            FileObject fo = this.dbg.getScriptsHandler().getFile(script);
            int line = (int)this.frame.getLine();
            int column = (int)this.frame.getColumn();
            if (column < 0) {
                column = 0;
            } else if (line == 0) {
                column -= this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(fo);
            }
            return smt.getSourceLocation(new SourceMapsTranslator.Location(fo, line, column));
        }
        return null;
    }
}

