/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PipeInputStream
extends InputStream {
    private static final int INITIAL_SIZE = 128;
    private int[] buffer = new int[128];
    private int start;
    private int end;
    private boolean closed;

    PipeInputStream() {
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.start == this.end && !this.closed) {
            this.inputNeeded();
        }
        while (this.start == this.end) {
            if (this.closed) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            int n = this.buffer[this.start];
            return n;
        }
        finally {
            this.start = (this.start + 1) % this.buffer.length;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int r;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int totalRead = 1;
        while (totalRead < len && this.start != this.end && (r = this.read()) != -1) {
            b[off + totalRead++] = (byte)r;
        }
        return totalRead;
    }

    protected void inputNeeded() throws IOException {
    }

    private synchronized void write(int b) {
        if (this.closed) {
            throw new IllegalStateException("Already closed.");
        }
        int newEnd = (this.end + 1) % this.buffer.length;
        if (newEnd == this.start) {
            int[] newBuffer = new int[this.buffer.length * 2];
            int rightPart = (this.end > this.start ? this.end : this.buffer.length) - this.start;
            int leftPart = this.end > this.start ? 0 : this.start - 1;
            System.arraycopy(this.buffer, this.start, newBuffer, 0, rightPart);
            System.arraycopy(this.buffer, 0, newBuffer, rightPart, leftPart);
            this.buffer = newBuffer;
            this.start = 0;
            this.end = rightPart + leftPart;
            newEnd = this.end + 1;
        }
        this.buffer[this.end] = b;
        this.end = newEnd;
        this.notifyAll();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    public OutputStream createOutput() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                PipeInputStream.this.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    this.write(Byte.toUnsignedInt(b[off + i]));
                }
            }

            @Override
            public void close() throws IOException {
                PipeInputStream.this.close();
            }
        };
    }
}

