/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import org.netbeans.modules.image.ImageDataObject;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.PrintCookie;
import org.openide.text.PrintPreferences;
import org.openide.util.NbBundle;

public class ImagePrintSupport
implements PrintCookie,
Printable,
ImageObserver {
    private final ImageDataObject dataObject;
    private Image image;
    private RenderedImage renderedImage;

    public ImagePrintSupport(ImageDataObject ido) {
        this.dataObject = ido;
    }

    protected static RenderedImage transformImage(RenderedImage image, PageFormat pf) throws IllegalArgumentException {
        try {
            AffineTransform af = new AffineTransform();
            if (pf.getOrientation() != 0) {
                af.translate(pf.getImageableX(), pf.getImageableY());
            }
            if (pf.getImageableWidth() - pf.getImageableX() < (double)image.getWidth() || pf.getImageableHeight() - pf.getImageableY() < (double)image.getHeight()) {
                throw new IllegalArgumentException("Page too small for image");
            }
            AffineTransformOp afo = new AffineTransformOp(af, 1);
            BufferedImage o = (BufferedImage)image;
            BufferedImage i = new BufferedImage(o.getWidth() + (int)pf.getImageableX(), o.getHeight() + (int)pf.getImageableY(), o.getType());
            return afo.filter((BufferedImage)image, i);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        String errMsgKey;
        try {
            this.image = this.dataObject.getImage();
            errMsgKey = this.image == null ? "MSG_CouldNotLoad" : null;
        }
        catch (IOException ex) {
            this.image = null;
            errMsgKey = "MSG_ErrorWhileLoading";
        }
        assert (this.image == null != (errMsgKey == null));
        if (errMsgKey != null) {
            this.displayMessage(errMsgKey, 2);
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pf = PrintPreferences.getPageFormat((PrinterJob)job);
        book.append(this, pf);
        job.setPageable(book);
        try {
            if (this.image instanceof RenderedImage) {
                this.renderedImage = ImagePrintSupport.transformImage((RenderedImage)((Object)this.image), pf);
            }
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterAbortException e) {
            this.displayMessage("CTL_Printer_Abort", 1);
        }
        catch (PrinterException | RuntimeException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            this.renderedImage = null;
            this.image = null;
        }
    }

    private void displayMessage(String msgKey, int msgType) {
        String msg = NbBundle.getMessage(ImagePrintSupport.class, (String)msgKey);
        EventQueue.invokeLater(() -> DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, msgType)));
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
        if (page != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.renderedImage == null) {
            graphics.drawImage(this.image, (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), this);
        } else {
            g2.drawRenderedImage(this.renderedImage, new AffineTransform());
        }
        return 0;
    }

    @Override
    public boolean imageUpdate(Image image, int flags, int param2, int param3, int param4, int param5) {
        return false;
    }
}

