/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Logger;
import nu.validator.collections.HeadBiasedSortedSet;
import nu.validator.collections.TailBiasedSortedSet;
import nu.validator.htmlparser.common.CharacterHandler;
import nu.validator.source.Line;
import nu.validator.source.Location;
import nu.validator.source.LocationRecorder;
import nu.validator.source.Range;
import nu.validator.source.SourceHandler;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class SourceCode
implements CharacterHandler {
    private static final Logger log4j = Logger.getLogger(SourceCode.class.getName());
    private static Location[] SOURCE_LOCATION_ARRAY_TYPE = new Location[0];
    private String uri;
    private String type;
    private String encoding;
    private int expectedLength;
    private final SortedSet<Location> reverseSortedLocations = new HeadBiasedSortedSet(Collections.reverseOrder());
    private final SortedSet<Location> exactErrors = new TailBiasedSortedSet<Location>();
    private final SortedSet<Location> rangeLasts = new TailBiasedSortedSet<Location>();
    private final SortedSet<Integer> oneBasedLineErrors = new TailBiasedSortedSet<Integer>();
    private final List<Line> lines = new ArrayList<Line>();
    private Line currentLine = null;
    private boolean prevWasCr = false;
    private final LocationRecorder locationRecorder = new LocationRecorder(this);
    private boolean isCss = false;

    public void setIsCss() {
        this.isCss = true;
    }

    public boolean getIsCss() {
        return this.isCss;
    }

    public void initialize(InputSource inputSource) {
        this.uri = inputSource.getSystemId();
        this.encoding = inputSource.getEncoding();
        if (inputSource instanceof TypedInputSource) {
            TypedInputSource typedInputSource = (TypedInputSource)inputSource;
            int length = typedInputSource.getLength();
            this.expectedLength = length == -1 ? 2048 : length;
            this.type = typedInputSource.getType();
        } else {
            this.expectedLength = 2048;
            this.type = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int s = start;
        int end = start + length;
        block4: for (int i = start; i < end; ++i) {
            char c = ch[i];
            switch (c) {
                case '\r': {
                    if (s < i) {
                        this.currentLine.characters(ch, s, i - s);
                    }
                    this.newLine();
                    s = i + 1;
                    this.prevWasCr = true;
                    continue block4;
                }
                case '\n': {
                    if (!this.prevWasCr) {
                        if (s < i) {
                            this.currentLine.characters(ch, s, i - s);
                        }
                        this.newLine();
                    }
                    s = i + 1;
                    this.prevWasCr = false;
                    continue block4;
                }
                default: {
                    this.prevWasCr = false;
                }
            }
        }
        if (s < end) {
            this.currentLine.characters(ch, s, end - s);
        }
    }

    private void newLine() {
        char[] buffer;
        int offset;
        if (this.currentLine == null) {
            offset = 0;
            buffer = new char[this.expectedLength];
        } else {
            offset = this.currentLine.getOffset() + this.currentLine.getBufferLength();
            buffer = this.currentLine.getBuffer();
        }
        this.currentLine = new Line(buffer, offset);
        this.lines.add(this.currentLine);
    }

    public void end() throws SAXException {
        if (this.currentLine != null && this.currentLine.getBufferLength() == 0) {
            this.lines.remove(this.lines.size() - 1);
            this.currentLine = null;
        }
    }

    public void start() throws SAXException {
        this.reverseSortedLocations.clear();
        this.lines.clear();
        this.currentLine = null;
        this.newLine();
        this.prevWasCr = false;
    }

    public void addLocatorLocation(int oneBasedLine, int oneBasedColumn) {
        log4j.fine(oneBasedLine + ", " + oneBasedColumn);
        this.reverseSortedLocations.add(new Location(this, oneBasedLine - 1, oneBasedColumn - 1));
    }

    public void exactError(Location location, SourceHandler extractHandler) throws SAXException {
        this.exactErrors.add(location);
        Location start = location.step(-15);
        Location end = location.step(15);
        extractHandler.startSource(this.type, this.encoding);
        this.emitContent(start, location, extractHandler);
        extractHandler.startCharHilite(location.getLine() + 1, location.getColumn() + 1);
        this.emitCharacter(location, extractHandler);
        extractHandler.endCharHilite();
        location = location.next();
        this.emitContent(location, end, extractHandler);
        extractHandler.endSource();
    }

    public void rememberExactError(Location location) {
        if (location.getColumn() < 0 || location.getLine() < 0) {
            return;
        }
        this.exactErrors.add(location);
    }

    public void registerRandeEnd(Locator locator) {
        String systemId = locator.getSystemId();
        if (this.uri == systemId || this.uri != null && this.uri.equals(systemId)) {
            this.rangeLasts.add(this.newLocatorLocation(locator.getLineNumber(), locator.getColumnNumber()));
        }
    }

    public void rangeEndError(Location rangeStart, Location rangeLast, SourceHandler extractHandler) throws SAXException {
        this.reverseSortedLocations.add(rangeLast);
        this.rangeLasts.add(rangeLast);
        Location endRange = rangeLast.next();
        Location start = rangeStart.step(-10);
        if (this.isCss) {
            start = rangeStart.step(-30);
        }
        Location end = endRange.step(6);
        extractHandler.startSource(this.type, this.encoding);
        this.emitContent(start, rangeStart, extractHandler);
        extractHandler.startRange(rangeLast.getLine() + 1, rangeLast.getColumn() + 1);
        this.emitContent(rangeStart, endRange, extractHandler);
        extractHandler.endRange();
        this.emitContent(endRange, end, extractHandler);
        extractHandler.endSource();
    }

    public Location rangeStartForRangeLast(Location rangeLast) {
        for (Location loc : this.reverseSortedLocations) {
            if (loc.compareTo(rangeLast) >= 0) continue;
            return loc.next();
        }
        return new Location(this, 0, 0);
    }

    public void lineError(int oneBasedLine, SourceHandler extractHandler) throws SAXException {
        this.oneBasedLineErrors.add(oneBasedLine);
        Line line = this.lines.get(oneBasedLine - 1);
        extractHandler.startSource(this.type, this.encoding);
        extractHandler.characters(line.getBuffer(), line.getOffset(), line.getBufferLength());
        extractHandler.endSource();
    }

    public boolean isWithinKnownSource(Location location) {
        if (location.getLine() >= this.lines.size()) {
            return false;
        }
        Line line = this.lines.get(location.getLine());
        return line.getBufferLength() >= location.getColumn();
    }

    public boolean isWithinKnownSource(int oneBasedLine) {
        return oneBasedLine <= this.lines.size();
    }

    Line getLine(int line) {
        return this.lines.get(line);
    }

    int getNumberOfLines() {
        return this.lines.size();
    }

    void emitCharacter(Location location, SourceHandler handler) throws SAXException {
        Line line = this.getLine(location.getLine());
        int col = location.getColumn();
        if (col == line.getBufferLength()) {
            handler.newLine();
        } else {
            handler.characters(line.getBuffer(), line.getOffset() + col, 1);
        }
    }

    void emitContent(Location from, Location until, SourceHandler handler) throws SAXException {
        if (from.compareTo(until) >= 0) {
            return;
        }
        int fromLine = from.getLine();
        int untilLine = until.getLine();
        Line line = this.getLine(fromLine);
        if (fromLine == untilLine) {
            try {
                handler.characters(line.getBuffer(), line.getOffset() + from.getColumn(), until.getColumn() - from.getColumn());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            int length = line.getBufferLength() - from.getColumn();
            if (length > 0 && (fromLine != 0 && fromLine != this.lines.size() - 1 || !this.isCss)) {
                handler.characters(line.getBuffer(), line.getOffset() + from.getColumn(), length);
            }
            if (!(fromLine + 1 == this.lines.size() || fromLine == 0 && this.isCss)) {
                handler.newLine();
            }
            int wholeLine = fromLine + 1;
            while (wholeLine < untilLine) {
                line = this.getLine(wholeLine);
                handler.characters(line.getBuffer(), line.getOffset(), line.getBufferLength());
                if (++wholeLine == this.lines.size()) continue;
                handler.newLine();
            }
            int untilCol = until.getColumn();
            if (untilCol > 0) {
                line = this.getLine(untilLine);
                if (untilLine != this.lines.size() - 1 || !this.isCss) {
                    handler.characters(line.getBuffer(), line.getOffset(), untilCol);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitSource(SourceHandler handler) throws SAXException {
        LinkedList<Range> ranges = new LinkedList<Range>();
        Location[] locations = this.reverseSortedLocations.toArray(SOURCE_LOCATION_ARRAY_TYPE);
        int i = locations.length - 1;
        for (Location loc : this.rangeLasts) {
            while (i >= 0 && locations[i].compareTo(loc) < 0) {
                --i;
            }
            Location start = i == locations.length - 1 ? new Location(this, 0, 0) : locations[i + 1].next();
            Location end = loc.next();
            ranges.add(new Range(start, end, loc));
        }
        try {
            Range r;
            handler.startSource(this.type, this.encoding);
            handler.setLineErrors(this.oneBasedLineErrors);
            Iterator rangeIter = ranges.iterator();
            Iterator exactIter = this.exactErrors.iterator();
            Location previousLocation = new Location(this, 0, 0);
            Location exact = null;
            Location rangeStart = null;
            Location rangeEnd = null;
            Location rangeLoc = null;
            if (exactIter.hasNext()) {
                exact = (Location)exactIter.next();
            }
            if (rangeIter.hasNext()) {
                r = (Range)rangeIter.next();
                rangeStart = r.getStart();
                rangeEnd = r.getEnd();
                rangeLoc = r.getLoc();
            }
            while (exact != null || rangeEnd != null) {
                if (!(exact == null || rangeStart != null && exact.compareTo(rangeStart) >= 0 || rangeEnd != null && exact.compareTo(rangeEnd) >= 0)) {
                    this.emitContent(previousLocation, exact, handler);
                    handler.startCharHilite(exact.getLine() + 1, exact.getColumn() + 1);
                    this.emitCharacter(exact, handler);
                    handler.endCharHilite();
                    previousLocation = exact.next();
                    if (exactIter.hasNext()) {
                        exact = (Location)exactIter.next();
                        continue;
                    }
                    exact = null;
                    continue;
                }
                if (rangeStart != null) {
                    this.emitContent(previousLocation, rangeStart, handler);
                    handler.startRange(rangeLoc.getLine() + 1, rangeLoc.getColumn() + 1);
                    previousLocation = rangeStart;
                    rangeStart = null;
                    continue;
                }
                this.emitContent(previousLocation, rangeEnd, handler);
                handler.endRange();
                previousLocation = rangeEnd;
                if (rangeIter.hasNext()) {
                    r = (Range)rangeIter.next();
                    rangeStart = r.getStart();
                    rangeEnd = r.getEnd();
                    rangeLoc = r.getLoc();
                    continue;
                }
                rangeEnd = null;
            }
            if (this.isCss) {
                this.emitContent(previousLocation, new Location(this, this.lines.size() - 1, 0), handler);
            } else {
                this.emitContent(previousLocation, new Location(this, this.lines.size(), 0), handler);
            }
        }
        finally {
            handler.endSource();
        }
    }

    public String getUri() {
        return this.uri;
    }

    public ContentHandler getLocationRecorder() {
        return this.locationRecorder;
    }

    public Location newLocatorLocation(int oneBasedLine, int oneBasedColumn) {
        return new Location(this, oneBasedLine - 1, oneBasedColumn - 1);
    }
}

