/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.execute.Bundle;
import org.netbeans.modules.gradle.execute.GradleExecutor;
import org.netbeans.modules.gradle.execute.GradleExecutorOptionsPanel;
import org.netbeans.modules.gradle.execute.OutputTabMaintainer;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public abstract class AbstractGradleExecutor
extends OutputTabMaintainer<TabContext>
implements GradleExecutor {
    private TabContext tabContext = new TabContext();
    protected ExecutorTask task;
    protected GradleItem item;
    protected RunConfig config;
    protected final Object taskSemaphore = new Object();

    @Override
    protected Class<TabContext> tabContextType() {
        return TabContext.class;
    }

    @Override
    protected final TabContext createContext() {
        return this.tabContext.copy();
    }

    @Override
    protected Action[] createNewTabActions() {
        ArrayList<AbstractAction> ret = new ArrayList<AbstractAction>(4);
        if (this.config.getExecFlags().contains((Object)RunConfig.ExecFlag.REPEATABLE)) {
            this.tabContext.rerun = new ReRunAction(false);
            this.tabContext.rerun.setConfig(this.config);
            ret.add(this.tabContext.rerun);
            this.tabContext.rerunDebug = new ReRunAction(true);
            this.tabContext.rerunDebug.setConfig(this.config);
            ret.add(this.tabContext.rerunDebug);
        }
        this.tabContext.stop = new StopAction();
        this.tabContext.stop.setExecutor(this);
        ret.add(this.tabContext.stop);
        this.tabContext.options = new OptionsAction();
        ret.add(this.tabContext.options);
        return ret.toArray(new Action[0]);
    }

    @Override
    protected void reassignAdditionalContext(TabContext tabContext) {
        this.tabContext = tabContext;
        if (this.config.getExecFlags().contains((Object)RunConfig.ExecFlag.REPEATABLE)) {
            tabContext.rerun.setConfig(this.config);
            tabContext.rerunDebug.setConfig(this.config);
        }
        tabContext.stop.setExecutor(this);
    }

    public AbstractGradleExecutor(RunConfig config) {
        super(config.getTaskDisplayName());
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTask(ExecutorTask task) {
        Object object = this.taskSemaphore;
        synchronized (object) {
            this.task = task;
            this.item = new GradleItem();
            this.taskSemaphore.notifyAll();
        }
    }

    protected final void actionStatesAtStart() {
        AbstractGradleExecutor.invokeUILater(new Runnable(){

            @Override
            public void run() {
                AbstractGradleExecutor.disableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.rerun);
                AbstractGradleExecutor.disableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.rerunDebug);
                AbstractGradleExecutor.enableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.stop);
            }
        });
    }

    protected final void actionStatesAtFinish() {
        AbstractGradleExecutor.invokeUILater(new Runnable(){

            @Override
            public void run() {
                AbstractGradleExecutor.enableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.rerun);
                AbstractGradleExecutor.enableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.rerunDebug);
                AbstractGradleExecutor.disableAction(((AbstractGradleExecutor)AbstractGradleExecutor.this).tabContext.stop);
            }
        });
    }

    protected final void checkForExternalModifications() {
        Project project = this.config.getProject();
        if (project != null) {
            project.getProjectDirectory().refresh();
            GradleBaseProject bp = GradleBaseProject.get(this.config.getProject());
            File buildDir = bp.getBuildDir();
            if (buildDir != null) {
                FileUtil.refreshFor((File[])new File[]{buildDir});
            }
        }
    }

    private static void enableAction(Action a) {
        if (a != null) {
            a.setEnabled(true);
        }
    }

    private static void disableAction(Action a) {
        if (a != null) {
            a.setEnabled(false);
        }
    }

    private static void invokeUILater(Runnable runnable) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        EventQueue.invokeLater(runnable);
    }

    public static final class TabContext {
        ReRunAction rerun;
        ReRunAction rerunDebug;
        StopAction stop;
        OptionsAction options;

        protected TabContext copy() {
            TabContext c = new TabContext();
            c.rerun = this.rerun;
            c.rerunDebug = this.rerunDebug;
            c.stop = this.stop;
            c.options = this.options;
            return c;
        }
    }

    static class ReRunAction
    extends AbstractAction {
        private RunConfig config;
        private final boolean debug;

        ReRunAction(boolean debug) {
            this.debug = debug;
            this.putValue("SmallIcon", debug ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gradle/resources/refreshdebug.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gradle/resources/refresh.png", (boolean)false));
            this.putValue("Name", debug ? Bundle.TXT_Rerun_extra() : Bundle.TXT_Rerun());
            this.putValue("ShortDescription", debug ? Bundle.TIP_Rerun_Extra() : Bundle.TIP_Rerun());
            this.setEnabled(false);
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.debug) {
                GradleExecutorOptionsPanel pnl = new GradleExecutorOptionsPanel(this.config.getProject());
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_Gradle());
                pnl.setCommandLine(this.config.getCommandLine(), this.config.getExecConfig());
                Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (retValue == DialogDescriptor.OK_OPTION) {
                    GradleCommandLine cmd = pnl.getCommandLine();
                    pnl.rememberAs();
                    this.setConfig(this.config.withCommandLine(cmd));
                    RunUtils.executeGradle(this.config, null);
                }
            } else {
                RunUtils.executeGradle(this.config, null);
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        private AbstractGradleExecutor exec;

        StopAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gradle/resources/stop.png", (boolean)false));
            this.putValue("Name", Bundle.TXT_Stop_execution());
            this.putValue("ShortDescription", Bundle.TIP_Stop_Execution());
            this.setEnabled(false);
        }

        void setExecutor(AbstractGradleExecutor ex) {
            this.exec = ex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    exec.cancel();
                }
            });
        }
    }

    public static final class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            super(Bundle.LBL_OptionsAction(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gradle/resources/options.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.LBL_OptionsAction());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Java/Gradle");
        }
    }

    protected class GradleItem
    implements BuildExecutionSupport.ActionItem {
        protected GradleItem() {
        }

        public String getAction() {
            return AbstractGradleExecutor.this.config.getActionName() != null ? AbstractGradleExecutor.this.config.getActionName() : "xxx-custom";
        }

        public FileObject getProjectDirectory() {
            return AbstractGradleExecutor.this.config.getProject().getProjectDirectory();
        }

        public String getDisplayName() {
            return AbstractGradleExecutor.this.config.getTaskDisplayName();
        }

        public void repeatExecution() {
        }

        public boolean isRunning() {
            return !AbstractGradleExecutor.this.task.isFinished();
        }

        public void stopRunning() {
            AbstractGradleExecutor.this.cancel();
        }
    }
}

