/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.wsclient;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class CustomizerWSClientHost
extends JPanel
implements PropertyChangeListener,
HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private AppClientProjectProperties j2seProperties;
    private WsCompileClientEditorSupport.Panel wsCompileEditor;
    private List serviceSettings;

    public CustomizerWSClientHost(AppClientProjectProperties j2seProperties, List serviceSettings) {
        assert (serviceSettings != null);
        this.initComponents();
        this.j2seProperties = j2seProperties;
        this.wsCompileEditor = null;
        this.serviceSettings = serviceSettings;
        if (serviceSettings.size() > 0) {
            this.initValues();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JPanel component = this.wsCompileEditor.getComponent();
        this.removeAll();
        this.add(component);
        component.addPropertyChangeListener("featuresChanged", this);
        component.addPropertyChangeListener("optionsChanged", this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JPanel component = this.wsCompileEditor.getComponent();
        component.removePropertyChangeListener("featuresChanged", this);
        component.removePropertyChangeListener("optionsChanged", this);
    }

    public void initValues() {
        if (this.wsCompileEditor == null) {
            WsCompileClientEditorSupport editorSupport = (WsCompileClientEditorSupport)Lookup.getDefault().lookup(WsCompileClientEditorSupport.class);
            this.wsCompileEditor = editorSupport.getWsCompileSupport();
        }
        this.wsCompileEditor.initValues(this.serviceSettings);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println("WSClientCustomizer: propertyChange - " + evt.getPropertyName());
        String prop = evt.getPropertyName();
        if ("featuresChanged".equals(prop)) {
            WsCompileClientEditorSupport.FeatureDescriptor newFeatureDesc = (WsCompileClientEditorSupport.FeatureDescriptor)evt.getNewValue();
            String propertyName = "wscompile.client." + newFeatureDesc.getServiceName() + ".features";
            this.j2seProperties.putAdditionalProperty(propertyName, newFeatureDesc.getFeatures());
        } else if ("optionsChanged".equals(prop)) {
            WsCompileClientEditorSupport.OptionDescriptor oldOptionDesc = (WsCompileClientEditorSupport.OptionDescriptor)evt.getOldValue();
            WsCompileClientEditorSupport.OptionDescriptor newOptionDesc = (WsCompileClientEditorSupport.OptionDescriptor)evt.getNewValue();
            boolean[] oldOptions = oldOptionDesc.getOptions();
            boolean[] newOptions = newOptionDesc.getOptions();
            String serviceName = newOptionDesc.getServiceName();
            String[] propertyNames = new String[]{"verbose", "debug", "xPrintStackTrace", "xSerializable", "optimize"};
            for (int i = 0; i < newOptions.length; ++i) {
                if (oldOptions[i] == newOptions[i]) continue;
                this.j2seProperties.putAdditionalProperty("wscompile.client." + serviceName + "." + propertyNames[i], newOptions[i] ? "true" : "false");
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerWSClientHost.class);
    }
}

